/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.usermanagement;

import eu.dnetlib.openaire.user.utils.InputValidator;
import eu.dnetlib.openaire.user.utils.LDAPActions;
import eu.dnetlib.openaire.user.utils.VerificationActions;
import eu.dnetlib.openaire.usermanagement.utils.UrlConstructor;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

public class AddPasswordServlet
extends HttpServlet {
    @Autowired
    private VerificationActions verificationActions;
    @Autowired
    private LDAPActions ldapActions;
    private Logger logger = Logger.getLogger(AddPasswordServlet.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        SpringBeanAutowiringSupport.processInjectionBasedOnServletContext((Object)this, (ServletContext)config.getServletContext());
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        PrintWriter printWriter = response.getWriter();
        HttpSession session = request.getSession();
        String username = (String)session.getAttribute("username");
        if (username == null) {
            this.logger.info((Object)"Empty username in session");
        }
        String password = request.getParameter("password");
        String confirmPassword = request.getParameter("password_conf");
        if (InputValidator.isFilled((String)password)) {
            if (InputValidator.isValidPassword((String)password) && password.equals(confirmPassword) && username != null) {
                try {
                    this.ldapActions.resetPassword(username, password);
                    this.logger.info((Object)"password added");
                    session.removeAttribute("username");
                    response.sendRedirect(UrlConstructor.getRedirectUrl((HttpServletRequest)request, (String)"success.jsp"));
                }
                catch (Exception e) {
                    this.logger.error((Object)"LDAP error in adding password", (Throwable)e);
                    response.sendRedirect(UrlConstructor.getRedirectUrl((HttpServletRequest)request, (String)"error.jsp"));
                }
            } else {
                if (!InputValidator.isValidPassword((String)password)) {
                    this.logger.info((Object)"No valid password");
                }
                if (!password.equals(confirmPassword)) {
                    this.logger.info((Object)"No matching passwords");
                }
                response.sendRedirect("./addPassword.jsp");
            }
        } else {
            this.logger.info((Object)"Empty password");
            request.getSession().setAttribute("msg_password_error_display", (Object)"display:block");
            response.sendRedirect("./resetPassword.jsp");
        }
        printWriter.close();
    }
}

