/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.usermanagement;

import eu.dnetlib.openaire.user.utils.InputValidator;
import eu.dnetlib.openaire.user.utils.LDAPActions;
import eu.dnetlib.openaire.user.utils.VerificationActions;
import eu.dnetlib.openaire.usermanagement.VerificationCodeServlet;
import eu.dnetlib.openaire.usermanagement.utils.UrlConstructor;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

public class VerifyToDeleteServlet
extends HttpServlet {
    @Autowired
    private VerificationActions verificationActions;
    @Autowired
    private LDAPActions ldapActions;
    private Logger logger = Logger.getLogger(VerificationCodeServlet.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        SpringBeanAutowiringSupport.processInjectionBasedOnServletContext((Object)this, (ServletContext)config.getServletContext());
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        PrintWriter printWriter = response.getWriter();
        String formUsername = request.getParameter("username").trim();
        String formVerificationCode = request.getParameter("verification_code").trim();
        try {
            if (InputValidator.isFilled((String)formUsername) && InputValidator.isFilled((String)formVerificationCode)) {
                if (this.verificationActions.verificationEntryExists(formUsername) && this.verificationActions.verificationCodeIsCorrect(formUsername, formVerificationCode)) {
                    if (!this.verificationActions.verificationCodeHasExpired(formUsername)) {
                        Boolean isRegistered = false;
                        Boolean isZombie = false;
                        if (this.ldapActions.usernameExists(formUsername)) {
                            this.logger.info((Object)("User " + formUsername + " is activated user!"));
                            isRegistered = true;
                        } else if (this.ldapActions.isZombieUsersUsername(formUsername)) {
                            this.logger.info((Object)("User " + formUsername + " is zombie user!"));
                            isZombie = true;
                        }
                        if (!isRegistered.booleanValue() && !isZombie.booleanValue()) {
                            request.getSession().setAttribute("message", (Object)"Username or verification code are not valid.");
                            response.sendRedirect("./verifyToDelete.jsp");
                        } else {
                            if (isRegistered.booleanValue()) {
                                this.ldapActions.deleteUser(formUsername);
                            } else if (isZombie.booleanValue()) {
                                this.ldapActions.deleteZombieUser(formUsername);
                            }
                            this.verificationActions.deleteVerificationEntry(formUsername);
                            response.sendRedirect(UrlConstructor.getRedirectUrl((HttpServletRequest)request, (String)"successDeleteAccount.jsp"));
                        }
                    } else {
                        this.logger.info((Object)"Verification code has expired!");
                        response.sendRedirect(UrlConstructor.getRedirectUrl((HttpServletRequest)request, (String)"expiredVerificationCode.jsp"));
                    }
                } else {
                    this.logger.info((Object)"Username or verification code are not valid!");
                    request.getSession().setAttribute("message", (Object)"Username or verification code are not valid.");
                    response.sendRedirect("./verifyToDelete.jsp");
                }
            } else {
                if (!InputValidator.isFilled((String)formUsername)) {
                    this.logger.info((Object)"No username");
                    request.getSession().setAttribute("msg_username_error", (Object)"Please enter your username.");
                }
                if (!InputValidator.isFilled((String)formVerificationCode)) {
                    this.logger.info((Object)"No verification code");
                    request.getSession().setAttribute("msg_verification_code_error", (Object)"Please enter your verification code.");
                }
                response.sendRedirect("./verifyToDelete.jsp");
            }
        }
        catch (Exception ldape) {
            this.logger.error((Object)("Could not remove user with username " + formUsername), (Throwable)ldape);
            response.sendRedirect(UrlConstructor.getRedirectUrl((HttpServletRequest)request, (String)"error.jsp"));
        }
        printWriter.close();
    }
}

