/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.usermanagement.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.mitre.openid.connect.model.OIDCAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component(value="AuthorizationService")
public class AuthorizationService {
    public final String PORTAL_ADMIN = "PORTAL_ADMINISTRATOR";
    public final String ANONYMOUS_USER = "ROLE_ANONYMOUS";
    public final String REGISTERED_USER = "REGISTERED_USER";

    private String mapType(String type, boolean communityMap) {
        if (type.equals("organization")) {
            type = "institution";
        } else if (type.equals("ri") && communityMap) {
            type = "community";
        }
        return type;
    }

    public String curator(String type) {
        return "CURATOR_" + this.mapType(type, true).toUpperCase();
    }

    public String manager(String type, String id) {
        return this.mapType(type, true).toUpperCase() + "_" + id.toUpperCase() + "_MANAGER";
    }

    public String member(String type, String id) {
        return this.mapType(type, false).toUpperCase() + "_" + id.toUpperCase();
    }

    public boolean isCommunity(String type) {
        return this.mapType(type, false).equals("community");
    }

    public boolean isPortalAdmin() {
        return this.getRoles().stream().anyMatch(authority -> authority.equalsIgnoreCase("PORTAL_ADMINISTRATOR"));
    }

    public boolean isCurator(String type) {
        return this.getRoles().stream().anyMatch(authority -> authority.equalsIgnoreCase(this.curator(type)));
    }

    public boolean isManager(String type, String id) {
        return this.getRoles().stream().anyMatch(authority -> authority.equalsIgnoreCase(this.manager(type, id)));
    }

    public boolean isMember(String type, String id) {
        return this.getRoles().stream().anyMatch(authority -> authority.equalsIgnoreCase(this.member(type, id)));
    }

    public List<String> getRoles() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof OIDCAuthenticationToken) {
            return authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public String getAaiId() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication instanceof OIDCAuthenticationToken ? ((OIDCAuthenticationToken)authentication).getSub() : null;
    }

    public String getEmail() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication instanceof OIDCAuthenticationToken ? ((OIDCAuthenticationToken)authentication).getUserInfo().getEmail() : null;
    }
}

