/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.usermanagement.utils;

import com.google.gson.Gson;
import eu.dnetlib.openaire.usermanagement.ServiceResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class TokenUtils {
    private Logger logger = Logger.getLogger(TokenUtils.class);
    @Value(value="${oidc.issuer}")
    private String issuer;

    public String registerService(String serverRequestJSON) throws IOException {
        HttpPost httppost = new HttpPost(this.issuer + "register");
        httppost.setHeader("Content-Type", "application/json");
        StringEntity params = new StringEntity(serverRequestJSON);
        httppost.setEntity((HttpEntity)params);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        CloseableHttpResponse httpResponse = httpclient.execute((HttpUriRequest)httppost);
        if (httpResponse.getStatusLine().getStatusCode() == 201) {
            return IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (String)StandardCharsets.UTF_8.name());
        }
        return null;
    }

    public HttpResponse updateService(String serviceId, String serviceSON, String registeredAccessToken) throws IOException {
        HttpPut httpPut = new HttpPut(this.issuer + "register/" + serviceId);
        httpPut.setHeader("Content-Type", "application/json");
        httpPut.setHeader("Authorization", "Bearer " + registeredAccessToken);
        StringEntity params = new StringEntity(serviceSON.toString());
        httpPut.setEntity((HttpEntity)params);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        return httpclient.execute((HttpUriRequest)httpPut);
    }

    public HttpResponse deleteService(String serviceId, String registeredAccessToken) throws IOException {
        HttpDelete httpDelete = new HttpDelete(this.issuer + "register/" + serviceId);
        httpDelete.setHeader("Content-Type", "application/json");
        httpDelete.setHeader("Authorization", "Bearer " + registeredAccessToken);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        return httpclient.execute((HttpUriRequest)httpDelete);
    }

    public ServiceResponse getRegisteredService(String serviceId, String registeredAccessToken) throws IOException {
        HttpGet httpGet = new HttpGet(this.issuer + "register/" + serviceId);
        httpGet.setHeader("Authorization", "Bearer " + registeredAccessToken);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        CloseableHttpResponse httpResponse = httpclient.execute((HttpUriRequest)httpGet);
        String registeredService = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (String)StandardCharsets.UTF_8.name());
        return (ServiceResponse)new Gson().fromJson(registeredService, ServiceResponse.class);
    }

    public void viewRegisteredServices(List<String> serviceIds, String registeredAccessToken) throws IOException {
        for (String serviceId : serviceIds) {
            this.getRegisteredService(serviceId, registeredAccessToken);
        }
    }
}

