function validateForm() {

    var email = $("#email").val();
    var email_conf = $("#email_conf").val();
    var password = $("#password").val();
    var password_conf = $("#password_conf").val();

    var isValidEmail = validateEmail(email);
    var isValidPassword = validatePassword(password);
    var hasError = false;
    var isUsernameFilled = false;
    var isEmailFilled = false;
    var isPasswordFilled = false;

    // Check if first name is filled
    if($("#first_name").val() != undefined) {
        if($.trim($("#first_name").val()).length <= 0) {
            $("#first_name").addClass('uk-input aai-form-danger');
            $(".msg_first_name_error").show();
        } else {
            $(".msg_first_name_error").hide();
            $("#first_name").removeClass('aai-form-danger');
        }
    }

    // Check if last name is filled
    if($("#last_name").val() != undefined) {
        if($.trim($("#last_name").val()).length <= 0) {
            $("#last_name").addClass('uk-input aai-form-danger');
            $(".msg_last_name_error").show();
        } else {
            $(".msg_last_name_error").hide();
            $("#last_name").removeClass('aai-form-danger');
        }
    }

    // // Check if organization is filled
    // if($("#organization").val() != undefined) {
    //     if($.trim($("#organization").val()).length <= 0) {
    //         $("#organization").addClass('uk-input aai-form-danger');
    //         $(".msg_organization_error").show();
    //     } else {
    //         $(".msg_organization_error").hide();
    //         $("#organization").removeClass('aai-form-danger');
    //     }
    // }

    // Check if username is filled
    if($("#username").val() != undefined) {
        if($.trim($("#username").val()).length <= 0) {
            $("#username").addClass('uk-input aai-form-danger');
            $(".msg_username_error").show();
            hasError = true;
        } else {
            isUsernameFilled = true;
            $(".msg_username_error").hide();
            $("#username").removeClass('aai-form-danger');
        }
    }

    if($("#verification_code").val() != undefined) {
        if($.trim($("#verification_code").val()).length <= 0) {
            $("#verification_code").addClass('uk-input aai-form-danger');
            $(".msg_verification_code_error").show();
            $(".msg_activation_code_error").show();
            hasError = true;
        } else {
            $(".msg_verification_code_error").hide();
            $(".msg_activation_code_error").hide();
            $("#verification_code").removeClass('aai-form-danger');
        }
    }

    // Check if email is filled
    if($("#email").val() != undefined) {
        if($.trim($("#email").val()).length <= 0) {
            $("#email").addClass('uk-input aai-form-danger');
            $(".msg_email_error").show();
            hasError = true;
        } else {
            isEmailFilled = true;
            $(".msg_email_error").hide();
            $("#email").removeClass('aai-form-danger');
        }
    }

    // If email is filled
    if (isEmailFilled) {
        // Check if email is valid
        if (!isValidEmail) {
    	   $("#email").addClass('uk-input aai-form-danger');
    	   $(".msg_email_validation_error").show();
    	   hasError = true;
        } else {
    	   $(".msg_email_validation_error").hide();
           $("#email").removeClass('aai-form-danger');
        }

        if ($("#email_conf").val() != undefined) {
            // Check if emails match
            if (isValidEmail && !confirm(email, email_conf)) {
               $("#email").addClass('uk-input aai-form-danger');
               $("#email_conf").addClass('uk-input aai-form-danger');
               $(".msg_email_conf_error").show();
               hasError = true;
            } else {
               $(".msg_email_conf_error").hide();
               $("#email").removeClass('aai-form-danger');
               $("#email_conf").removeClass('aai-form-danger');
            }
        }
    }


    //Check if password is filled
    if($("#password").val() != undefined) {
        if($.trim($("#password").val()).length <= 0) {
            $("#password").addClass('uk-input aai-form-danger');
            $(".msg_password_error").show();
        } else {
            isPasswordFilled = true;
            $(".msg_password_error").hide();
            $("#password").removeClass('aai-form-danger');
            $("#password_conf").removeClass('aai-form-danger');
        }

        if(isPasswordFilled) {
            // Check if passwords match
            if (!confirm(password, password_conf)) {
                $("#password").addClass('uk-input aai-form-danger');
                $("#password_conf").addClass('uk-input aai-form-danger');
                $(".msg_pass_conf_error").show();
                hasError = true;
            } else {
                $(".msg_pass_conf_error").hide();
            }
        }

        if(!isValidPassword) {
            $("#password").addClass('uk-input aai-form-danger');
            $(".msg_please_add").show();
            $(".msg_lowercase_letter").show();
            $(".msg_capital_letter").show();
            $(".msg_number").show();
            $(".msg_lenght").show();
            hasError = true;
        } else {
            $("#password").removeClass('aai-form-danger');
            $(".msg_please_add").hide();
            $(".msg_lowercase_letter").hide();
            $(".msg_capital_letter").hide();
            $(".msg_number").hide();
            $(".msg_lenght").hide();
        }
    }

    var recaptcha = grecaptcha.getResponse();
    if (recaptcha!=null && recaptcha !== undefined && recaptcha.length > 0) {
        $(".recaptcha_error").hide();

    } else {
        hasError = true;
        $(".recaptcha_error").show();
    }

    return !hasError;
}

function validatePasswordForm() {

    var password = $("#password").val();
    var password_conf = $("#password_conf").val();
    var isValidPassword = validatePassword(password);
    var hasError = false;
    var isPasswordFilled = false;

    // Check if password is filled
    if ($("#password").val() != undefined) {
        if ($.trim($("#password").val()).length <= 0) {
            $("#password").addClass('uk-input aai-form-danger');
            $(".msg_password_error").show();
        } else {
            isPasswordFilled = true;
            $(".msg_password_error").hide();
            $("#password").removeClass('aai-form-danger');
            $("#password_conf").removeClass('aai-form-danger');
        }

        if (isPasswordFilled) {
            // Check if passwords match
            if (!confirm(password, password_conf)) {
                $("#password").addClass('uk-input aai-form-danger');
                $("#password_conf").addClass('uk-input aai-form-danger');
                $(".msg_pass_conf_error").show();
                hasError = true;
            } else {
                $(".msg_pass_conf_error").hide();
            }
        }

        if (!isValidPassword) {
            $("#password").addClass('uk-input aai-form-danger');
            $(".msg_please_add").show();
            $(".msg_lowercase_letter").show();
            $(".msg_capital_letter").show();
            $(".msg_number").show();
            $(".msg_lenght").show();
            hasError = true;
        } else {
            $("#password").removeClass('aai-form-danger');
            $(".msg_please_add").hide();
            $(".msg_lowercase_letter").hide();
            $(".msg_capital_letter").hide();
            $(".msg_number").hide();
            $(".msg_lenght").hide();
        }
    }

    return !hasError;
}

function validateEmail(email) {
    var re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    return re.test(email);
}

function validatePassword(password) {
    var pattern = /^(?=.*[^a-zA-Z])(?=.*[a-z])(?=.*[A-Z])\S{6,}$/;
    return pattern.test(password);
}

function confirm(first, second) {
    if (first == second)
        return true;
    else
        return false;
}

function loginForm(){

    // Check if username is filled
    if($.trim($("#login_username").val()).length <= 0) {
        $("#login_username").addClass('uk-input aai-form-danger');
        $(".msg_login_username_error").show();
    } else {
        $(".msg_login_username_error").hide();
        $("#login_username").removeClass('aai-form-danger');
    }

    // Check if password is filled
    if($.trim($("#login_password").val()).length <= 0) {
        $("#login_password").addClass('uk-input aai-form-danger');
        $(".msg_login_password_error").show();
    } else {
        isPasswordFilled = true;
        $(".msg_login_password_error").hide();
        $("#login_password").removeClass('aai-form-danger');
    }
}
