<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<!DOCTYPE html>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<html lang="en-gb" dir="ltr" vocab="http://schema.org/">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <base href=".">
    <title>OpenAIRE - Registered services</title>
    <script src="./js/jquery.js"></script>
    <script src="./js/uikit.min.js"></script>
    <script src="./js/validation.js"></script>
    <script src="./js/uikit-icons-max.js"></script>
    <link rel="stylesheet" style="text/css" href="./css/theme.css">
    <link rel="stylesheet" style="text/css" href="./css/custom.css">
    <link rel="stylesheet" style="text/css" href="./css/aai-custom.css">
    <link rel="icon" type="image/png" sizes="32x32" href="images/favicon/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="96x96" href="images/favicon//favicon-96x96.png">
    <link rel="icon" type="image/png" sizes="16x16" href="images/favicon/favicon-16x16.png">
    <link href="images/favicon/favicon.ico" rel="shortcut icon" type="image/vnd.microsoft.icon"/>
    <%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
</head>
<body class="" style="" onload="success();">
<div class="uk-offcanvas-content uk-height-viewport">
    <jsp:include page="header.jsp"/>
    <!-- CONTENT STARTS HERE -->
    <div class=" uk-section  uk-margin-small-top uk-container uk-container-large" id="tm-main">
        <div class="uk-grid ">
            <div class="uk-width-1-4@m">
                <div class="uk-card uk-card-default uk-card-body">
                    <div class="uk-h4">API Access</div>
                    <ul class="uk-nav uk-nav-default">
                        <li class=""><a href="./personalToken">Personal token</a></li>
                        <li class="uk-active"><a href="./registeredServices">Registered services</a></li>
                    </ul>
                </div>
            </div>
            <!-- CENTER SIDE -->
            <div class="uk-width-2-3@l uk-width-2-3@m">
                <div class="uk-grid" uk-grid>
                    <div class="uk-width-expand@m">
                        <h4 class="uk-margin-remove-top uk-text-bold uk-text-primary">Registered services</h4>
                        <c:if test="${message != null}">
                            <div class="uk-text-danger uk-margin-small-bottom">${message}</div>
                            <c:remove var="message" scope="session"/>
                        </c:if>


                    </div>
                    <div class="uk-text-center uk-width-auto@m">
                        <c:choose>
                            <c:when test="${not reachedLimit}">
                                <a class="uk-button uk-button-primary" href="./registerService">
                                    <span class="uk-icon" uk-icon="icon:plus-circle"></span>
                                    <span class="uk-margin-small-left">New service</span>
                                </a>
                            </c:when>
                            <c:otherwise>
                                <button class="uk-button uk-button-default" disabled>
                                    <span class="uk-icon" uk-icon="icon:plus-circle"></span>
                                    <span class="uk-margin-small-left">New service</span>
                                </button>
                            </c:otherwise>
                        </c:choose>
                        <c:remove var="reachedLimit" scope="session"/>
                    </div>
                </div>
                <div class="uk-margin-top">
                    <div class="uk-alert-primary uk-alert uk-margin-top-remove uk-flex uk-flex-middle">
                        <span uk-icon="info"></span>
                        <span class="uk-margin-small-left">You can register up to 5 services.
                        For more information please read the <a href="https://graph.openaire.eu/develop/authentication.html" target="_blank">OpenAIRE API Authentication documentation</a>.</span>
                    </div>
                    <c:if test="${reachedLimit}">
                        <div class="uk-alert-warning uk-flex uk-flex-middle uk-margin-small-top">
                            <span uk-icon="warning"></span>
                            <span class="uk-margin-small-left">You have reached the maximum size of allowed registered services.</span>
                        </div>
                    </c:if>
                    <c:if test="${empty registeredServices && showEmptyList}">
                        <div class="uk-text-center">You have not registered any service yet!</div>
                    </c:if>
                    <c:if test="${registeredServices.size() > 0}">
                        <ul class="uk-list uk-list-divider">
                            <li>
                                <div class="uk-grid uk-child-width-1-4 uk-text-muted" uk-grid>
                                    <div>Name</div>
                                    <div>Client Id</div>
                                    <div>Creation Date</div>
                                    <div>Actions</div>
                                </div>
                            </li>
                            <c:forEach items="${registeredServices}" var="registeredService" varStatus="loop">
                                <c:set var="key" value="${registeredService.id}"/>
                                <li>
                                    <div class="uk-grid uk-child-width-1-4" uk-grid>
                                        <div>
                                            <a uk-toggle="target: #details${registeredService.id}; animation: uk-animation-fade">
                                                <span>${registeredService.name}</span>
                                                <span class="space" uk-icon="icon:info;ratio:0.7"></span>
                                            </a>
                                        </div>
                                        <div>
                                            <span>${registeredService.clientId}</span>
                                        </div>
                                        <div><fmt:formatDate value="${registeredService.date}"
                                                             pattern="dd-MM-yyyy HH:mm"/>
                                        </div>
                                        <div>
                                            <a href="./registerService?id=${registeredService.id}" class="uk-margin-small-right">
                                                <span uk-icon="pencil"></span>
                                            </a>
                                            <a class="uk-text-danger" uk-icon="trash" uk-toggle="target: #modal${registeredService.id}"></a>

                                                <!-- This is the modal -->
                                                <div id="modal${registeredService.id}" uk-modal>
                                                    <div class="uk-modal-dialog uk-modal-body">
                                                        <form name="delete${registeredService.id}"
                                                              id="delete${registeredService.id}" method="post">
                                                            <input type="hidden" name="id"
                                                                   value="${registeredService.id}"/>
                                                            <h2 class="uk-margin-remove-top">Delete service</h2>
                                                            <div class="uk-margin-medium-bottom">
                                                                Are you sure you want to delete the
                                                                '${registeredService.name}' service? You cannot undo
                                                                this action!
                                                            </div>
                                                            <div class="uk-text-right">
                                                                <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel
                                                                </button>
                                                                <button class="uk-button uk-button-danger uk-margin-small-left" type="button"
                                                                        onclick="document.delete${registeredService.id}.submit();document.getElementById('modal${registeredService.id}').style.visibility='hidden';">
                                                                    Delete
                                                                </button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                        </div>
                                    </div>
                                </li>
                                <li id="details${registeredService.id}" hidden="hidden">
                                    <div class="uk-alert">
                                        <p><span class="uk-text-primary">Name:</span> ${services[key].clientName}</p>
                                        <p><span class="uk-text-primary">Client Id:</span> ${services[key].clientId}</p>
                                        <p><span class="uk-text-primary">Scope:</span> openid</p>
                                        <p><span class="uk-text-primary">Grant type:</span> client credentials</p>
                                        <c:choose>
                                            <c:when test="${registeredService.keyType == null}">
                                                <p><span class="uk-text-primary">Client secret:</span> ${services[key].clientSecret}</p>
                                                <p><span class="uk-text-primary">Authentication Method</span> Client Secret Basic</p>
                                            </c:when>
                                            <c:otherwise>
                                                <p><span class="uk-text-primary">Authentication Method</span> Asymmetrically-signed JWT assertion</p>
                                                <p><span class="uk-text-primary">Token Endpoint Authentication Signing Algorithm</span> RSASSA using
                                                    SHA-256 hash algorithm</p>
                                                <p><span class="uk-text-primary">Public Key</span>
                                                <pre><code>${keys[key]}</code></pre>
                                                </p>
                                            </c:otherwise>
                                        </c:choose>
                                        <p><span class="uk-text-primary">Creation Date:</span>
                                            <jsp:useBean id="date" class="java.util.Date"/>
                                            <jsp:setProperty name="date" property="time" value="${services[key].clientIdIssuedAt*1000}"/>
                                            <fmt:formatDate value="${date}"
                                                            pattern="dd-MM-yyyy HH:mm"/>
                                        </p>
                                    </div>
                                </li>
                            </c:forEach>
                        </ul>
                    </c:if>
            </div>
            <!-- END OF CENTER SIDE -->
        </div>
        </div>
    </div>
    <!-- CONTENT ENDS HERE -->
    <c:import url="footer.jsp"/>
</body>
</html>
<script>
    function success() {
        if('${success}' !=='')
            UIkit.modal.alert('${success}');
    }
</script>
<c:remove var="success" scope="session"/>


