/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.usermanagement;

import com.google.gson.Gson;
import eu.dnetlib.openaire.usermanagement.RefreshToken;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.log4j.Logger;
import org.mitre.openid.connect.client.service.impl.StaticClientConfigurationService;
import org.mitre.openid.connect.model.OIDCAuthenticationToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

public class PersonalTokenServlet
extends HttpServlet {
    @Value(value="${oidc.secret}")
    private String secret;
    @Value(value="${oidc.id}")
    private String id;
    @Value(value="${oidc.issuer}")
    private String issuer;
    @Autowired
    private StaticClientConfigurationService staticClientConfigurationService;
    private Logger logger = Logger.getLogger(PersonalTokenServlet.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        SpringBeanAutowiringSupport.processInjectionBasedOnServletContext((Object)this, (ServletContext)config.getServletContext());
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        OIDCAuthenticationToken authentication = (OIDCAuthenticationToken)SecurityContextHolder.getContext().getAuthentication();
        StringBuilder name = new StringBuilder().append(authentication.getUserInfo().getGivenName().charAt(0));
        name.append(authentication.getUserInfo().getFamilyName().charAt(0));
        request.getSession().setAttribute("name", (Object)name.toString());
        request.getSession().setAttribute("accessToken", (Object)authentication.getAccessTokenValue());
        request.getSession().setAttribute("refreshToken", (Object)authentication.getRefreshTokenValue());
        request.getRequestDispatcher("./personal.jsp").include((ServletRequest)request, (ServletResponse)response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        OIDCAuthenticationToken authentication = (OIDCAuthenticationToken)SecurityContextHolder.getContext().getAuthentication();
        String refreshToken = authentication.getRefreshTokenValue();
        List oldRefreshTokens = null;
        try {
            oldRefreshTokens = this.getOldRefreshTokens(authentication.getRefreshTokenValue(), authentication.getAccessTokenValue());
            this.deleteOldRefreshTokens(oldRefreshTokens, authentication.getAccessTokenValue());
        }
        catch (IOException e) {
            this.logger.error((Object)"Error deleting old refresh tokens.", (Throwable)e);
        }
        request.getSession().setAttribute("showRefreshToken", (Object)true);
        response.sendRedirect("./personalToken");
    }

    private void deleteOldRefreshTokens(List<String> oldRefreshTokens, String accessToken) throws IOException {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        for (String refreshTokenId : oldRefreshTokens) {
            HttpDelete httpDelete = new HttpDelete(this.issuer + "/api/tokens/refresh/" + refreshTokenId);
            httpDelete.setHeader("Authorization", "Bearer " + accessToken);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpDelete);
            if (response.getStatusLine().getStatusCode() == 200) continue;
            this.logger.warn((Object)("Could not delete old refresh tokens." + response.getStatusLine().getStatusCode()));
        }
    }

    private List<String> getOldRefreshTokens(String currentRefreshToken, String accessToken) throws IOException {
        HttpGet httpGet = new HttpGet(this.issuer + "/api/tokens/refresh");
        httpGet.setHeader("Authorization", "Bearer " + accessToken);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        String jsonResponse = IOUtils.toString((InputStream)httpclient.execute((HttpUriRequest)httpGet).getEntity().getContent(), (String)StandardCharsets.UTF_8.name());
        Gson gson = new Gson();
        ArrayList<String> oldRefreshTokens = null;
        for (RefreshToken refreshToken : (RefreshToken[])gson.fromJson(jsonResponse, RefreshToken[].class)) {
            if (oldRefreshTokens == null) {
                oldRefreshTokens = new ArrayList<String>();
            }
            if (refreshToken.getValue().equals(currentRefreshToken)) continue;
            oldRefreshTokens.add(refreshToken.getId() + "");
        }
        return oldRefreshTokens;
    }
}

