/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.usermanagement.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.dnetlib.openaire.user.pojos.RoleVerification;
import eu.dnetlib.openaire.user.utils.EmailSender;
import eu.dnetlib.openaire.usermanagement.utils.AuthorizationService;
import eu.dnetlib.openaire.usermanagement.utils.JsonUtils;
import eu.dnetlib.openaire.usermanagement.utils.RoleManagement;
import eu.dnetlib.openaire.usermanagement.utils.VerificationUtils;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.client.HttpClientErrorException;

@Component(value="RegistryService")
@CrossOrigin(value={"*"})
@Path(value="/registry")
public class RegistryService {
    private static final Logger logger = Logger.getLogger(RegistryService.class);
    @Autowired
    private RoleManagement calls;
    @Autowired
    private JsonUtils jsonUtils;
    @Autowired
    private VerificationUtils verificationUtils;
    @Autowired
    private EmailSender emailSender;
    @Autowired
    private AuthorizationService authorizationService;

    @Path(value="/subscribe/{type}/{id}")
    @POST
    @Produces(value={"application/json"})
    @PreAuthorize(value="isAuthenticated() and @AuthorizationService.isCommunity(#type)")
    public Response subscribe(@PathParam(value="type") String type, @PathParam(value="id") String id, @Context HttpServletRequest request) {
        try {
            JsonElement response = this.calls.assignMemberRole(type, id, request);
            return Response.status((int)HttpStatus.OK.value()).entity((Object)response.toString()).type("application/json").build();
        }
        catch (HttpClientErrorException e) {
            String message = new JsonParser().parse(e.getResponseBodyAsString()).getAsJsonObject().get("message").getAsString();
            return Response.status((int)e.getStatusCode().value()).entity((Object)this.jsonUtils.createResponse(message).toString()).type("application/json").build();
        }
    }

    @Path(value="/unsubscribe/{type}/{id}")
    @POST
    @Produces(value={"application/json"})
    @PreAuthorize(value="isAuthenticated() and @AuthorizationService.isCommunity(#type)")
    public Response unsubscribe(@PathParam(value="type") String type, @PathParam(value="id") String id, @Context HttpServletRequest request) {
        try {
            JsonElement response = this.calls.removeMemberRole(type, id, request);
            return Response.status((int)HttpStatus.OK.value()).entity((Object)response.toString()).type("application/json").build();
        }
        catch (HttpClientErrorException e) {
            String message = new JsonParser().parse(e.getResponseBodyAsString()).getAsJsonObject().get("message").getAsString();
            return Response.status((int)e.getStatusCode().value()).entity((Object)this.jsonUtils.createResponse(message).toString()).type("application/json").build();
        }
    }

    @Path(value="/create/{type}")
    @POST
    @Produces(value={"application/json"})
    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    public Response createCuratorRole(@PathParam(value="type") String type) {
        try {
            JsonElement response = this.calls.createCuratorRole(type);
            return Response.status((int)HttpStatus.CREATED.value()).entity((Object)response.toString()).type("application/json").build();
        }
        catch (HttpClientErrorException e) {
            String message = new JsonParser().parse(e.getResponseBodyAsString()).getAsJsonObject().get("message").getAsString();
            return Response.status((int)e.getStatusCode().value()).entity((Object)this.jsonUtils.createResponse(message).toString()).type("application/json").build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/create/{type}/{id}")
    @POST
    @Produces(value={"application/json"})
    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#type))")
    public Response createMemberRole(@PathParam(value="type") String type, @PathParam(value="id") String id) {
        String message;
        JsonElement element = null;
        Response response = null;
        try {
            element = type.equals("ri") || type.equals("community") ? this.calls.createMemberRole("ri", id) : this.calls.createMemberRole(type, id);
        }
        catch (HttpClientErrorException e) {
            message = new JsonParser().parse(e.getResponseBodyAsString()).getAsJsonObject().get("message").getAsString();
            response = Response.status((int)e.getStatusCode().value()).entity((Object)this.jsonUtils.createResponse(message).toString()).type("application/json").build();
        }
        finally {
            try {
                if (type.equals("ri") || type.equals("community")) {
                    element = this.calls.createMemberRole("community", id);
                }
                if (element != null) {
                    response = Response.status((int)HttpStatus.CREATED.value()).entity((Object)element.toString()).type("application/json").build();
                }
            }
            catch (HttpClientErrorException e) {
                message = new JsonParser().parse(e.getResponseBodyAsString()).getAsJsonObject().get("message").getAsString();
                response = Response.status((int)e.getStatusCode().value()).entity((Object)this.jsonUtils.createResponse(message).toString()).type("application/json").build();
            }
        }
        return response;
    }

    @Path(value="/invite/{type}/{id}/manager")
    @POST
    @Produces(value={"application/json"})
    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#type), @AuthorizationService.manager(#type, #id))")
    public Response inviteManager(@PathParam(value="type") String type, @PathParam(value="id") String id, @RequestBody String body) {
        try {
            JsonObject details = new JsonParser().parse(body).getAsJsonObject();
            JsonObject email = details.get("email").getAsJsonObject();
            String recipient = email.get("recipient").getAsString();
            if (!this.calls.isManager(type, id, recipient)) {
                JsonObject invitation = this.verificationUtils.createManagerInvitation(recipient, type, id);
                return this.sendEmail(details, email, invitation);
            }
            return Response.status((int)HttpStatus.CONFLICT.value()).entity((Object)this.jsonUtils.createResponse("User has been already manager of this " + type).toString()).type("application/json").build();
        }
        catch (HttpClientErrorException e) {
            String message = new JsonParser().parse(e.getResponseBodyAsString()).getAsJsonObject().get("message").getAsString();
            return Response.status((int)e.getStatusCode().value()).entity((Object)this.jsonUtils.createResponse(message).toString()).type("application/json").build();
        }
    }

    @Path(value="/invite/{type}/{id}/member")
    @POST
    @Produces(value={"application/json"})
    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#type), @AuthorizationService.manager(#type, #id))")
    public Response inviteMember(@PathParam(value="type") String type, @PathParam(value="id") String id, @RequestBody String body) {
        try {
            JsonObject details = new JsonParser().parse(body).getAsJsonObject();
            JsonObject email = details.get("email").getAsJsonObject();
            String recipient = email.get("recipient").getAsString();
            if (!this.calls.isMember(type, id, recipient)) {
                JsonObject invitation = this.verificationUtils.createMemberInvitation(recipient, type, id);
                return this.sendEmail(details, email, invitation);
            }
            return Response.status((int)HttpStatus.CONFLICT.value()).entity((Object)this.jsonUtils.createResponse("User has been already member of this " + type).toString()).type("application/json").build();
        }
        catch (HttpClientErrorException e) {
            String message = new JsonParser().parse(e.getResponseBodyAsString()).getAsJsonObject().get("message").getAsString();
            return Response.status((int)e.getStatusCode().value()).entity((Object)this.jsonUtils.createResponse(message).toString()).type("application/json").build();
        }
    }

    private Response sendEmail(JsonObject details, JsonObject email, JsonObject invitation) {
        String link = details.get("link").getAsString() + invitation.get("link").getAsString();
        String subject = email.get("subject").getAsString();
        String message = email.get("body").getAsString().replace("((__user__))", "User").replace("((__link__))", link).replace("((__code__))", invitation.get("code").getAsString());
        try {
            this.emailSender.sendEmail(email.get("recipient").getAsString(), subject, message);
            return Response.status((int)HttpStatus.OK.value()).entity((Object)this.jsonUtils.createResponse((JsonElement)invitation).toString()).type("application/json").build();
        }
        catch (MessagingException e) {
            this.verificationUtils.deleteVerification(invitation.get("link").getAsString());
            return Response.status((int)HttpStatus.BAD_REQUEST.value()).entity((Object)this.jsonUtils.createResponse("Email sent failed").toString()).type("application/json").build();
        }
    }

    @Path(value="/invite/{type}/{id}/manager/{email}")
    @DELETE
    @Produces(value={"application/json"})
    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#type), @AuthorizationService.manager(#type, #id))")
    public Response cancelManagerInvitations(@PathParam(value="type") String type, @PathParam(value="id") String id, @PathParam(value="email") String email) {
        this.verificationUtils.deleteManagerVerifications(email, type, id);
        return Response.status((int)HttpStatus.OK.value()).entity((Object)this.jsonUtils.createResponse("Invitations have been deleted").toString()).type("application/json").build();
    }

    @Path(value="/invite/{type}/{id}/member/{email}")
    @DELETE
    @Produces(value={"application/json"})
    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#type), @AuthorizationService.manager(#type, #id))")
    public Response cancelMemberInvitations(@PathParam(value="type") String type, @PathParam(value="id") String id, @PathParam(value="email") String email) {
        this.verificationUtils.deleteMemberVerifications(email, type, id);
        return Response.status((int)HttpStatus.OK.value()).entity((Object)this.jsonUtils.createResponse("Invitations have been deleted").toString()).type("application/json").build();
    }

    @Path(value="/invite/{type}/{id}/managers/")
    @GET
    @Produces(value={"application/json"})
    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#type), @AuthorizationService.manager(#type, #id))")
    public Response getInvitedManagers(@PathParam(value="type") String type, @PathParam(value="id") String id) {
        JsonArray invited = this.verificationUtils.getInvitedManagers(type, id);
        return Response.status((int)HttpStatus.OK.value()).entity((Object)this.jsonUtils.createResponse((JsonElement)invited).toString()).type("application/json").build();
    }

    @Path(value="/invite/{type}/{id}/members/")
    @GET
    @Produces(value={"application/json"})
    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#type), @AuthorizationService.manager(#type, #id))")
    public Response getInviteMembers(@PathParam(value="type") String type, @PathParam(value="id") String id) {
        JsonArray invited = this.verificationUtils.getInvitedMembers(type, id);
        return Response.status((int)HttpStatus.OK.value()).entity((Object)this.jsonUtils.createResponse((JsonElement)invited).toString()).type("application/json").build();
    }

    @Path(value="/verification/{id}")
    @GET
    @Produces(value={"application/json"})
    @PreAuthorize(value="isAuthenticated()")
    public Response getVerification(@PathParam(value="id") String id) {
        RoleVerification verification = this.verificationUtils.getVerification(id);
        if (verification != null) {
            if (verification.getEmail().equalsIgnoreCase(this.authorizationService.getEmail())) {
                return Response.status((int)HttpStatus.OK.value()).entity((Object)this.jsonUtils.createResponse((JsonElement)this.jsonUtils.createVerification(verification)).toString()).type("application/json").build();
            }
            return Response.status((int)HttpStatus.FORBIDDEN.value()).entity((Object)this.jsonUtils.createResponse("Forbidden verification").toString()).type("application/json").build();
        }
        return Response.status((int)HttpStatus.NOT_FOUND.value()).entity((Object)this.jsonUtils.createResponse("Verification has not been found").toString()).type("application/json").build();
    }

    @Path(value="/verification/{id}")
    @DELETE
    @Produces(value={"application/json"})
    @PreAuthorize(value="isAuthenticated() && @VerificationUtils.ownedVerification(#id)")
    public Response deleteVerification(@PathParam(value="id") String id) {
        if (this.verificationUtils.getVerification(id) != null) {
            this.verificationUtils.deleteVerification(id);
            return Response.status((int)HttpStatus.OK.value()).entity((Object)this.jsonUtils.createResponse((JsonElement)this.jsonUtils.createResponse("Verification deleted")).toString()).type("application/json").build();
        }
        return Response.status((int)HttpStatus.NOT_FOUND.value()).entity((Object)this.jsonUtils.createResponse((JsonElement)this.jsonUtils.createResponse("Verification has not been found")).toString()).type("application/json").build();
    }

    @Path(value="/verification/manager/{id}")
    @POST
    @Produces(value={"application/json"})
    @PreAuthorize(value="isAuthenticated()")
    public Response verifyManager(@PathParam(value="id") String id, @RequestBody String code, @Context HttpServletRequest request) {
        RoleVerification verification = this.verificationUtils.getVerification(id);
        if (verification != null && verification.getVerificationType().equals("manager")) {
            if (verification.getEmail().equalsIgnoreCase(this.authorizationService.getEmail())) {
                if (verification.getVerificationCode().equals(code)) {
                    try {
                        this.calls.assignManagerRole(verification.getType(), verification.getEntity(), request);
                        if (verification.getType().equals("community") || verification.getType().equals("ri")) {
                            this.calls.assignMemberRole("ri", verification.getEntity(), request);
                            this.verificationUtils.deleteMemberVerifications(verification.getEmail(), "community", verification.getEntity());
                            this.verificationUtils.deleteMemberVerifications(verification.getEmail(), "ri", verification.getEntity());
                            this.verificationUtils.deleteManagerVerifications(verification.getEmail(), "community", verification.getEntity());
                            this.verificationUtils.deleteManagerVerifications(verification.getEmail(), "ri", verification.getEntity());
                        } else {
                            this.verificationUtils.deleteMemberVerifications(verification.getEmail(), verification.getType(), verification.getEntity());
                            this.verificationUtils.deleteManagerVerifications(verification.getEmail(), verification.getType(), verification.getEntity());
                        }
                        return Response.status((int)HttpStatus.OK.value()).entity((Object)this.jsonUtils.createResponse("Admin role has been assigned").toString()).type("application/json").build();
                    }
                    catch (HttpClientErrorException e) {
                        String message = new JsonParser().parse(e.getResponseBodyAsString()).getAsJsonObject().get("message").getAsString();
                        return Response.status((int)e.getStatusCode().value()).entity((Object)this.jsonUtils.createResponse(message).toString()).type("application/json").build();
                    }
                }
                return Response.status((int)HttpStatus.BAD_REQUEST.value()).entity((Object)this.jsonUtils.createResponse("Verification code is wrong").toString()).type("application/json").build();
            }
            return Response.status((int)HttpStatus.FORBIDDEN.value()).entity((Object)this.jsonUtils.createResponse("Forbidden verification").toString()).type("application/json").build();
        }
        return Response.status((int)HttpStatus.NOT_FOUND.value()).entity((Object)this.jsonUtils.createResponse("Verification has not been found").toString()).type("application/json").build();
    }

    @Path(value="/verification/member/{id}")
    @POST
    @Produces(value={"application/json"})
    @PreAuthorize(value="isAuthenticated()")
    public Response verifyMember(@PathParam(value="id") String id, @RequestBody String code, @Context HttpServletRequest request) {
        RoleVerification verification = this.verificationUtils.getVerification(id);
        if (verification != null && verification.getVerificationType().equals("member")) {
            if (verification.getEmail().equalsIgnoreCase(this.authorizationService.getEmail())) {
                if (verification.getVerificationCode().equals(code)) {
                    try {
                        this.calls.assignMemberRole(verification.getType(), verification.getEntity(), request);
                        this.verificationUtils.deleteMemberVerifications(verification.getEmail(), verification.getType(), verification.getEntity());
                        return Response.status((int)HttpStatus.OK.value()).entity((Object)this.jsonUtils.createResponse("Member role has been assigned").toString()).type("application/json").build();
                    }
                    catch (HttpClientErrorException e) {
                        String message = new JsonParser().parse(e.getResponseBodyAsString()).getAsJsonObject().get("message").getAsString();
                        return Response.status((int)e.getStatusCode().value()).entity((Object)this.jsonUtils.createResponse(message).toString()).type("application/json").build();
                    }
                }
                return Response.status((int)HttpStatus.BAD_REQUEST.value()).entity((Object)this.jsonUtils.createResponse("Verification code is wrong").toString()).type("application/json").build();
            }
            return Response.status((int)HttpStatus.FORBIDDEN.value()).entity((Object)this.jsonUtils.createResponse("Forbidden verification").toString()).type("application/json").build();
        }
        return Response.status((int)HttpStatus.NOT_FOUND.value()).entity((Object)this.jsonUtils.createResponse("Verification has not been found").toString()).type("application/json").build();
    }

    @Path(value="/{type}/{id}/manager/{email}")
    @DELETE
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#type), @AuthorizationService.manager(#type, #id))")
    public Response removeManagerRole(@PathParam(value="type") String type, @PathParam(value="id") String id, @PathParam(value="email") String email) {
        try {
            JsonElement response = this.calls.removeManagerRole(type, id, email);
            return Response.status((int)HttpStatus.OK.value()).entity((Object)response.toString()).type("application/json").build();
        }
        catch (HttpClientErrorException e) {
            String message = new JsonParser().parse(e.getResponseBodyAsString()).getAsJsonObject().get("message").getAsString();
            return Response.status((int)e.getStatusCode().value()).entity((Object)this.jsonUtils.createResponse(message).toString()).type("application/json").build();
        }
    }

    @Path(value="/{type}/{id}/member/{email}")
    @DELETE
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#type), @AuthorizationService.manager(#type, #id))")
    public Response removeMemberRole(@PathParam(value="type") String type, @PathParam(value="id") String id, @PathParam(value="email") String email) {
        try {
            JsonElement response = this.calls.removeMemberRole(type, id, email);
            return Response.status((int)HttpStatus.OK.value()).entity((Object)response.toString()).type("application/json").build();
        }
        catch (HttpClientErrorException e) {
            String message = new JsonParser().parse(e.getResponseBodyAsString()).getAsJsonObject().get("message").getAsString();
            return Response.status((int)e.getStatusCode().value()).entity((Object)this.jsonUtils.createResponse(message).toString()).type("application/json").build();
        }
    }

    @Path(value="/{type}/{id}/members/count")
    @GET
    @Produces(value={"application/json"})
    public Response getMembersCount(@PathParam(value="type") String type, @PathParam(value="id") String id) {
        try {
            int response = this.calls.getAllMembersCount(type, id);
            return Response.status((int)HttpStatus.OK.value()).entity((Object)this.jsonUtils.createResponse((Number)response).toString()).type("application/json").build();
        }
        catch (HttpClientErrorException e) {
            String message = new JsonParser().parse(e.getResponseBodyAsString()).getAsJsonObject().get("message").getAsString();
            return Response.status((int)e.getStatusCode().value()).entity((Object)this.jsonUtils.createResponse(message).toString()).type("application/json").build();
        }
    }

    @Path(value="/{type}/{id}/members{var:.*}")
    @GET
    @Produces(value={"application/json"})
    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN,@AuthorizationService.curator(#type), @AuthorizationService.manager(#type, #id))")
    public Response getMembers(@PathParam(value="type") String type, @PathParam(value="id") String id) {
        try {
            JsonElement response = this.calls.getAllMembers(type, id);
            return Response.status((int)HttpStatus.OK.value()).entity((Object)this.jsonUtils.createResponse(response).toString()).type("application/json").build();
        }
        catch (HttpClientErrorException e) {
            String message = new JsonParser().parse(e.getResponseBodyAsString()).getAsJsonObject().get("message").getAsString();
            return Response.status((int)e.getStatusCode().value()).entity((Object)this.jsonUtils.createResponse(message).toString()).type("application/json").build();
        }
    }

    @Path(value="/{type}/{id}/managers{var:.*}")
    @GET
    @Produces(value={"application/json"})
    public Response getManagers(@PathParam(value="type") String type, @PathParam(value="id") String id) {
        try {
            JsonElement response = this.calls.getAllManagers(type, id);
            return Response.status((int)HttpStatus.OK.value()).entity((Object)this.jsonUtils.createResponse(response).toString()).type("application/json").build();
        }
        catch (HttpClientErrorException e) {
            String message = new JsonParser().parse(e.getResponseBodyAsString()).getAsJsonObject().get("message").getAsString();
            return Response.status((int)e.getStatusCode().value()).entity((Object)this.jsonUtils.createResponse(message).toString()).type("application/json").build();
        }
    }

    @Path(value="/{type}/curators{var:.*}")
    @GET
    @Produces(value={"application/json"})
    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#type))")
    public Response getCurators(@PathParam(value="type") String type) {
        try {
            JsonElement response = this.calls.getAllCurators(type);
            return Response.status((int)HttpStatus.OK.value()).entity((Object)this.jsonUtils.createResponse(response).toString()).type("application/json").build();
        }
        catch (HttpClientErrorException e) {
            String message = new JsonParser().parse(e.getResponseBodyAsString()).getAsJsonObject().get("message").getAsString();
            return Response.status((int)e.getStatusCode().value()).entity((Object)this.jsonUtils.createResponse(message).toString()).type("application/json").build();
        }
    }
}

