/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.usermanagement.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class HttpUtils {
    private static final Logger logger = Logger.getLogger(HttpUtils.class);

    public JsonElement post(String path, String session, JsonObject body, Map<String, String> params) {
        RestTemplate restTemplate = new RestTemplate();
        String url = path + (params != null ? this.createParams(params) : "");
        HttpHeaders headers = this.createHeaders(session);
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity((Object)(body != null ? body.toString() : ""), (MultiValueMap)headers);
        ResponseEntity responseEntity = restTemplate.exchange(url, HttpMethod.POST, request, String.class, new Object[0]);
        if (responseEntity.getBody() != null) {
            return new JsonParser().parse((String)responseEntity.getBody());
        }
        return null;
    }

    public JsonElement put(String path, String session, JsonObject body) {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = this.createHeaders(session);
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity((Object)body.toString(), (MultiValueMap)headers);
        ResponseEntity responseEntity = restTemplate.exchange(path, HttpMethod.PUT, request, String.class, new Object[0]);
        if (responseEntity.getBody() != null) {
            return new JsonParser().parse((String)responseEntity.getBody());
        }
        return null;
    }

    public JsonElement get(String path, String session, Map<String, String> params) {
        HttpHeaders headers;
        RestTemplate restTemplate = new RestTemplate();
        String url = path + (params != null ? this.createParams(params) : "");
        ResponseEntity responseEntity = restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)(headers = this.createHeaders(session))), String.class, new Object[0]);
        if (responseEntity.getBody() != null) {
            return new JsonParser().parse((String)responseEntity.getBody());
        }
        return null;
    }

    public JsonElement delete(String path, String session, Map<String, String> params) {
        HttpHeaders headers;
        RestTemplate restTemplate = new RestTemplate();
        String url = path + (params != null ? this.createParams(params) : "");
        ResponseEntity responseEntity = restTemplate.exchange(url, HttpMethod.DELETE, new HttpEntity((MultiValueMap)(headers = this.createHeaders(session))), String.class, new Object[0]);
        if (responseEntity.getBody() != null) {
            return new JsonParser().parse((String)responseEntity.getBody());
        }
        return null;
    }

    private String createParams(Map<String, String> params) {
        StringBuilder ret = new StringBuilder("?");
        int count = 0;
        for (Map.Entry<String, String> param : params.entrySet()) {
            ret.append(param.getKey()).append("=");
            ret.append(param.getValue());
            if (++count == params.entrySet().size()) continue;
            ret.append("&");
        }
        return ret.toString();
    }

    private HttpHeaders createHeaders(String token) {
        if (token != null) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        return new HttpHeaders();
    }

    public String getCookie(HttpServletRequest req, String cookieName) {
        return Arrays.stream(req.getCookies()).filter(c -> c.getName().equals(cookieName)).findFirst().map(Cookie::getValue).orElse(null);
    }
}

