/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.protobuf.Descriptors;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.util.Arrays;
import java.util.Set;

public class OafUtils {
    public static Set<String> entities() {
        return Sets.newHashSet((Iterable)Iterables.transform((Iterable)Lists.newArrayList((Object[])TypeProtos.Type.values()), (Function)new Function<TypeProtos.Type, String>(){

            public String apply(TypeProtos.Type t) {
                return t.toString();
            }
        }));
    }

    public static Predicate<OafProtos.Oaf> relationFilter() {
        return new Predicate<OafProtos.Oaf>(){

            public boolean apply(OafProtos.Oaf oaf) {
                return oaf.getKind().equals((Object)KindProtos.Kind.relation);
            }
        };
    }

    public static Predicate<OafProtos.Oaf> entityFilter() {
        return new Predicate<OafProtos.Oaf>(){

            public boolean apply(OafProtos.Oaf oaf) {
                return oaf.getKind().equals((Object)KindProtos.Kind.entity);
            }
        };
    }

    public static Function<OafDecoder, String> idDecoder() {
        return new Function<OafDecoder, String>(){

            public String apply(OafDecoder input) {
                return input.getEntityId();
            }
        };
    }

    public static Predicate<FieldTypeProtos.StructuredProperty> mainTitleFilter() {
        return new Predicate<FieldTypeProtos.StructuredProperty>(){

            public boolean apply(FieldTypeProtos.StructuredProperty sp) {
                return sp.getQualifier() != null && sp.getQualifier().getClassname().equals("main title");
            }
        };
    }

    public static Set<String> getFieldNames(final Descriptors.Descriptor d, Integer ... tag) {
        return Sets.newHashSet((Iterable)Iterables.transform(Arrays.asList(tag), (Function)new Function<Integer, String>(){

            public String apply(Integer i) {
                Descriptors.FieldDescriptor fd = d.findFieldByNumber(i.intValue());
                if (fd == null) {
                    throw new IllegalArgumentException("undefined tag: " + i + " for type: " + d.getFullName());
                }
                return fd.getName();
            }
        }));
    }
}

