/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform.xml;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.PersonProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.CommonDNetXsltFunctions;
import eu.dnetlib.data.transform.xml.Element;
import eu.dnetlib.data.transform.xml.ElementList;
import eu.dnetlib.data.transform.xml.ValueMap;
import eu.dnetlib.pace.model.Person;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.NodeList;

public class OafToHbaseXsltFunctions
extends CommonDNetXsltFunctions {
    public static String oafResult(String resultId, String provenance, String trust, NodeList about, String hostedbyId, String hostedbyName, String collectedFromId, String collectedFromName, String originalId, String dateOfCollection, String dateOfTransformation, NodeList nodelist) {
        try {
            String entityId = OafRowKeyDecoder.decode(resultId).getKey();
            ValueMap values = ValueMap.parseNodeList(nodelist);
            Descriptors.Descriptor mDesc = ResultProtos.Result.Metadata.getDescriptor();
            FieldTypeProtos.KeyValue collectedFrom = OafToHbaseXsltFunctions.getKV(collectedFromId, collectedFromName);
            FieldTypeProtos.KeyValue hostedBy = OafToHbaseXsltFunctions.getKV(hostedbyId, hostedbyName);
            ResultProtos.Result.Metadata.Builder metadata = OafToHbaseXsltFunctions.buildMetadata(values, mDesc);
            ResultProtos.Result.Builder result = OafToHbaseXsltFunctions.buildResult(metadata, values, collectedFrom, hostedBy);
            OafProtos.OafEntity.Builder entity = OafToHbaseXsltFunctions.buildOafEntity(result, entityId, nodelist, collectedFrom, originalId);
            entity.setDateofcollection(dateOfCollection).setDateoftransformation(dateOfTransformation).setOaiprovenance(OafToHbaseXsltFunctions.getOAIProvenance(about));
            OafProtos.Oaf oaf = OafToHbaseXsltFunctions.getOaf(entity, OafToHbaseXsltFunctions.getDataInfo(about, provenance, trust, false, false));
            return OafToHbaseXsltFunctions.base64(oaf.toByteArray());
        }
        catch (Throwable e) {
            OafToHbaseXsltFunctions.handleException(e, resultId, hostedbyId, hostedbyName, provenance, trust, collectedFromId, collectedFromName, originalId, dateOfCollection);
            return null;
        }
    }

    public static String oafResultUpdate(String resultId, String provenance, String trust, NodeList nodelist, String hostedbyId, String hostedbyName) {
        try {
            String entityId = OafRowKeyDecoder.decode(resultId).getKey();
            ValueMap values = ValueMap.parseNodeList(nodelist);
            Descriptors.Descriptor mDesc = ResultProtos.Result.Metadata.getDescriptor();
            FieldTypeProtos.KeyValue hostedBy = OafToHbaseXsltFunctions.getKV(hostedbyId, hostedbyName);
            ResultProtos.Result.Metadata.Builder metadata = OafToHbaseXsltFunctions.buildMetadata(values, mDesc);
            ResultProtos.Result.Builder result = OafToHbaseXsltFunctions.buildResult(metadata, values, null, hostedBy);
            OafProtos.OafEntity.Builder entity = OafToHbaseXsltFunctions.buildOafEntity(result, entityId, nodelist, null, null);
            OafProtos.Oaf oaf = OafToHbaseXsltFunctions.getOaf(entity, null);
            return OafToHbaseXsltFunctions.base64(oaf.toByteArray());
        }
        catch (Throwable e) {
            OafToHbaseXsltFunctions.handleException(e, resultId, hostedbyId, hostedbyName, provenance, trust, null, null, null, null);
            return null;
        }
    }

    private static OafProtos.OafEntity.Builder buildOafEntity(ResultProtos.Result.Builder result, String entityId, NodeList nodelist, FieldTypeProtos.KeyValue collectedFrom, String originalId) {
        ArrayList pids = Lists.newArrayList();
        pids.addAll(OafToHbaseXsltFunctions.parsePids(nodelist));
        OafProtos.OafEntity.Builder entity = OafToHbaseXsltFunctions.getEntity(TypeProtos.Type.result, entityId, collectedFrom, StringUtils.isBlank((String)originalId) ? null : Lists.newArrayList((Object[])new String[]{originalId}), null, null, pids).setResult(result);
        return entity;
    }

    private static ResultProtos.Result.Metadata.Builder buildMetadata(ValueMap values, Descriptors.Descriptor mDesc) {
        ResultProtos.Result.Metadata.Builder metadata = ResultProtos.Result.Metadata.newBuilder();
        OafToHbaseXsltFunctions.addStructuredProps((Message.Builder)metadata, mDesc.findFieldByName("subject"), values.get("subject"), "keyword", "dnet:subject_classification_typologies");
        OafToHbaseXsltFunctions.addStructuredProps((Message.Builder)metadata, mDesc.findFieldByName("title"), values.get("title"), "main title", "dnet:dataCite_title");
        for (String fieldname : Lists.newArrayList((Object[])new String[]{"description", "source", "contributor"})) {
            if (values.get(fieldname) == null) continue;
            for (String s2 : values.get(fieldname).listValues()) {
                OafToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName(fieldname), s2);
            }
        }
        OafToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("language"), OafToHbaseXsltFunctions.setQualifier(OafToHbaseXsltFunctions.getDefaultQualifier("dnet:languages"), values.get("language").listValues()));
        OafToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("dateofacceptance"), values.get("dateaccepted").listValues());
        OafToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("publisher"), values.get("publisher").listValues());
        OafToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("embargoenddate"), values.get("embargoenddate").listValues());
        OafToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("storagedate"), values.get("storagedate").listValues());
        String cobjcategoryCode = values.get("cobjcategory").stream().map(e -> e.getText()).map(s -> s != null && !s.isEmpty() ? s : "0000").findFirst().orElse("0000");
        String resulttype = "";
        switch (cobjcategoryCode) {
            case "0029": {
                resulttype = "software";
                break;
            }
            default: {
                resulttype = "publication";
            }
        }
        OafToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("resulttype"), OafToHbaseXsltFunctions.getSimpleQualifier(resulttype, "dnet:result_typologies"));
        OafToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("fulltext"), values.get("fulltext").listValues());
        OafToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("format"), values.get("format").listValues());
        if (values.get("concept") != null) {
            for (Element e2 : values.get("concept")) {
                String id = e2.getAttributes().get("id");
                if (StringUtils.isBlank((String)id)) {
                    throw new IllegalArgumentException("Context id cannot be blank");
                }
                metadata.addContext(ResultProtos.Result.Context.newBuilder().setId(id));
            }
        }
        if (values.get("journal") != null) {
            for (Element e3 : values.get("journal")) {
                Map<String, String> attr;
                ResultProtos.Result.Journal.Builder journal = ResultProtos.Result.Journal.newBuilder();
                if (e3.getText() != null) {
                    journal.setName(e3.getText());
                }
                if ((attr = e3.getAttributes()) != null) {
                    if (attr.get("issn") != null) {
                        journal.setIssnPrinted(attr.get("issn"));
                    }
                    if (attr.get("eissn") != null) {
                        journal.setIssnOnline(attr.get("eissn"));
                    }
                    if (attr.get("lissn") != null) {
                        journal.setIssnLinking(attr.get("lissn"));
                    }
                    if (attr.get("ep") != null) {
                        journal.setEp(attr.get("ep"));
                    }
                    if (attr.get("iss") != null) {
                        journal.setIss(attr.get("iss"));
                    }
                    if (attr.get("sp") != null) {
                        journal.setSp(attr.get("sp"));
                    }
                    if (attr.get("vol") != null) {
                        journal.setVol(attr.get("vol"));
                    }
                }
                metadata.setJournal(journal.build());
            }
        }
        return metadata;
    }

    private static ResultProtos.Result.Builder buildResult(ResultProtos.Result.Metadata.Builder metadata, ValueMap values, FieldTypeProtos.KeyValue collectedFrom, FieldTypeProtos.KeyValue hostedBy) {
        ResultProtos.Result.Builder result = ResultProtos.Result.newBuilder();
        if (values.get("creator") != null) {
            for (String fullname : Iterables.limit(values.get("creator").listValues(), (int)10)) {
                PersonProtos.Person.Metadata.Builder authorMetadata = PersonProtos.Person.Metadata.newBuilder();
                authorMetadata.setFullname(OafToHbaseXsltFunctions.sf(fullname));
                Person p = new Person(fullname, false);
                if (p.isAccurate()) {
                    authorMetadata.setFirstname(OafToHbaseXsltFunctions.sf(p.getNormalisedFirstName()));
                    authorMetadata.clearSecondnames().addSecondnames(OafToHbaseXsltFunctions.sf(p.getNormalisedSurname()));
                    authorMetadata.setFullname(OafToHbaseXsltFunctions.sf(p.getNormalisedFullname()));
                }
                result.addAuthor(PersonProtos.Person.newBuilder().setMetadata(authorMetadata));
            }
        }
        ResultProtos.Result.Instance.Builder instance = ResultProtos.Result.Instance.newBuilder().setHostedby(hostedBy);
        OafToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("licence"), OafToHbaseXsltFunctions.setQualifier(OafToHbaseXsltFunctions.getDefaultQualifier("dnet:access_modes"), values.get("accessrights").listValues()));
        OafToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("instancetype"), OafToHbaseXsltFunctions.setQualifier(OafToHbaseXsltFunctions.getDefaultQualifier("dnet:publication_resource"), values.get("cobjcategory").listValues()));
        OafToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("collectedfrom"), collectedFrom);
        OafToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("dateofacceptance"), values.get("dateaccepted").listValues());
        if (values.get("identifier") != null) {
            OafToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("url"), Lists.newArrayList((Iterable)Iterables.filter(values.get("identifier").listValues(), (Predicate)urlFilter)));
        }
        result.addInstance(instance);
        ElementList extrefs = values.get("reference");
        if (!extrefs.isEmpty()) {
            Descriptors.Descriptor extDesc = ResultProtos.Result.ExternalReference.getDescriptor();
            for (Element element : extrefs) {
                ResultProtos.Result.ExternalReference.Builder extref = ResultProtos.Result.ExternalReference.newBuilder();
                OafToHbaseXsltFunctions.addField((Message.Builder)extref, extDesc.findFieldByName("url"), element.getText());
                OafToHbaseXsltFunctions.addField((Message.Builder)extref, extDesc.findFieldByName("sitename"), element.getAttributes().get("source"));
                OafToHbaseXsltFunctions.addField((Message.Builder)extref, extDesc.findFieldByName("refidentifier"), element.getAttributes().get("identifier"));
                OafToHbaseXsltFunctions.addField((Message.Builder)extref, extDesc.findFieldByName("label"), element.getAttributes().get("title"));
                OafToHbaseXsltFunctions.addField((Message.Builder)extref, extDesc.findFieldByName("query"), element.getAttributes().get("query"));
                OafToHbaseXsltFunctions.addField((Message.Builder)extref, extDesc.findFieldByName("qualifier"), OafToHbaseXsltFunctions.setQualifier(OafToHbaseXsltFunctions.getDefaultQualifier("dnet:externalReference_typologies"), Lists.newArrayList((Object[])new String[]{element.getAttributes().get("type")})).build());
                result.addExternalReference(extref);
            }
        }
        return result.setMetadata(metadata);
    }

    private static void handleException(Throwable e, String resultId, String hostedbyId, String hostedbyName, String provenance, String trust, String collectedFromId, String collectedFromName, String originalId, String dateOfCollection) {
        System.err.println("resultId: " + resultId);
        if (StringUtils.isNotBlank((String)hostedbyId)) {
            System.err.println("hostedbyId: " + hostedbyId);
        }
        if (StringUtils.isNotBlank((String)hostedbyName)) {
            System.err.println("hostedbyName: " + hostedbyName);
        }
        if (StringUtils.isNotBlank((String)provenance)) {
            System.err.println("provenance: " + provenance);
        }
        if (StringUtils.isNotBlank((String)trust)) {
            System.err.println("trust: " + trust);
        }
        if (StringUtils.isNotBlank((String)collectedFromId)) {
            System.err.println("collectedFromId: " + collectedFromId);
        }
        if (StringUtils.isNotBlank((String)collectedFromName)) {
            System.err.println("collectedFromName: " + collectedFromName);
        }
        if (StringUtils.isNotBlank((String)originalId)) {
            System.err.println("originalId: " + originalId);
        }
        if (StringUtils.isNotBlank((String)dateOfCollection)) {
            System.err.println("dateOfCollection: " + dateOfCollection);
        }
        e.printStackTrace();
        throw new RuntimeException(e);
    }
}

