/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform.xml;

import com.google.common.collect.Lists;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.DatasourceOrganizationProtos;
import eu.dnetlib.data.proto.DatasourceProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.OrganizationProtos;
import eu.dnetlib.data.proto.ProjectOrganizationProtos;
import eu.dnetlib.data.proto.ProjectProtos;
import eu.dnetlib.data.proto.RelMetadataProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.ResultOrganizationProtos;
import eu.dnetlib.data.proto.ResultProjectProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.CommonDNetXsltFunctions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DbmfToHbaseXsltFunctions
extends CommonDNetXsltFunctions {
    public static String oafEntity(String type, String id, String collectedFromId, String collectedFromName, NodeList identities, String dateOfCollection, String dateOfTransformation, NodeList nodeList) {
        String entityId = OafRowKeyDecoder.decode(id).getKey();
        ArrayList ids = Lists.newArrayList();
        for (int i = 0; i < identities.getLength(); ++i) {
            Node n = identities.item(i);
            String s = n.getTextContent();
            ids.add(s);
        }
        switch (TypeProtos.Type.valueOf((String)type)) {
            case datasource: {
                return DbmfToHbaseXsltFunctions.serializeOafEntity(nodeList, TypeProtos.Type.datasource, entityId, DbmfToHbaseXsltFunctions.getKV(collectedFromId, collectedFromName), ids, dateOfCollection, dateOfTransformation, (Message.Builder)DatasourceProtos.Datasource.newBuilder());
            }
            case organization: {
                return DbmfToHbaseXsltFunctions.serializeOafEntity(nodeList, TypeProtos.Type.organization, entityId, DbmfToHbaseXsltFunctions.getKV(collectedFromId, collectedFromName), ids, dateOfCollection, dateOfTransformation, (Message.Builder)OrganizationProtos.Organization.newBuilder());
            }
            case project: {
                return DbmfToHbaseXsltFunctions.serializeOafEntity(nodeList, TypeProtos.Type.project, entityId, DbmfToHbaseXsltFunctions.getKV(collectedFromId, collectedFromName), ids, dateOfCollection, dateOfTransformation, (Message.Builder)ProjectProtos.Project.newBuilder());
            }
            case result: {
                return DbmfToHbaseXsltFunctions.serializeOafEntity(nodeList, TypeProtos.Type.result, entityId, DbmfToHbaseXsltFunctions.getKV(collectedFromId, collectedFromName), ids, dateOfCollection, dateOfTransformation, (Message.Builder)ResultProtos.Result.newBuilder());
            }
        }
        throw new IllegalArgumentException("Invalid entity type: " + type);
    }

    public static String oafRel(String relationType, String source, String target, NodeList nodeList, String relClass, String relScheme) {
        return DbmfToHbaseXsltFunctions.oafRel(relationType, source, target, nodeList, relClass, relScheme, null, null);
    }

    public static String oafRel(String relationType, String source, String target, NodeList nodeList, String relClass, String relScheme, String collectedFromId, String collectedFromName) {
        String eSource = OafRowKeyDecoder.decode(source).getKey();
        String eTarget = OafRowKeyDecoder.decode(target).getKey();
        RelTypeProtos.RelType relType = RelTypeProtos.RelType.valueOf((String)relationType);
        switch (relType) {
            case datasourceOrganization: {
                DatasourceOrganizationProtos.DatasourceOrganization.Provision.Builder provision = DatasourceOrganizationProtos.DatasourceOrganization.Provision.newBuilder().setRelMetadata(RelMetadataProtos.RelMetadata.newBuilder().setSemantics(DbmfToHbaseXsltFunctions.getSimpleQualifier(DatasourceOrganizationProtos.DatasourceOrganization.Provision.RelName.valueOf((String)relClass).toString(), relScheme)));
                DatasourceOrganizationProtos.DatasourceOrganization.Builder dorg = DatasourceOrganizationProtos.DatasourceOrganization.newBuilder().setProvision(provision);
                return DbmfToHbaseXsltFunctions.serializeOafRel(nodeList, eSource, eTarget, relType, RelTypeProtos.SubRelType.provision, relClass, collectedFromId, collectedFromName, false, (Message.Builder)dorg, (Message.Builder)provision);
            }
            case projectOrganization: {
                ProjectOrganizationProtos.ProjectOrganization.Participation.Builder participant = ProjectOrganizationProtos.ProjectOrganization.Participation.newBuilder().setRelMetadata(RelMetadataProtos.RelMetadata.newBuilder().setSemantics(DbmfToHbaseXsltFunctions.getSimpleQualifier(ProjectOrganizationProtos.ProjectOrganization.Participation.RelName.valueOf((String)relClass).toString(), relScheme)));
                ProjectOrganizationProtos.ProjectOrganization.Builder projectOrganization = ProjectOrganizationProtos.ProjectOrganization.newBuilder().setParticipation(participant);
                return DbmfToHbaseXsltFunctions.serializeOafRel(nodeList, eSource, eTarget, relType, RelTypeProtos.SubRelType.participation, relClass, collectedFromId, collectedFromName, false, (Message.Builder)projectOrganization, (Message.Builder)participant);
            }
            case resultProject: {
                ResultProjectProtos.ResultProject.Outcome.Builder outcome = ResultProjectProtos.ResultProject.Outcome.newBuilder().setRelMetadata(RelMetadataProtos.RelMetadata.newBuilder().setSemantics(DbmfToHbaseXsltFunctions.getSimpleQualifier(ResultProjectProtos.ResultProject.Outcome.RelName.valueOf((String)relClass).toString(), relScheme)));
                ResultProjectProtos.ResultProject.Builder resultProject = ResultProjectProtos.ResultProject.newBuilder().setOutcome(outcome);
                return DbmfToHbaseXsltFunctions.serializeOafRel(nodeList, eSource, eTarget, relType, RelTypeProtos.SubRelType.outcome, relClass, collectedFromId, collectedFromName, false, (Message.Builder)resultProject, (Message.Builder)outcome);
            }
            case resultOrganization: {
                ResultOrganizationProtos.ResultOrganization.Affiliation.Builder affiliation = ResultOrganizationProtos.ResultOrganization.Affiliation.newBuilder().setRelMetadata(RelMetadataProtos.RelMetadata.newBuilder().setSemantics(DbmfToHbaseXsltFunctions.getSimpleQualifier(ResultOrganizationProtos.ResultOrganization.Affiliation.RelName.valueOf((String)relClass).toString(), relScheme)));
                ResultOrganizationProtos.ResultOrganization.Builder resultOrganization = ResultOrganizationProtos.ResultOrganization.newBuilder().setAffiliation(affiliation);
                return DbmfToHbaseXsltFunctions.serializeOafRel(nodeList, eSource, eTarget, relType, RelTypeProtos.SubRelType.affiliation, relClass, collectedFromId, collectedFromName, false, (Message.Builder)resultOrganization, (Message.Builder)affiliation);
            }
        }
        throw new IllegalArgumentException("unhandled relType: " + relationType);
    }

    protected static String serializeOafEntity(NodeList nodelist, TypeProtos.Type type, String id, FieldTypeProtos.KeyValue collectedFrom, List<String> identities, String dateOfCollection, String dateOfTransformation, Message.Builder entity) {
        try {
            Descriptors.FieldDescriptor md = entity.getDescriptorForType().findFieldByName("metadata");
            OafProtos.OafEntity.Builder parent = DbmfToHbaseXsltFunctions.getEntity(type, id, collectedFrom, identities, dateOfCollection, dateOfTransformation, null);
            Message.Builder metadata = entity.newBuilderForField(md);
            FieldTypeProtos.DataInfo.Builder dataInfo = FieldTypeProtos.DataInfo.newBuilder();
            if (type.equals((Object)TypeProtos.Type.result)) {
                ResultProtos.Result.Instance.Builder instance = ResultProtos.Result.Instance.newBuilder();
                DbmfToHbaseXsltFunctions.parseNodelist(nodelist, new Message.Builder[]{instance});
                Descriptors.FieldDescriptor instanceDescriptor = ResultProtos.Result.getDescriptor().findFieldByName(ResultProtos.Result.Instance.getDescriptor().getName());
                if (instanceDescriptor != null) {
                    entity.setField(instanceDescriptor, (Object)instance);
                }
            }
            DbmfToHbaseXsltFunctions.parseNodelist(nodelist, new Message.Builder[]{parent, entity, metadata, dataInfo});
            Descriptors.FieldDescriptor entityDescriptor = OafProtos.OafEntity.getDescriptor().findFieldByName(type.toString());
            OafProtos.Oaf build = DbmfToHbaseXsltFunctions.getOaf((OafProtos.OafEntity.Builder)parent.setField(entityDescriptor, (Object)entity.setField(md, (Object)metadata.build()).build()), dataInfo);
            return DbmfToHbaseXsltFunctions.base64(build.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
    }

    protected static String serializeOafRel(NodeList nodeList, String sourceId, String targetId, RelTypeProtos.RelType relType, RelTypeProtos.SubRelType subRelType, String relClass, String collectedFromId, String collectedFromName, boolean isChild, Message.Builder rel, Message.Builder subRel) {
        try {
            FieldTypeProtos.DataInfo.Builder dataInfo = FieldTypeProtos.DataInfo.newBuilder();
            DbmfToHbaseXsltFunctions.parseNodelist(nodeList, new Message.Builder[]{rel, subRel, dataInfo});
            OafProtos.OafRel.Builder builder = DbmfToHbaseXsltFunctions.getRel(sourceId, targetId, relType, subRelType, relClass, collectedFromId, collectedFromName, isChild);
            Descriptors.FieldDescriptor subRelDescriptor = rel.getDescriptorForType().findFieldByName(subRelType.toString());
            rel.setField(subRelDescriptor, (Object)subRel.build());
            Descriptors.FieldDescriptor relDescriptor = OafProtos.OafRel.getDescriptor().findFieldByName(relType.toString());
            builder.setField(relDescriptor, (Object)rel.build());
            OafProtos.Oaf build = DbmfToHbaseXsltFunctions.getOaf(builder, dataInfo);
            return DbmfToHbaseXsltFunctions.base64(build.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
    }

    private static void parseNodelist(NodeList nodeList, Message.Builder ... builders) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node fieldNode = nodeList.item(i);
            Node attr = fieldNode.getAttributes().getNamedItem("name");
            String fieldName = attr.getNodeValue();
            NodeList children = fieldNode.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node child = children.item(j);
                String childName = child.getLocalName();
                if (!"ITEM".equals(childName) && !StringUtils.isBlank((String)childName)) continue;
                for (Message.Builder builder : builders) {
                    String text;
                    Descriptors.FieldDescriptor desc = builder.getDescriptorForType().findFieldByName(fieldName);
                    if (desc == null || StringUtils.isBlank((String)(text = DbmfToHbaseXsltFunctions.getText(StringUtils.isBlank((String)childName) ? fieldNode : child)))) continue;
                    DbmfToHbaseXsltFunctions.addField(builder, desc, text);
                }
            }
        }
    }

    private static String getText(Node node) {
        StringBuffer result = new StringBuffer();
        if (!node.hasChildNodes()) {
            return "";
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node subnode = list.item(i);
            if (subnode.getNodeType() == 3) {
                result.append(subnode.getNodeValue());
                continue;
            }
            if (subnode.getNodeType() == 4) {
                result.append(subnode.getNodeValue());
                continue;
            }
            if (subnode.getNodeType() != 5) continue;
            result.append(DbmfToHbaseXsltFunctions.getText(subnode));
        }
        return result.toString().trim();
    }
}

