<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:dc="http://purl.org/dc/elements/1.1/"
                xmlns:dri="http://www.driver-repository.eu/namespace/dri" xmlns:dr="http://www.driver-repository.eu/namespace/dr"
                xmlns:dnet="eu.dnetlib.data.transform.xml.OafToHbaseXsltFunctions"
                xmlns:exslt="http://exslt.org/common"
                version="1.0" extension-element-prefixes="exslt"
                exclude-result-prefixes="xsl oaf dr dri dnet exslt">

	<xsl:output omit-xml-declaration="yes" indent="yes"/>

	<xsl:param name="writeCoAuthors" select="false()"/>

	<xsl:param name="trust" select="string('0.9')"/>
	<xsl:param name="provenance" select="string('sysimport:crosswalk:repository')"/>

	<xsl:template match="/*">
		<xsl:variable name="about" select="/*[local-name() = 'record']/*[local-name() = 'about']"/>
		<xsl:variable name="dateofcollection" select="/*[local-name() = 'record']/*[local-name() = 'header']/*[local-name()='dateOfCollection' and text()][1]"/>
		<xsl:variable name="dateoftransformation" select="/*[local-name() = 'record']/*[local-name() = 'header']/*[local-name()='dateOfTransformation' and text()][1]"/>
		<xsl:variable name="metadata" select="exslt:node-set(/*[local-name() = 'record']/*[local-name()='metadata']/*)"/>
		<xsl:variable name="namespaceprefix">
			<xsl:choose>

				<!-- TODO check namespaceprefix length is 12 -->
				<xsl:when test="string-length(//oaf:datasourceprefix) &gt; 0">
					<xsl:value-of select="//oaf:datasourceprefix"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="unknown_"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:choose>
			<!-- 			<xsl:when test="count($metadata) = 0 or string-length($namespaceprefix) = 0"> -->
			<xsl:when test="count($metadata) = 0">
				<ROWS/>
			</xsl:when>
			<xsl:otherwise>

				<xsl:variable name="objIdentifier" select="//dri:objIdentifier"/>
				<xsl:variable name="resultId" select="dnet:oafSimpleId('result', //dri:objIdentifier)"/>

				<xsl:if test="string-length($resultId) &gt; 0">

					<xsl:variable name="cobjcategory" select="//dr:CobjCategory"/>
					<xsl:choose>
						<!-- check if we need to exclude datasets from an OAF MDStore-->
						<xsl:when test="$cobjcategory = '0021'">
							<ROWS/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:variable name="collectedfromid" select="dnet:oafSplitId('datasource', //oaf:collectedFrom/@id)"/>
							<xsl:variable name="collectedfromname" select="//oaf:collectedFrom/@name"/>

							<xsl:variable name="hostedbyid" select="dnet:oafSplitId('datasource', //oaf:hostedBy/@id)"/>
							<xsl:variable name="hostedbyname" select="//oaf:hostedBy/@name"/>

							<xsl:variable name="originalidTest" select="/*[local-name()='record']/*[local-name() = 'header']/*[local-name() = 'recordIdentifier']"/>
							<xsl:variable name="originalid">
								<xsl:choose>
									<xsl:when test="contains($originalidTest, '::')">
										<xsl:value-of select="substring-after($originalidTest, '::')"/>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$originalidTest"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:variable>

							<xsl:variable name="result"
							              select="dnet:oafResult($resultId, $provenance, $trust, $about, $hostedbyid, $hostedbyname, $collectedfromid,
					              $collectedfromname, $originalid, $dateofcollection, $dateoftransformation, $metadata)"/>

							<ROWS>
								<ROW key="{$resultId}" columnFamily="result">
									<QUALIFIER name="body" type="base64">
										<xsl:value-of select="$result"/>
									</QUALIFIER>
								</ROW>

								<xsl:for-each select="//*[local-name()='projectid']">

									<xsl:variable name="projectId" select="dnet:oafSplitId('project', normalize-space(.))"/>

									<xsl:if test="string-length($projectId) &gt; 0">

										<xsl:variable name="resultproject"
										              select="dnet:rel($resultId, $projectId, 'resultProject', 'outcome', 'isProducedBy',
								              $collectedfromid, $collectedfromname, $provenance, $trust, $about)"/>
										<xsl:variable name="projectresult"
										              select="dnet:rel($projectId, $resultId, 'resultProject', 'outcome', 'produces',
								              $collectedfromid, $collectedfromname, $provenance, $trust, $about)"/>

										<ROW key="{$resultId}" columnFamily="resultProject_outcome_isProducedBy">
											<QUALIFIER name="{$projectId}" type="base64">
												<xsl:value-of select="$resultproject"/>
											</QUALIFIER>
										</ROW>
										<ROW key="{$projectId}" columnFamily="resultProject_outcome_produces">
											<QUALIFIER name="{$resultId}" type="base64">
												<xsl:value-of select="$projectresult"/>
											</QUALIFIER>
										</ROW>
									</xsl:if>
								</xsl:for-each>

								<xsl:for-each select="//*[local-name()='relatedDataset']">

									<!-- relatedDataset ids must be in the openaire format  -->
									<xsl:variable name="datasetId" select="dnet:oafSimpleId('result', normalize-space(./@id))"/>

									<xsl:if test="string-length($datasetId) &gt; 0">

										<xsl:variable name="resultDataset"
										              select="dnet:rel($resultId, $datasetId, 'resultResult', 'publicationDataset', 'isRelatedTo',
								              $collectedfromid, $collectedfromname, $provenance, $trust, $about)"/>
										<xsl:variable name="datasetResult"
										              select="dnet:rel($datasetId, $resultId, 'resultResult', 'publicationDataset', 'isRelatedTo',
								              $collectedfromid, $collectedfromname, $provenance, $trust, $about)"/>

										<ROW key="{$resultId}" columnFamily="resultResult_publicationDataset_isRelatedTo">
											<QUALIFIER name="{$datasetId}" type="base64">
												<xsl:value-of select="$resultDataset"/>
											</QUALIFIER>
										</ROW>
										<ROW key="{$datasetId}" columnFamily="resultResult_publicationDataset_isRelatedTo">
											<QUALIFIER name="{$resultId}" type="base64">
												<xsl:value-of select="$datasetResult"/>
											</QUALIFIER>
										</ROW>
									</xsl:if>
								</xsl:for-each>
							</ROWS>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
