package eu.dnetlib.data.transform.xml.vtd;

import java.util.*;

import com.ximpleware.*;
import org.apache.commons.lang3.StringUtils;

public class VtdUtilityParser {

	public static final String NS_SEPARATOR = ":";

	public static String xpath(final String ... p) {
		return Arrays.stream(p)
				.map(s -> String.format("/*[local-name()='%s']", s))
				.reduce((s1, s2) -> s1 + s2)
				.get();
	}

	public static VTDGen parseXml(final String xml) throws VtdException {
		final VTDGen vg = new VTDGen();
		vg.setDoc(xml.getBytes());
		try {
			vg.parse(true);
		} catch (ParseException e) {
			throw new VtdException(e);
		}
		return vg;
	}

	public static int countNodes(final AutoPilot ap, final VTDNav vn, final String xpath) throws VtdException {
		if (StringUtils.isBlank(xpath)) {
			return 0;
		}
		try {
			ap.selectXPath(xpath);
			ap.bind(vn);
			final Double i = ap.evalXPathToNumber();
			return i.intValue();
		} catch (XPathParseException e) {
			throw new VtdException(e);
		}
	}

	public static Node getNode(final AutoPilot ap, final VTDNav vn, final String xpath) throws VtdException {
		if (StringUtils.isBlank(xpath)) {
			return new Node();
		}
		try {
			ap.selectXPath(xpath);

			while (ap.evalXPath() != -1) {
				return asNode(vn);
			}

			return null;
		} catch (Exception e) {
			throw new VtdException(e);
		}
	}

	public static List<Node> getNodes(final AutoPilot ap, final VTDNav vn, final String xpath) throws VtdException {
        final List<Node> results = new ArrayList<>();
        if (StringUtils.isBlank(xpath)) {
        	return results;
        }
        try {
            ap.selectXPath(xpath);

            while (ap.evalXPath() != -1) {
                results.add(asNode(vn));
            }
            return results;
        } catch (Exception e) {
            throw new VtdException(e);
        }
	}

	private static Node asNode(final VTDNav vn) throws NavException {
		final Node currentNode = new Node();
		int t = vn.getText();
		if (t >= 0) {
			final String name = vn.toRawString(vn.getCurrentIndex());
			currentNode.setName(name.contains(NS_SEPARATOR) ? StringUtils.substringAfter(name, NS_SEPARATOR) : name);
			currentNode.setTextValue(vn.toNormalizedString(t));
		}
		currentNode.setAttributes(getAttributes(vn));
		return currentNode;
	}

	private static Map<String, String> getAttributes(final VTDNav vn) throws NavException {
		final AutoPilot ap = new AutoPilot(vn);
		ap.selectAttr("*");
		Map<String, String> attributes = new HashMap<>();
		int i;
		while((i = ap.iterateAttr()) != -1){
			attributes.put(vn.toNormalizedString(i),vn.toNormalizedString(i + 1) );
		}
		return attributes;
	}

	public static List<String> getTextValue(final AutoPilot ap, final VTDNav vn, final String xpath) throws VtdException {
		final List<String> results = new ArrayList<>();
		if (StringUtils.isBlank(xpath)) {
			return results;
		}
		try {
			ap.selectXPath(xpath);
			while (ap.evalXPath() != -1) {
				int t = vn.getText();
				if (t > -1) results.add(vn.toNormalizedString(t));
			}
			return results;
		} catch (Exception e) {
			throw new VtdException(e);
		}
	}

	public static String getFirstValue(final AutoPilot ap, final VTDNav nav, final String xpath) throws VtdException {
		if (StringUtils.isBlank(xpath)) {
			return null;
		}
		try {
			ap.selectXPath(xpath);
			while (ap.evalXPath() != -1) {
				int it = nav.getText();
				if (it > -1)
					return nav.toNormalizedString(it);
			}
			return null;
		} catch (Exception e) {
			throw new VtdException(e);
		}
	}

	@Deprecated
	public static String getSingleValue(final AutoPilot ap, final VTDNav nav, final String xpath) throws VtdException {
		return getFirstValue(ap, nav, xpath);
	}

	public static class Node {

		private String name;

		private String textValue;

		private Map<String, String> attributes;

		public String getTextValue() {
			return textValue;
		}

		public void setTextValue(final String textValue) {
			this.textValue = textValue;
		}

		public Map<String, String> getAttributes() {
			return attributes;
		}

		public void setAttributes(final Map<String, String> attributes) {
			this.attributes = attributes;
		}

		public String getName() {
			return name;
		}

		public void setName(final String name) {
			this.name = name;
		}
	}

}
