/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform.xml.vtd;

import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.ximpleware.AutoPilot;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.AbstractDNetXsltFunctions;
import eu.dnetlib.data.transform.xml.vtd.SpecificationDescriptor;
import eu.dnetlib.data.transform.xml.vtd.SpecificationMap;
import eu.dnetlib.data.transform.xml.vtd.VtdException;
import eu.dnetlib.data.transform.xml.vtd.VtdUtilityParser;
import eu.dnetlib.miscutils.collections.Pair;
import eu.dnetlib.pace.model.Person;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractResultVtdParser
implements Function<String, OafProtos.Oaf> {
    private static final Log log = LogFactory.getLog(AbstractResultVtdParser.class);
    public static final String URL_REGEX = "^(http|https|ftp)\\://.*";
    public static final String ID_SEPARATOR = "::";
    public static final String TITLE_TYPE = "titleType";
    public static final String DATE_TYPE = "dateType";
    public static final String KEYWORD = "keyword";
    public static final String DNET_EXT_REF_TYPOLOGIES = "dnet:externalReference_typologies";
    public static final String DNET_TITLE_TYPOLOGIES = "dnet:dataCite_title";
    public static final String DNET_SUBJECT_TYPOLOGIES = "dnet:subject_classification_typologies";
    public static final String DNET_RESULT_TYPOLOGIES = "dnet:result_typologies";
    public static final String DNET_PUBLICATION_RESOURCE = "dnet:publication_resource";
    public static final String DNET_DATA_CITE_RESOURCE = "dnet:dataCite_resource";
    public static final String DNET_ACCESS_MODES = "dnet:access_modes";
    public static final String DNET_LANGUAGES = "dnet:languages";
    public static final String DNET_PID_TYPES = "dnet:pid_types";
    public static final String IDENTIFIER_TYPE = "identifierType";
    public static final String ALTERNATE_IDENTIFIER_TYPE = "alternateIdentifierType";
    public static final String DNET_PROVENANCE_ACTIONS = "dnet:provenanceActions";
    public static final String CLASSID = "classid";
    public static final String CLASSNAME = "classname";
    public static final String SCHEMEID = "schemeid";
    public static final String SCHEMENAME = "schemename";
    public static final String RELATION_TYPE = "relationType";
    public static final String RELATED_IDENTIFIER_TYPE = "relatedIdentifierType";
    public static final String RIGHTS_URI = "rightsURI";
    public static final String UTF_8 = "UTF-8";
    public static final String PROJECTID = "projectid";
    public static final String RELATED_DATASET = "relateddataset";
    public static final String RELATED_PUBLICATION = "relatedpublication";
    public static final String RELATED_IDENTIFIER = "relatedidentifier";
    protected static Map<String, String> mappingAccess = Maps.newHashMap();
    protected boolean invisible = false;
    protected String provenance = "";
    protected String trust = "0.9";

    public AbstractResultVtdParser() {
    }

    public AbstractResultVtdParser(boolean invisible, String provenance, String trust) {
        this.invisible = invisible;
        this.provenance = provenance;
        this.trust = trust;
    }

    @Override
    public OafProtos.Oaf apply(String xml) {
        try {
            VTDGen vg = VtdUtilityParser.parseXml(xml);
            VTDNav vn = vg.getNav();
            AutoPilot ap = new AutoPilot(vn);
            boolean skiprecord = Boolean.valueOf(VtdUtilityParser.getFirstValue(ap, vn, VtdUtilityParser.xpath("record", "header", "skipRecord")));
            int metadata = VtdUtilityParser.countNodes(ap, vn, String.format("count(%s)", VtdUtilityParser.xpath("record", "metadata")));
            if (metadata == 0 || skiprecord) {
                return null;
            }
            String objIdentifier = AbstractDNetXsltFunctions.oafSimpleId(TypeProtos.Type.result.name(), VtdUtilityParser.getFirstValue(ap, vn, VtdUtilityParser.xpath("record", "header", "objIdentifier")));
            if (StringUtils.isBlank((CharSequence)objIdentifier)) {
                return null;
            }
            return this.transform(ap, vn, objIdentifier, this.getFields());
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage());
            log.error((Object)ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    protected OafProtos.Oaf transform(AutoPilot ap, VTDNav vn, String objIdentifier, Map<String, String> fields) throws VtdException {
        SpecificationMap specs = new SpecificationMap();
        specs.put(ResultProtos.Result.getDescriptor(), SpecificationDescriptor.newInstance()).setBuilder((Message.Builder)ResultProtos.Result.newBuilder()).put("externalReference", fields.get("externalReference"), nodes -> nodes.stream().map(node -> {
            String type;
            String query;
            String title;
            String identifier;
            Map<String, String> a;
            String source;
            ResultProtos.Result.ExternalReference.Builder extref = ResultProtos.Result.ExternalReference.newBuilder();
            if (StringUtils.isNotBlank((CharSequence)node.getTextValue())) {
                extref.setUrl(node.getTextValue());
            }
            if (StringUtils.isNotBlank((CharSequence)(source = (a = node.getAttributes()).get("source")))) {
                extref.setSitename(source);
            }
            if (StringUtils.isNotBlank((CharSequence)(identifier = a.get("identifier")))) {
                extref.setRefidentifier(identifier);
            }
            if (StringUtils.isNotBlank((CharSequence)(title = a.get("title")))) {
                extref.setLabel(title);
            }
            if (StringUtils.isNotBlank((CharSequence)(query = a.get("query")))) {
                extref.setQuery(query);
            }
            if (StringUtils.isNotBlank((CharSequence)(type = a.get("type")))) {
                extref.setQualifier(this.getSimpleQualifier(type, DNET_EXT_REF_TYPOLOGIES));
            }
            return extref.build();
        }));
        specs.put(ResultProtos.Result.Instance.getDescriptor(), SpecificationDescriptor.newInstance()).setBuilder((Message.Builder)ResultProtos.Result.Instance.newBuilder()).put("license", fields.get("license"), nodes -> nodes.stream().filter(node -> {
            Map<String, String> a = node.getAttributes();
            switch (node.getName()) {
                case "rights": {
                    return a.containsKey(RIGHTS_URI) && a.get(RIGHTS_URI).matches(URL_REGEX);
                }
                case "license": {
                    return true;
                }
            }
            return false;
        }).map(VtdUtilityParser.Node::getTextValue)).put("accessright", fields.get("accessright"), nodes -> nodes.stream().map(VtdUtilityParser.Node::getTextValue).map(rights -> mappingAccess.containsKey(rights) ? mappingAccess.get(rights) : "UNKNOWN").map(code -> this.getQualifier((String)code, this.getClassName((String)code), DNET_ACCESS_MODES, DNET_ACCESS_MODES))).put("instancetype", fields.get("instancetype"), nodes -> nodes.stream().map(VtdUtilityParser.Node::getTextValue).map(code -> this.getQualifier((String)code, this.getClassName((String)code), DNET_PUBLICATION_RESOURCE, DNET_PUBLICATION_RESOURCE))).put("hostedby", fields.get("hostedby"), nodes -> nodes.stream().map(node -> this.getKV(AbstractDNetXsltFunctions.oafSplitId("datasource", node.getAttributes().get("id")), node.getAttributes().get("name")))).put("url", fields.get("url"), nodes -> nodes.stream().map(VtdUtilityParser.Node::getTextValue).filter(s -> s.trim().matches(URL_REGEX))).put("dateofacceptance", fields.get("dateofacceptance"), nodes -> nodes.stream().map(VtdUtilityParser.Node::getTextValue));
        specs.put(ResultProtos.Result.Metadata.getDescriptor(), SpecificationDescriptor.newInstance()).setBuilder((Message.Builder)ResultProtos.Result.Metadata.newBuilder()).put("title", fields.get("title"), nodes -> nodes.stream().map(node -> {
            FieldTypeProtos.Qualifier.Builder q = FieldTypeProtos.Qualifier.newBuilder().setSchemeid(DNET_TITLE_TYPOLOGIES).setSchemename(DNET_TITLE_TYPOLOGIES);
            switch (node.getAttributes().get(TITLE_TYPE) + "") {
                case "AlternativeTitle": {
                    q.setClassid("alternative title").setClassname("alternative title");
                    break;
                }
                case "Subtitle": {
                    q.setClassid("subtitle").setClassname("subtitle");
                    break;
                }
                case "TranslatedTitle": {
                    q.setClassid("translated title").setClassname("translated title");
                    break;
                }
                default: {
                    q.setClassid("main title").setClassname("main title");
                }
            }
            return FieldTypeProtos.StructuredProperty.newBuilder().setValue(node.getTextValue()).setQualifier(q).build();
        })).put("description", fields.get("description"), nodes -> nodes.stream().map(VtdUtilityParser.Node::getTextValue)).put("storagedate", fields.get("storagedate"), nodes -> nodes.stream().map(VtdUtilityParser.Node::getTextValue)).put("lastmetadataupdate", fields.get("lastmetadataupdate"), nodes -> nodes.stream().map(VtdUtilityParser.Node::getTextValue)).put("embargoenddate", fields.get("embargoenddate"), nodes -> nodes.stream().map(VtdUtilityParser.Node::getTextValue)).put("dateofacceptance", fields.get("dateofacceptance"), nodes -> nodes.stream().map(VtdUtilityParser.Node::getTextValue)).put("author", fields.get("author"), nodes -> Streams.mapWithIndex(nodes.stream().map(VtdUtilityParser.Node::getTextValue), (creator, i) -> new Pair((Object)i, creator)).map(pair -> {
            FieldTypeProtos.Author.Builder author = FieldTypeProtos.Author.newBuilder();
            author.setFullname((String)pair.getValue());
            author.setRank(((Long)pair.getKey()).intValue() + 1);
            Person p = new Person((String)pair.getValue(), false);
            if (p.isAccurate()) {
                author.setName(p.getNormalisedFirstName());
                author.setSurname(p.getNormalisedSurname());
            }
            return author.build();
        })).put("contributor", fields.get("contributor"), nodes -> nodes.stream().map(VtdUtilityParser.Node::getTextValue)).put("subject", fields.get("subject"), nodes -> nodes.stream().map(node -> {
            Map<String, String> a = node.getAttributes();
            String classId = StringUtils.isNotBlank((CharSequence)a.get(CLASSID)) ? a.get(CLASSID) : KEYWORD;
            String className = StringUtils.isNotBlank((CharSequence)a.get(CLASSNAME)) ? a.get(CLASSNAME) : KEYWORD;
            String schemeId = StringUtils.isNotBlank((CharSequence)a.get(SCHEMEID)) ? a.get(SCHEMEID) : DNET_SUBJECT_TYPOLOGIES;
            String schemeName = StringUtils.isNotBlank((CharSequence)a.get(SCHEMENAME)) ? a.get(SCHEMENAME) : DNET_SUBJECT_TYPOLOGIES;
            return this.getStructuredProperty(node.getTextValue(), classId, className, schemeId, schemeName);
        })).put("format", fields.get("format"), nodes -> nodes.stream().map(VtdUtilityParser.Node::getTextValue)).put("source", fields.get("source"), nodes -> nodes.stream().map(VtdUtilityParser.Node::getTextValue)).put("size", fields.get("size"), nodes -> nodes.stream().map(VtdUtilityParser.Node::getTextValue)).put("version", fields.get("version"), nodes -> nodes.stream().map(VtdUtilityParser.Node::getTextValue)).put("publisher", fields.get("publisher"), nodes -> nodes.stream().map(VtdUtilityParser.Node::getTextValue)).put("language", fields.get("language"), nodes -> nodes.stream().map(VtdUtilityParser.Node::getTextValue).map(code -> this.getQualifier((String)code, this.getClassName((String)code), DNET_LANGUAGES, DNET_LANGUAGES))).put("resourcetype", fields.get("resourcetype"), nodes -> nodes.stream().map(node -> node.getAttributes().get("resourceTypeGeneral")).map(resourceType -> this.getSimpleQualifier((String)resourceType, DNET_DATA_CITE_RESOURCE))).put("resulttype", fields.get("resulttype"), nodes -> nodes.stream().map(VtdUtilityParser.Node::getTextValue).map(cobjcategory -> this.getSimpleQualifier(this.getResulttype((String)cobjcategory), DNET_RESULT_TYPOLOGIES))).put("concept", fields.get("concept"), nodes -> nodes.stream().filter(node -> node.getAttributes() != null && StringUtils.isNotBlank((CharSequence)node.getAttributes().get("id"))).map(node -> ResultProtos.Result.Context.newBuilder().setId(node.getAttributes().get("id")))).put("journal", fields.get("journal"), nodes -> nodes.stream().map(node -> {
            ResultProtos.Result.Journal.Builder journal = ResultProtos.Result.Journal.newBuilder();
            if (StringUtils.isNotBlank((CharSequence)node.getTextValue())) {
                journal.setName(node.getTextValue());
            }
            if (node.getAttributes() != null) {
                Map<String, String> a = node.getAttributes();
                if (StringUtils.isNotBlank((CharSequence)a.get("issn"))) {
                    journal.setIssnPrinted(a.get("issn"));
                }
                if (StringUtils.isNotBlank((CharSequence)a.get("eissn"))) {
                    journal.setIssnOnline(a.get("eissn"));
                }
                if (StringUtils.isNotBlank((CharSequence)a.get("lissn"))) {
                    journal.setIssnLinking(a.get("lissn"));
                }
                if (StringUtils.isNotBlank((CharSequence)a.get("sp"))) {
                    journal.setSp(a.get("sp"));
                }
                if (StringUtils.isNotBlank((CharSequence)a.get("ep"))) {
                    journal.setEp(a.get("ep"));
                }
                if (StringUtils.isNotBlank((CharSequence)a.get("iss"))) {
                    journal.setIss(a.get("iss"));
                }
                if (StringUtils.isNotBlank((CharSequence)a.get("vol"))) {
                    journal.setVol(a.get("vol"));
                }
            }
            return journal;
        }));
        specs.put(OafProtos.OafEntity.getDescriptor(), SpecificationDescriptor.newInstance()).setBuilder((Message.Builder)OafProtos.OafEntity.newBuilder().setType(TypeProtos.Type.result).setId(objIdentifier)).put("originalId", fields.get("originalId"), nodes -> nodes.stream().map(VtdUtilityParser.Node::getTextValue).map(s -> StringUtils.contains((CharSequence)s, (CharSequence)ID_SEPARATOR) ? StringUtils.substringAfter((String)s, (String)ID_SEPARATOR) : s).filter(s -> !s.trim().matches(URL_REGEX))).put("collectedfrom", fields.get("collectedfrom"), nodes -> nodes.stream().map(node -> this.getKV(AbstractDNetXsltFunctions.oafSplitId(TypeProtos.Type.datasource.name(), node.getAttributes().get("id")), node.getAttributes().get("name")))).put("pid", fields.get("pid"), nodes -> nodes.stream().filter(pid -> {
            Map<String, String> a = pid.getAttributes();
            return a.containsKey(IDENTIFIER_TYPE) || a.containsKey(ALTERNATE_IDENTIFIER_TYPE);
        }).filter(pid -> {
            Map<String, String> a = pid.getAttributes();
            return !"url".equalsIgnoreCase(a.get(IDENTIFIER_TYPE)) && !"url".equalsIgnoreCase(a.get(ALTERNATE_IDENTIFIER_TYPE));
        }).map(pid -> {
            Map<String, String> a = pid.getAttributes();
            String identifierType = a.get(IDENTIFIER_TYPE);
            String altIdentifierType = a.get(ALTERNATE_IDENTIFIER_TYPE);
            return FieldTypeProtos.StructuredProperty.newBuilder().setValue(pid.getTextValue()).setQualifier(this.getSimpleQualifier(StringUtils.isNotBlank((CharSequence)identifierType) ? identifierType : altIdentifierType, DNET_PID_TYPES)).build();
        })).put("dateofcollection", fields.get("dateofcollection"), nodes -> nodes.stream().map(VtdUtilityParser.Node::getTextValue)).put("dateoftransformation", fields.get("dateoftransformation"), nodes -> nodes.stream().map(VtdUtilityParser.Node::getTextValue)).put("cachedRel", fields.get("cachedRel"), nodes -> nodes.stream().map(node -> this.getOafRel(objIdentifier, (VtdUtilityParser.Node)node, OafProtos.OafRel.newBuilder().setSource(objIdentifier).setChild(false))).filter(Objects::nonNull).map(oafRel -> oafRel.build()));
        for (Map.Entry spec : specs.entrySet()) {
            Descriptors.Descriptor d = (Descriptors.Descriptor)spec.getKey();
            SpecificationDescriptor md = (SpecificationDescriptor)spec.getValue();
            for (Map.Entry<String, Pair<String, Function<List<VtdUtilityParser.Node>, Object>>> entry : md.getFields().entrySet()) {
                String fieldName = entry.getKey();
                Pair<String, Function<List<VtdUtilityParser.Node>, Object>> pair = entry.getValue();
                String xpath = (String)pair.getKey();
                Function function = (Function)pair.getValue();
                this.addField(md.getBuilder(), d.findFieldByName(fieldName), function.apply(VtdUtilityParser.getNodes(ap, vn, xpath)));
            }
        }
        return OafProtos.Oaf.newBuilder().setKind(KindProtos.Kind.entity).setDataInfo(this.ensureDataInfo(ap, vn, FieldTypeProtos.DataInfo.newBuilder())).setEntity(((OafProtos.OafEntity.Builder)((SpecificationDescriptor)specs.get(OafProtos.OafEntity.getDescriptor())).getBuilder().setField(OafProtos.OafEntity.getDescriptor().findFieldByName(TypeProtos.Type.result.name()), (Object)((ResultProtos.Result.Builder)((SpecificationDescriptor)specs.get(ResultProtos.Result.getDescriptor())).getBuilder()).setMetadata((ResultProtos.Result.Metadata)((SpecificationDescriptor)specs.get(ResultProtos.Result.Metadata.getDescriptor())).getBuilder().build()).addInstance((ResultProtos.Result.Instance)((SpecificationDescriptor)specs.get(ResultProtos.Result.Instance.getDescriptor())).getBuilder().build()).build())).setOaiprovenance(this.getOaiProvenance(ap, vn)).build()).build();
    }

    private OafProtos.OafRel.Builder getOafRel(String objIdentifier, VtdUtilityParser.Node node, OafProtos.OafRel.Builder oafRel) {
        Map<String, String> a = node.getAttributes();
        switch (node.getName().toLowerCase()) {
            case "projectid": {
                return oafRel.setTarget(AbstractDNetXsltFunctions.oafSplitId(TypeProtos.Type.project.name(), StringUtils.trim((String)node.getTextValue()))).setRelType(RelTypeProtos.RelType.resultProject).setSubRelType(RelTypeProtos.SubRelType.outcome).setRelClass("isProducedBy");
            }
            case "relatedpublication": 
            case "relateddataset": {
                return oafRel.setTarget(AbstractDNetXsltFunctions.oafSimpleId(TypeProtos.Type.result.name(), StringUtils.trim((String)a.get("id")))).setRelType(RelTypeProtos.RelType.resultResult).setSubRelType(RelTypeProtos.SubRelType.publicationDataset).setRelClass("isRelatedTo");
            }
            case "relatedidentifier": {
                return oafRel.setTarget(node.getTextValue()).setRelType(RelTypeProtos.RelType.resultResult).setSubRelType(RelTypeProtos.SubRelType.relationship).setRelClass(a.get(RELATION_TYPE)).setCachedTarget(OafProtos.OafEntity.newBuilder().setType(TypeProtos.Type.result).setId(objIdentifier).addPid(FieldTypeProtos.StructuredProperty.newBuilder().setValue(node.getTextValue()).setQualifier(this.getSimpleQualifier(a.get(RELATED_IDENTIFIER_TYPE), DNET_PID_TYPES)).build()));
            }
        }
        return null;
    }

    protected abstract String getResulttype(String var1);

    protected abstract Map<String, String> getFields();

    protected String metadataXpath(String otherValues) {
        return VtdUtilityParser.xpath("record", "metadata", otherValues);
    }

    private FieldTypeProtos.OAIProvenance.OriginDescription getOriginDescription(AutoPilot ap, VTDNav vn, String basePath) throws VtdException {
        FieldTypeProtos.OAIProvenance.OriginDescription originDescription;
        String metadataNamespace;
        String datestamp;
        String identifier;
        String altered;
        FieldTypeProtos.OAIProvenance.OriginDescription.Builder od = FieldTypeProtos.OAIProvenance.OriginDescription.newBuilder();
        if (VtdUtilityParser.getNodes(ap, vn, basePath).isEmpty()) {
            return od.build();
        }
        Map<String, String> odAttr = VtdUtilityParser.getNode(ap, vn, basePath).getAttributes();
        String harvestDate = odAttr.get("harvestDate");
        if (StringUtils.isNotBlank((CharSequence)harvestDate)) {
            od.setHarvestDate(harvestDate);
        }
        if (StringUtils.isNotBlank((CharSequence)(altered = odAttr.get("altered")))) {
            od.setAltered(Boolean.valueOf(altered).booleanValue());
        }
        String baseUrl = VtdUtilityParser.getFirstValue(ap, vn, basePath + VtdUtilityParser.xpath("baseURL"));
        if (StringUtils.isNotBlank((CharSequence)basePath)) {
            od.setBaseURL(baseUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)(identifier = VtdUtilityParser.getFirstValue(ap, vn, basePath + VtdUtilityParser.xpath("identifier"))))) {
            od.setIdentifier(identifier);
        }
        if (StringUtils.isNotBlank((CharSequence)(datestamp = VtdUtilityParser.getFirstValue(ap, vn, basePath + VtdUtilityParser.xpath("datestamp"))))) {
            od.setDatestamp(datestamp);
        }
        if (StringUtils.isNotBlank((CharSequence)(metadataNamespace = VtdUtilityParser.getFirstValue(ap, vn, basePath + VtdUtilityParser.xpath("metadataNamespace"))))) {
            od.setMetadataNamespace(metadataNamespace);
        }
        if ((originDescription = this.getOriginDescription(ap, vn, basePath + VtdUtilityParser.xpath("originDescription"))).hasHarvestDate()) {
            od.setOriginDescription(originDescription);
        }
        return od.build();
    }

    private void addField(Message.Builder builder, Descriptors.FieldDescriptor descriptor, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Stream) {
            this.addField(builder, descriptor, ((Stream)value).collect(Collectors.toList()));
        } else if (value instanceof Collection) {
            for (Object o : (Collection)value) {
                this.addField(builder, descriptor, o);
            }
        } else {
            Object v = value;
            switch (descriptor.getType()) {
                case BOOL: {
                    v = Boolean.valueOf(value.toString());
                    break;
                }
                case BYTES: {
                    v = value.toString().getBytes(Charset.forName(UTF_8));
                    break;
                }
                case DOUBLE: {
                    v = Double.valueOf(value.toString());
                    break;
                }
                case FLOAT: {
                    v = Float.valueOf(value.toString());
                    break;
                }
                case INT32: 
                case INT64: 
                case SINT32: 
                case SINT64: {
                    v = Integer.valueOf(value.toString());
                    break;
                }
                case MESSAGE: {
                    Message.Builder q = builder.newBuilderForField(descriptor);
                    if (value instanceof Message.Builder) {
                        v = ((Message.Builder)value).build();
                        byte[] b = ((Message)v).toByteArray();
                        try {
                            q.mergeFrom(b);
                        }
                        catch (InvalidProtocolBufferException e) {
                            throw new IllegalArgumentException("Unable to merge value: " + v + " with builder: " + q.getDescriptorForType().getName());
                        }
                    } else if (FieldTypeProtos.Qualifier.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof FieldTypeProtos.Qualifier) {
                            q.mergeFrom((Message)((FieldTypeProtos.Qualifier)v));
                        }
                    } else if (FieldTypeProtos.StructuredProperty.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof FieldTypeProtos.StructuredProperty) {
                            q.mergeFrom((Message)((FieldTypeProtos.StructuredProperty)v));
                        }
                    } else if (FieldTypeProtos.KeyValue.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof FieldTypeProtos.KeyValue) {
                            q.mergeFrom((Message)((FieldTypeProtos.KeyValue)v));
                        }
                    } else if (ResultProtos.Result.Journal.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof ResultProtos.Result.Journal) {
                            q.mergeFrom((Message)((ResultProtos.Result.Journal)v));
                        }
                    } else if (ResultProtos.Result.Context.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof ResultProtos.Result.Context) {
                            q.mergeFrom((Message)((ResultProtos.Result.Context)v));
                        }
                    } else if (FieldTypeProtos.Author.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof FieldTypeProtos.Author) {
                            q.mergeFrom((Message)((FieldTypeProtos.Author)v));
                        }
                    } else if (ResultProtos.Result.ExternalReference.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof ResultProtos.Result.ExternalReference) {
                            q.mergeFrom((Message)((ResultProtos.Result.ExternalReference)v));
                        }
                    } else if (OafProtos.OafRel.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof OafProtos.OafRel) {
                            q.mergeFrom((Message)((OafProtos.OafRel)v));
                        }
                    } else if (FieldTypeProtos.StringField.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof FieldTypeProtos.StringField) {
                            q.mergeFrom((Message)((FieldTypeProtos.StringField)v));
                        } else {
                            q.setField(FieldTypeProtos.StringField.getDescriptor().findFieldByName("value"), v);
                        }
                    } else if (FieldTypeProtos.BoolField.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof FieldTypeProtos.BoolField) {
                            q.mergeFrom((Message)((FieldTypeProtos.BoolField)v));
                        } else if (value instanceof String) {
                            q.setField(FieldTypeProtos.BoolField.getDescriptor().findFieldByName("value"), (Object)Boolean.valueOf((String)v));
                        } else {
                            q.setField(FieldTypeProtos.BoolField.getDescriptor().findFieldByName("value"), v);
                        }
                    } else if (FieldTypeProtos.IntField.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof FieldTypeProtos.IntField) {
                            q.mergeFrom((Message)((FieldTypeProtos.IntField)v));
                        } else if (value instanceof String) {
                            q.setField(FieldTypeProtos.IntField.getDescriptor().findFieldByName("value"), (Object)NumberUtils.toInt((String)((String)v)));
                        } else {
                            q.setField(FieldTypeProtos.IntField.getDescriptor().findFieldByName("value"), v);
                        }
                    }
                    v = q.buildPartial();
                    break;
                }
            }
            this.doAddField(builder, descriptor, v);
        }
    }

    private void doAddField(Message.Builder builder, Descriptors.FieldDescriptor fd, Object value) {
        if (value != null) {
            if (fd.isRepeated()) {
                builder.addRepeatedField(fd, value);
            } else if (fd.isOptional() || fd.isRequired()) {
                builder.setField(fd, value);
            }
        }
    }

    private FieldTypeProtos.OAIProvenance getOaiProvenance(AutoPilot ap, VTDNav vn) throws VtdException {
        return FieldTypeProtos.OAIProvenance.newBuilder().setOriginDescription(this.getOriginDescription(ap, vn, VtdUtilityParser.xpath("record", "about", "provenance", "originDescription"))).build();
    }

    private FieldTypeProtos.DataInfo.Builder ensureDataInfo(AutoPilot ap, VTDNav vn, FieldTypeProtos.DataInfo.Builder info) throws VtdException {
        if (info.isInitialized()) {
            return info;
        }
        return this.buildDataInfo(ap, vn, this.invisible, this.provenance, this.trust, false, false);
    }

    private FieldTypeProtos.DataInfo.Builder buildDataInfo(AutoPilot ap, VTDNav vn, boolean invisible, String defaultProvenanceaction, String defaultTrust, boolean defaultDeletedbyinference, boolean defaultInferred) throws VtdException {
        FieldTypeProtos.DataInfo.Builder dataInfoBuilder = FieldTypeProtos.DataInfo.newBuilder().setInvisible(invisible).setInferred(defaultInferred).setDeletedbyinference(defaultDeletedbyinference).setTrust(defaultTrust).setProvenanceaction(this.getSimpleQualifier(defaultProvenanceaction, DNET_PROVENANCE_ACTIONS));
        String xpath = VtdUtilityParser.xpath("record", "about", "datainfo");
        if (VtdUtilityParser.getNodes(ap, vn, xpath).size() > 0) {
            Map<String, String> provAction = VtdUtilityParser.getNode(ap, vn, xpath + VtdUtilityParser.xpath("provenanceaction")).getAttributes();
            dataInfoBuilder.setInvisible(Boolean.valueOf(AbstractResultVtdParser.getValue(VtdUtilityParser.getNode(ap, vn, xpath + VtdUtilityParser.xpath("invisible")), String.valueOf(invisible))).booleanValue()).setInferred(Boolean.valueOf(AbstractResultVtdParser.getValue(VtdUtilityParser.getNode(ap, vn, xpath + VtdUtilityParser.xpath("inferred")), String.valueOf(defaultInferred))).booleanValue()).setDeletedbyinference(Boolean.valueOf(AbstractResultVtdParser.getValue(VtdUtilityParser.getNode(ap, vn, xpath + VtdUtilityParser.xpath("deletedbyinference")), String.valueOf(defaultDeletedbyinference))).booleanValue()).setTrust(AbstractResultVtdParser.getValue(VtdUtilityParser.getNode(ap, vn, xpath + VtdUtilityParser.xpath("trust")), defaultTrust)).setInferenceprovenance(AbstractResultVtdParser.getValue(VtdUtilityParser.getNode(ap, vn, xpath + VtdUtilityParser.xpath("inferenceprovenance")), "")).setProvenanceaction(this.getSimpleQualifier(AbstractResultVtdParser.getValue(provAction.get(CLASSID), defaultProvenanceaction), DNET_PROVENANCE_ACTIONS));
        }
        return dataInfoBuilder;
    }

    private static String getValue(VtdUtilityParser.Node node, String defaultValue) {
        return node != null && StringUtils.isNotBlank((CharSequence)node.getTextValue()) ? node.getTextValue() : defaultValue;
    }

    private static String getValue(String value, String defaultValue) {
        return StringUtils.isNotBlank((CharSequence)value) ? value : defaultValue;
    }

    private FieldTypeProtos.KeyValue getKV(String id, String name) {
        return FieldTypeProtos.KeyValue.newBuilder().setKey(id).setValue(name).build();
    }

    private FieldTypeProtos.Qualifier getSimpleQualifier(String classname, String schemename) {
        return this.getQualifier(classname, classname, schemename, schemename);
    }

    private FieldTypeProtos.Qualifier getQualifier(String classid, String classname, String schemeid, String schemename) {
        return FieldTypeProtos.Qualifier.newBuilder().setClassid(classid).setClassname(classname).setSchemeid(schemeid).setSchemename(schemename).build();
    }

    private FieldTypeProtos.StructuredProperty getStructuredProperty(String value, String classid, String classname, String schemeid, String schemename) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        return FieldTypeProtos.StructuredProperty.newBuilder().setValue(value).setQualifier(this.getQualifier(classid, classname, schemeid, schemename)).build();
    }

    private String getClassName(String code) {
        String classname = AbstractDNetXsltFunctions.code2name.get(code);
        if (StringUtils.isBlank((CharSequence)classname)) {
            return code;
        }
        return classname;
    }

    static {
        mappingAccess.put("info:eu-repo/semantics/openAccess", "OPEN");
        mappingAccess.put("info:eu-repo/semantics/closedAccess", "CLOSED");
        mappingAccess.put("info:eu-repo/semantics/restrictedAccess", "RESTRICTED");
        mappingAccess.put("info:eu-repo/semantics/embargoedAccess", "EMBARGO");
        mappingAccess.put("OPEN", "OPEN");
        mappingAccess.put("CLOSED", "CLOSED");
        mappingAccess.put("RESTRICTED", "RESTRICTED");
        mappingAccess.put("EMBARGO", "EMBARGO");
    }
}

