package eu.dnetlib.data.transform.xml.vtd;

import java.util.Map;

import com.google.common.collect.Maps;

import static eu.dnetlib.data.transform.xml.vtd.VtdUtilityParser.xpath;

public class DatasetToProto extends AbstractResultVtdParser {

	public static DatasetToProto newInstance() {
		return new DatasetToProto();
	}

	public DatasetToProto() {}

	public DatasetToProto(final boolean invisible, final String provenance, final String trust) {
		super(invisible, provenance, trust);
	}

	@Override
	protected String getResulttype(final String cobjcategory) {
		switch (cobjcategory) {
		case "0029":
			return "software";
		default:
			return "dataset";
		}
	}

	@Override
	protected Map<String, String> getFields() {
		final Map<String, String> fields = Maps.newHashMap();
		fields.put("originalId", "//*[local-name() = 'resource']/*[local-name()='identifier'] | //*[local-name()='resource']//*[local-name()='alternateIdentifier']");
		fields.put("collectedfrom", metadataXpath("collectedFrom"));
		fields.put("pid", "//*[local-name() = 'resource']/*[local-name()='identifier'] | //*[local-name()='resource']//*[local-name()='alternateIdentifier']");
		fields.put("dateofcollection", xpath("record", "header", "dateOfCollection"));
		fields.put("dateoftransformation", xpath("record", "header", "dateOfTransformation"));
		fields.put("license", metadataXpath("resource") + "//*[local-name()='rights']");
		fields.put("accessright", metadataXpath("accessrights"));
		fields.put("instancetype", metadataXpath("CobjCategory"));
		fields.put("hostedby", metadataXpath("hostedBy"));
		fields.put("url", "/*[local-name()='record']/*[local-name()='metadata']/*[local-name()='resource']/*[local-name()='identifier' and (./@identifierType='DOI' or ./@identifierType='URL' ) ] | /*[local-name()='record']/*[local-name()='metadata']/*[local-name()='resource']//*[local-name()='alternateIdentifier' and ./@alternateIdentifierType='URL']");
		fields.put("title", "//*[local-name() = 'title']");
		fields.put("description", xpath("record", "metadata", "resource", "descriptions", "description"));
		fields.put("storagedate", "//*[local-name() = 'date' and ./@dateType = 'Issued']");
		fields.put("lastmetadataupdate", "//*[local-name() = 'date' and ./@dateType = 'Updated']");
		fields.put("embargoenddate", "//*[local-name() = 'date' and ./@dateType = 'Available']");
		fields.put("dateofacceptance", metadataXpath("dateAccepted"));
		fields.put("author", xpath("record", "metadata", "resource", "creator", "creatorName"));
		fields.put("contributor", xpath("record", "metadata", "resource", "contributor", "contributorName"));
		fields.put("subject", xpath("record", "metadata", "resource", "subjects", "subject"));
		fields.put("format", xpath("record", "metadata", "resource", "formats", "format"));
		fields.put("size", xpath("record", "metadata", "resource", "sizes", "size"));
		fields.put("version", xpath("record", "metadata", "resource", "versions", "version"));
		fields.put("publisher", xpath("record", "metadata", "resource", "publisher"));
		fields.put("language", xpath("record", "metadata", "language"));
		fields.put("resourcetype", xpath("record", "metadata", "resource", "resourceType"));
		fields.put("resulttype", xpath("record", "metadata", "CobjCategory"));

		fields.put("cachedRel", String.format("%s | %s | %s | %s",
				metadataXpath("projectid"),
				metadataXpath("relatedPublication"),
				metadataXpath("relatedDataSet"),
				metadataXpath("resource") + "//*[local-name()='relatedIdentifier']"));

		return fields;
	}

}
