package eu.dnetlib.data.transform.xml;

import java.util.Map;

import com.google.protobuf.Message.Builder;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.OafProtos.Oaf;
import eu.dnetlib.data.proto.OafProtos.OafRel;
import eu.dnetlib.data.proto.RelMetadataProtos.RelMetadata;
import eu.dnetlib.data.proto.RelTypeProtos.RelType;
import eu.dnetlib.data.proto.RelTypeProtos.SubRelType;
import org.w3c.dom.NodeList;

/**
 * Created by claudio on 01/12/15.
 */
public class CommonDNetXsltFunctions extends AbstractDNetXsltFunctions {

	private static final int MAX_COAUTHORS = 50;

	public static String rel(
			final String source,
			final String target,
			final String relType,
			final String subRelType,
			final String relClass,
			final String provenanceAction,
			final String trust) {
		return rel(source, target, relType, subRelType, relClass, null, null, provenanceAction, trust, null, null);
	}

	public static String rel(
			final String source,
			final String target,
			final String relType,
			final String subRelType,
			final String relClass,
			final String collectedFromId,
			final String collectedFromName,
			final String provenanceAction,
			final String trust) {
		return rel(source, target, relType, subRelType, relClass, collectedFromId, collectedFromName, provenanceAction, trust, null, null);
	}

	public static String rel(
			final String source,
			final String target,
			final String relType,
			final String subRelType,
			final String relClass,
			final String collectedFromId,
			final String collectedFromName,
			final String provenanceAction,
			final String trust,
			final NodeList about) {
		return rel(source, target, relType, subRelType, relClass, collectedFromId, collectedFromName, provenanceAction, trust, about, null);
	}

	// dnet:oafRel($resultId, $datasetId, 'resultResult', 'part' 'isPartOf', $about)
	public static String rel(
			final String source,
			final String target,
			final String relType,
			final String subRelType,
			final String relClass,
			final String collectedFromId,
			final String collectedFromName,
			final String provenanceAction,
			final String trust,
			final NodeList about,
			final Map<String, String> params) {
		try {
			final String eSource = OafRowKeyDecoder.decode(source).getKey();
			final String eTarget = OafRowKeyDecoder.decode(target).getKey();

			final RelType rType = RelType.valueOf(relType);
			final SubRelType srType = SubRelType.valueOf(subRelType);

			final RelMetadata.Builder metadata = RelMetadata.newBuilder().setSemantics(getSimpleQualifier(relClass, getVocabularyName(rType)));

			final Builder subRel = getSubRelBuilder(metadata, srType, params);

			final OafRel.Builder rel = getRelBuilder(rType, srType, getRel(eSource, eTarget, rType, srType, relClass, collectedFromId, collectedFromName, false), subRel);

			final Oaf oaf = getOaf(rel, getDataInfo(about, provenanceAction, trust, false, false));
			return base64(oaf.toByteArray());
		} catch (Exception e) {
			e.printStackTrace(System.err);
			throw new RuntimeException(e);
		}
	}

}
