package eu.dnetlib.data.transform.xml.vtd;

import java.util.List;
import java.util.Map;
import java.util.function.Function;

import com.google.common.collect.Maps;
import com.google.protobuf.Message.Builder;
import eu.dnetlib.data.transform.xml.vtd.VtdUtilityParser.Node;
import eu.dnetlib.miscutils.collections.Pair;

/**
 * Container class for Proto Builder and a Map that track associations field names -> [xpath, function]
 */
public class SpecificationDescriptor {

	private Builder builder;

	private Map<String, Pair<String, Function<List<Node>, Object>>> fields;

	public static SpecificationDescriptor newInstance() {
		return new SpecificationDescriptor().setFields(Maps.newHashMap());
	}

	public Builder getBuilder() {
		return builder;
	}

	public SpecificationDescriptor put(final String fieldName, final String xpath, final Function<List<Node>, Object> f) {
		getFields().put(fieldName, new Pair<>(xpath, f));
		return this;
	}

	public Pair<String, Function<List<Node>, Object>> get(final String fieldName) {
		return getFields().get(fieldName);
	}

	public Map<String, Pair<String, Function<List<Node>, Object>>> getFields() {
		return fields;
	}

	public SpecificationDescriptor setBuilder(final Builder builder) {
		this.builder = builder;
		return this;
	}

	public SpecificationDescriptor setFields(final Map<String, Pair<String, Function<List<Node>, Object>>> fields) {
		this.fields = fields;
		return this;
	}

}
