/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform.xml2;

import com.google.common.collect.Maps;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.transform.xml.AbstractDNetXsltFunctions;
import eu.dnetlib.data.transform.xml2.Node;
import eu.dnetlib.data.transform.xml2.VtdUtilityParser;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class Utils {
    public static final String URL_REGEX = "^(http|https|ftp)\\://.*";
    public static final String ID_SEPARATOR = "::";
    public static final String TITLE_TYPE = "titleType";
    public static final String DATE_TYPE = "dateType";
    public static final String KEYWORD = "keyword";
    public static final String DNET_EXT_REF_TYPOLOGIES = "dnet:externalReference_typologies";
    public static final String DNET_TITLE_TYPOLOGIES = "dnet:dataCite_title";
    public static final String DNET_SUBJECT_TYPOLOGIES = "dnet:subject_classification_typologies";
    public static final String DNET_RESULT_TYPOLOGIES = "dnet:result_typologies";
    public static final String DNET_PUBLICATION_RESOURCE = "dnet:publication_resource";
    public static final String DNET_DATA_CITE_RESOURCE = "dnet:dataCite_resource";
    public static final String DNET_ACCESS_MODES = "dnet:access_modes";
    public static final String DNET_LANGUAGES = "dnet:languages";
    public static final String DNET_PID_TYPES = "dnet:pid_types";
    public static final String IDENTIFIER_TYPE = "identifierType";
    public static final String ALTERNATE_IDENTIFIER_TYPE = "alternateIdentifierType";
    public static final String DNET_PROVENANCE_ACTIONS = "dnet:provenanceActions";
    public static final String CLASSID = "classid";
    public static final String CLASSNAME = "classname";
    public static final String SCHEMEID = "schemeid";
    public static final String SCHEMENAME = "schemename";
    public static final String RELATION_TYPE = "relationType";
    public static final String RELATED_IDENTIFIER_TYPE = "relatedIdentifierType";
    public static final String RIGHTS_URI = "rightsURI";
    public static final String UTF_8 = "UTF-8";
    public static final String PROJECTID = "projectid";
    public static final String RELATED_DATASET = "relatedDataSet";
    public static final String RELATED_PUBLICATION = "relatedPublication";
    public static final String RELATED_IDENTIFIER = "relatedIdentifier";
    protected static Map<String, String> mappingAccess = Maps.newHashMap();

    public static String getValue(Node node, String defaultValue) {
        return node != null && StringUtils.isNotBlank((CharSequence)node.getTextValue()) ? node.getTextValue() : defaultValue;
    }

    public static String getValue(String value, String defaultValue) {
        return StringUtils.isNotBlank((CharSequence)value) ? value : defaultValue;
    }

    public static FieldTypeProtos.KeyValue getKV(String id, String name) {
        return FieldTypeProtos.KeyValue.newBuilder().setKey(id).setValue(name).build();
    }

    public static FieldTypeProtos.Qualifier getSimpleQualifier(String classname, String schemename) {
        return Utils.getQualifier(classname, classname, schemename, schemename);
    }

    public static FieldTypeProtos.Qualifier getQualifier(String classid, String classname, String schemeid, String schemename) {
        return FieldTypeProtos.Qualifier.newBuilder().setClassid(classid).setClassname(classname).setSchemeid(schemeid).setSchemename(schemename).build();
    }

    public static FieldTypeProtos.StructuredProperty getStructuredProperty(String value, String classid, String classname, String schemeid, String schemename) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        return FieldTypeProtos.StructuredProperty.newBuilder().setValue(value).setQualifier(Utils.getQualifier(classid, classname, schemeid, schemename)).build();
    }

    public static String getClassName(String code) {
        String classname = AbstractDNetXsltFunctions.code2name.get(code);
        if (StringUtils.isBlank((CharSequence)classname)) {
            return code;
        }
        return classname;
    }

    public static String metadataXpath(String otherValues) {
        return VtdUtilityParser.xpath("record", "metadata", otherValues);
    }

    public static void addField(Message.Builder builder, Descriptors.FieldDescriptor descriptor, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Stream) {
            Utils.addField(builder, descriptor, ((Stream)value).collect(Collectors.toList()));
        } else if (value instanceof Collection) {
            for (Object o : (Collection)value) {
                Utils.addField(builder, descriptor, o);
            }
        } else {
            Object v = value;
            switch (descriptor.getType()) {
                case BOOL: {
                    v = Boolean.valueOf(value.toString());
                    break;
                }
                case BYTES: {
                    v = value.toString().getBytes(Charset.forName(UTF_8));
                    break;
                }
                case DOUBLE: {
                    v = Double.valueOf(value.toString());
                    break;
                }
                case FLOAT: {
                    v = Float.valueOf(value.toString());
                    break;
                }
                case INT32: 
                case INT64: 
                case SINT32: 
                case SINT64: {
                    v = Integer.valueOf(value.toString());
                    break;
                }
                case MESSAGE: {
                    Message.Builder q = builder.newBuilderForField(descriptor);
                    if (value instanceof Message.Builder) {
                        v = ((Message.Builder)value).build();
                        byte[] b = ((Message)v).toByteArray();
                        try {
                            q.mergeFrom(b);
                        }
                        catch (InvalidProtocolBufferException e) {
                            throw new IllegalArgumentException("Unable to merge value: " + v + " with builder: " + q.getDescriptorForType().getName());
                        }
                    } else if (FieldTypeProtos.Qualifier.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof FieldTypeProtos.Qualifier) {
                            q.mergeFrom((Message)((FieldTypeProtos.Qualifier)v));
                        }
                    } else if (FieldTypeProtos.StructuredProperty.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof FieldTypeProtos.StructuredProperty) {
                            q.mergeFrom((Message)((FieldTypeProtos.StructuredProperty)v));
                        }
                    } else if (FieldTypeProtos.KeyValue.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof FieldTypeProtos.KeyValue) {
                            q.mergeFrom((Message)((FieldTypeProtos.KeyValue)v));
                        }
                    } else if (ResultProtos.Result.Journal.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof ResultProtos.Result.Journal) {
                            q.mergeFrom((Message)((ResultProtos.Result.Journal)v));
                        }
                    } else if (ResultProtos.Result.Context.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof ResultProtos.Result.Context) {
                            q.mergeFrom((Message)((ResultProtos.Result.Context)v));
                        }
                    } else if (FieldTypeProtos.Author.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof FieldTypeProtos.Author) {
                            q.mergeFrom((Message)((FieldTypeProtos.Author)v));
                        }
                    } else if (ResultProtos.Result.ExternalReference.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof ResultProtos.Result.ExternalReference) {
                            q.mergeFrom((Message)((ResultProtos.Result.ExternalReference)v));
                        }
                    } else if (OafProtos.OafRel.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof OafProtos.OafRel) {
                            q.mergeFrom((Message)((OafProtos.OafRel)v));
                        }
                    } else if (FieldTypeProtos.StringField.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof FieldTypeProtos.StringField) {
                            q.mergeFrom((Message)((FieldTypeProtos.StringField)v));
                        } else {
                            q.setField(FieldTypeProtos.StringField.getDescriptor().findFieldByName("value"), v);
                        }
                    } else if (FieldTypeProtos.BoolField.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof FieldTypeProtos.BoolField) {
                            q.mergeFrom((Message)((FieldTypeProtos.BoolField)v));
                        } else if (value instanceof String) {
                            q.setField(FieldTypeProtos.BoolField.getDescriptor().findFieldByName("value"), (Object)Boolean.valueOf((String)v));
                        } else {
                            q.setField(FieldTypeProtos.BoolField.getDescriptor().findFieldByName("value"), v);
                        }
                    } else if (FieldTypeProtos.IntField.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof FieldTypeProtos.IntField) {
                            q.mergeFrom((Message)((FieldTypeProtos.IntField)v));
                        } else if (value instanceof String) {
                            q.setField(FieldTypeProtos.IntField.getDescriptor().findFieldByName("value"), (Object)NumberUtils.toInt((String)((String)v)));
                        } else {
                            q.setField(FieldTypeProtos.IntField.getDescriptor().findFieldByName("value"), v);
                        }
                    }
                    v = q.buildPartial();
                    break;
                }
            }
            Utils.doAddField(builder, descriptor, v);
        }
    }

    private static void doAddField(Message.Builder builder, Descriptors.FieldDescriptor fd, Object value) {
        if (value != null) {
            if (fd.isRepeated()) {
                builder.addRepeatedField(fd, value);
            } else if (fd.isOptional() || fd.isRequired()) {
                builder.setField(fd, value);
            }
        }
    }

    static {
        mappingAccess.put("info:eu-repo/semantics/openAccess", "OPEN");
        mappingAccess.put("info:eu-repo/semantics/closedAccess", "CLOSED");
        mappingAccess.put("info:eu-repo/semantics/restrictedAccess", "RESTRICTED");
        mappingAccess.put("info:eu-repo/semantics/embargoedAccess", "EMBARGO");
        mappingAccess.put("OPEN", "OPEN");
        mappingAccess.put("CLOSED", "CLOSED");
        mappingAccess.put("RESTRICTED", "RESTRICTED");
        mappingAccess.put("EMBARGO", "EMBARGO");
    }
}

