<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:dr="http://www.driver-repository.eu/namespace/dr"
                xmlns:dri="http://www.driver-repository.eu/namespace/dri" xmlns:oaa="http://namespace.openaire.eu/oaa"
                xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:dnet="eu.dnetlib.data.transform.xml.OafToHbaseXsltFunctions"
                xmlns:date="java.lang.System"
                xmlns:exslt="http://exslt.org/common"
                version="1.0"
                extension-element-prefixes="exslt"
                exclude-result-prefixes="xsl dc dr dri oaa oaf dnet exslt date">

    <xsl:output omit-xml-declaration="yes" indent="yes"/>

    <xsl:param name="invisible" select="false()"/>
    <xsl:param name="trust" select="string('0.9')"/>
    <xsl:param name="provenance" select="string('sysimport:crosswalk:repository')"/>

    <xsl:template match="/*">
        <xsl:variable name="about" select="/*[local-name() = 'record']/*[local-name() = 'about']"/>
        <xsl:variable name="dateofcollection" select="/*[local-name() = 'record']/*[local-name() = 'header']/*[local-name()='dateOfCollection' and text()][1]"/>
        <xsl:variable name="dateoftransformation" select="/*[local-name() = 'record']/*[local-name() = 'header']/*[local-name()='dateOfTransformation' and text()][1]"/>
        <xsl:variable name="metadata" select="exslt:node-set(/*[local-name() = 'record']/*[local-name()='metadata']/*)"/>
        <xsl:variable name="namespaceprefix">
            <xsl:choose>

                <!-- TODO check namespaceprefix length is 12 -->
                <xsl:when test="string-length(//oaf:datasourceprefix) &gt; 0">
                    <xsl:value-of select="//oaf:datasourceprefix"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="unknown_"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:choose>
            <!-- 			<xsl:when test="count($metadata) = 0 or string-length($namespaceprefix) = 0"> -->
            <xsl:when test="count($metadata) = 0">
                <ROWS/>
            </xsl:when>
            <xsl:otherwise>

                <xsl:variable name="objIdentifier" select="//dri:objIdentifier"/>
                <xsl:variable name="resultId" select="dnet:oafSimpleId('result', //dri:objIdentifier)"/>

                <xsl:if test="string-length($resultId) &gt; 0">

                    <xsl:variable name="cobjcategory" select="//dr:CobjCategory"/>
                    <xsl:choose>
                        <!-- check if we need to exclude datasets from an OAF MDStore-->
                        <xsl:when test="$cobjcategory = '0021'">
                            <ROWS/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:variable name="originalidTest" select="/*[local-name()='record']/*[local-name() = 'header']/*[local-name() = 'recordIdentifier']"/>
                            <xsl:variable name="originalid">
                                <xsl:choose>
                                    <xsl:when test="contains($originalidTest, '::')">
                                        <xsl:value-of select="substring-after($originalidTest, '::')"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of select="$originalidTest"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:variable>

                            <xsl:variable name="result"
                                          select="dnet:oafResult($resultId, $invisible, $provenance, $trust, $about, $originalid, $dateofcollection, $dateoftransformation, $metadata)"/>

                            <ROWS>
                                <ROW targetKey="{$resultId}" targetColumnFamily="result">
                                    <QUALIFIER name="{concat('update_', date:nanoTime())}" type="base64"><xsl:value-of select="$result"/></QUALIFIER>
                                </ROW>
                            </ROWS>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>
