/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.index;

import eu.dnetlib.data.index.CloudIndexClient;
import eu.dnetlib.data.index.CloudIndexClientException;
import eu.dnetlib.functionality.index.utils.ZkServers;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.response.SolrPingResponse;

public class CloudIndexClientFactory {
    private static final Log log = LogFactory.getLog(CloudIndexClientFactory.class);

    public static CloudIndexClient newIndexClient(String baseURL, String collection, boolean parallelUpdates) throws CloudIndexClientException {
        try {
            log.info((Object)String.format("Initializing solr server (%s) ...", baseURL));
            ZkServers zk = ZkServers.newInstance((String)baseURL);
            CloudSolrClient client = new CloudSolrClient.Builder(zk.getHosts(), zk.getChroot()).withParallelUpdates(parallelUpdates).build();
            client.connect();
            client.setDefaultCollection(collection);
            SolrPingResponse rsp = client.ping();
            if (rsp.getStatus() != 0) {
                log.error((Object)"Invalid connection to solr Server (status = 0)");
                throw new CloudIndexClientException("Invalid connection to solr Server (status = 0)");
            }
            return new CloudIndexClient(client);
        }
        catch (Throwable e) {
            log.error((Object)"The initialization of indexClient is FAILED", e);
            throw new CloudIndexClientException("The initialization of indexClient is FAILED", e);
        }
    }
}

