package eu.dnetlib.data.mapreduce.util;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

import com.google.protobuf.Descriptors.FieldDescriptor;
import com.google.protobuf.GeneratedMessage;
import eu.dnetlib.data.proto.OafProtos.OafEntity;
import eu.dnetlib.data.proto.TypeProtos.Type;
import eu.dnetlib.data.transform.AbstractProtoMapper;
import eu.dnetlib.pace.model.FieldDef;

public class OafEntityDecoder extends AbstractProtoMapper {

	private final OafEntity oafEntity;

	private OafEntityDecoder(final OafEntity oafEntity) {
		this.oafEntity = oafEntity;
	}

	public static OafEntityDecoder decode(final OafEntity oafEntity) {
		return new OafEntityDecoder(oafEntity);
	}

	public Type getType() {
		return oafEntity.getType();
	}

	public String getId() {
		return oafEntity.getId();
	}

	public GeneratedMessage getOafEntity() {
		return oafEntity;
	}

	public GeneratedMessage getEntity() {
		final FieldDescriptor fd = oafEntity.getDescriptorForType().findFieldByName(typeName());
		return (GeneratedMessage) oafEntity.getField(fd);
	}

	public String typeName() {
		return oafEntity.getType().toString();
	}

	public GeneratedMessage getMetadata() {
		final GeneratedMessage entity = getEntity();
		final FieldDescriptor fd = entity.getDescriptorForType().findFieldByName("metadata");
		final GeneratedMessage field = (GeneratedMessage) entity.getField(fd);
		return field;
	}

	public List<String> getFieldValues(final String path) {
		return processPath(getOafEntity(), path, eu.dnetlib.pace.config.Type.String).stream()
				.map(o -> o.toString())
				.collect(Collectors.toCollection(LinkedList::new));
	}


	public String getDateOfCollection() {
		return oafEntity.getDateofcollection();
	}

	public String getDateOfTransformation() {
		return oafEntity.getDateoftransformation();
	}
}
