package eu.dnetlib.data.transform;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.protobuf.Descriptors.Descriptor;
import com.google.protobuf.Descriptors.FieldDescriptor;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.proto.FieldTypeProtos.StructuredProperty;
import eu.dnetlib.data.proto.TypeProtos.Type;

public class OafUtils {

	private static Stream<String> types() {
		return Arrays.stream(Type.values())
				.map(Enum::toString);
	}

	public static Set<String> entities() {
		return types()
				.collect(Collectors.toSet());
	}

	public static Function<OafDecoder, String> idDecoder() {
		return input -> input.getEntityId();
	}

	public static Predicate<StructuredProperty> mainTitleFilter() {
		return sp -> (sp.getQualifier() != null) && sp.getQualifier().getClassname().equals("main title");
	}

	public static Set<String> getFieldNames(final Descriptor d, final Integer... tag) {
		return Sets.newHashSet(Iterables.transform(Arrays.asList(tag), i -> {
			final FieldDescriptor fd = d.findFieldByNumber(i);
			if (fd == null) throw new IllegalArgumentException("undefined tag: " + i + " for type: " + d.getFullName());
			return fd.getName();
		}));
	}

}
