/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform.xml2;

import com.google.common.collect.Maps;
import eu.dnetlib.data.transform.xml2.AbstractResultVtdParser;
import eu.dnetlib.data.transform.xml2.Utils;
import eu.dnetlib.data.transform.xml2.VtdUtilityParser;
import java.util.HashMap;
import java.util.Map;

public class DatasetToProto
extends AbstractResultVtdParser {
    public static DatasetToProto newInstance() {
        return new DatasetToProto();
    }

    public DatasetToProto() {
        super(DatasetToProto.getFields());
    }

    public DatasetToProto(boolean invisible, String provenance, String trust) {
        super(invisible, provenance, trust, DatasetToProto.getFields());
    }

    @Override
    protected String getResulttype(String cobjcategory) {
        switch (cobjcategory) {
            case "0029": {
                return "software";
            }
        }
        return "dataset";
    }

    private static Map<String, String> getFields() {
        HashMap fields = Maps.newHashMap();
        fields.put("originalId", "//*[local-name() = 'resource']/*[local-name()='identifier'] | //*[local-name()='resource']//*[local-name()='alternateIdentifier']");
        fields.put("collectedfrom", Utils.metadataXpath("collectedFrom"));
        fields.put("pid", "//*[local-name() = 'resource']/*[local-name()='identifier'] | //*[local-name()='resource']//*[local-name()='alternateIdentifier']");
        fields.put("dateofcollection", VtdUtilityParser.xpath("record", "header", "dateOfCollection"));
        fields.put("dateoftransformation", VtdUtilityParser.xpath("record", "header", "dateOfTransformation"));
        fields.put("license", Utils.metadataXpath("resource") + "//*[local-name()='rights']");
        fields.put("accessright", Utils.metadataXpath("accessrights"));
        fields.put("instancetype", Utils.metadataXpath("CobjCategory"));
        fields.put("hostedby", Utils.metadataXpath("hostedBy"));
        fields.put("url", "/*[local-name()='record']/*[local-name()='metadata']/*[local-name()='resource']/*[local-name()='identifier' and (./@identifierType='DOI' or ./@identifierType='URL' ) ] | /*[local-name()='record']/*[local-name()='metadata']/*[local-name()='resource']//*[local-name()='alternateIdentifier' and ./@alternateIdentifierType='URL']");
        fields.put("title", "//*[local-name() = 'title']");
        fields.put("description", VtdUtilityParser.xpath("record", "metadata", "resource", "descriptions", "description"));
        fields.put("storagedate", "//*[local-name() = 'date' and ./@dateType = 'Issued']");
        fields.put("lastmetadataupdate", "//*[local-name() = 'date' and ./@dateType = 'Updated']");
        fields.put("embargoenddate", "//*[local-name() = 'date' and ./@dateType = 'Available']");
        fields.put("dateofacceptance", Utils.metadataXpath("dateAccepted"));
        fields.put("author", VtdUtilityParser.xpath("record", "metadata", "resource", "creator", "creatorName"));
        fields.put("contributor", VtdUtilityParser.xpath("record", "metadata", "resource", "contributor", "contributorName"));
        fields.put("subject", VtdUtilityParser.xpath("record", "metadata", "resource", "subjects", "subject"));
        fields.put("format", VtdUtilityParser.xpath("record", "metadata", "resource", "formats", "format"));
        fields.put("size", VtdUtilityParser.xpath("record", "metadata", "resource", "sizes", "size"));
        fields.put("version", VtdUtilityParser.xpath("record", "metadata", "resource", "versions", "version"));
        fields.put("publisher", VtdUtilityParser.xpath("record", "metadata", "resource", "publisher"));
        fields.put("language", VtdUtilityParser.xpath("record", "metadata", "language"));
        fields.put("resourcetype", VtdUtilityParser.xpath("record", "metadata", "resource", "resourceType"));
        fields.put("resulttype", VtdUtilityParser.xpath("record", "metadata", "CobjCategory"));
        fields.put("cachedRel", String.format("%s | %s | %s | %s", Utils.metadataXpath("projectid"), Utils.metadataXpath("relatedPublication"), Utils.metadataXpath("relatedDataSet"), Utils.metadataXpath("resource") + "//*[local-name()='relatedIdentifier']"));
        return fields;
    }
}

