/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.hadoop.utils;

import com.google.common.collect.Sets;
import eu.dnetlib.data.proto.DatasourceOrganizationProtos;
import eu.dnetlib.data.proto.DedupProtos;
import eu.dnetlib.data.proto.DedupSimilarityProtos;
import eu.dnetlib.data.proto.ProjectOrganizationProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.ResultOrganizationProtos;
import eu.dnetlib.data.proto.ResultProjectProtos;
import eu.dnetlib.data.proto.ResultResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HBaseTableUtils {
    private static final String SEPARATOR = "_";

    public static Set<String> listAllColumns() {
        Sets.SetView union = Sets.union(HBaseTableUtils.listEntities(), HBaseTableUtils.listRelationships());
        return Sets.union((Set)union, HBaseTableUtils.listDedupRelationships());
    }

    private static Set<String> listDedupRelationships() {
        HashSet cfs = Sets.newHashSet();
        cfs.add(RelTypeProtos.RelType.organizationOrganization + SEPARATOR + RelTypeProtos.SubRelType.dedup + SEPARATOR + DedupProtos.Dedup.RelName.merges);
        cfs.add(RelTypeProtos.RelType.organizationOrganization + SEPARATOR + RelTypeProtos.SubRelType.dedup + SEPARATOR + DedupProtos.Dedup.RelName.isMergedIn);
        cfs.add(RelTypeProtos.RelType.organizationOrganization + SEPARATOR + RelTypeProtos.SubRelType.dedupSimilarity + SEPARATOR + DedupSimilarityProtos.DedupSimilarity.RelName.isSimilarTo);
        cfs.add(RelTypeProtos.RelType.resultResult + SEPARATOR + RelTypeProtos.SubRelType.dedup + SEPARATOR + DedupProtos.Dedup.RelName.merges);
        cfs.add(RelTypeProtos.RelType.resultResult + SEPARATOR + RelTypeProtos.SubRelType.dedup + SEPARATOR + DedupProtos.Dedup.RelName.isMergedIn);
        cfs.add(RelTypeProtos.RelType.resultResult + SEPARATOR + RelTypeProtos.SubRelType.dedupSimilarity + SEPARATOR + DedupSimilarityProtos.DedupSimilarity.RelName.isSimilarTo);
        return cfs;
    }

    private static Stream<String> types() {
        return Arrays.stream(TypeProtos.Type.values()).map(Enum::toString);
    }

    public static Set<String> listEntities() {
        return HBaseTableUtils.types().collect(Collectors.toSet());
    }

    public static Set<String> listRelationships() {
        HashSet cfs = Sets.newHashSet();
        cfs.add(RelTypeProtos.RelType.datasourceOrganization + SEPARATOR + RelTypeProtos.SubRelType.provision + SEPARATOR + DatasourceOrganizationProtos.DatasourceOrganization.Provision.RelName.isProvidedBy);
        cfs.add(RelTypeProtos.RelType.datasourceOrganization + SEPARATOR + RelTypeProtos.SubRelType.provision + SEPARATOR + DatasourceOrganizationProtos.DatasourceOrganization.Provision.RelName.provides);
        cfs.add(RelTypeProtos.RelType.projectOrganization + SEPARATOR + RelTypeProtos.SubRelType.participation + SEPARATOR + ProjectOrganizationProtos.ProjectOrganization.Participation.RelName.hasParticipant);
        cfs.add(RelTypeProtos.RelType.projectOrganization + SEPARATOR + RelTypeProtos.SubRelType.participation + SEPARATOR + ProjectOrganizationProtos.ProjectOrganization.Participation.RelName.isParticipant);
        cfs.add(RelTypeProtos.RelType.resultProject + SEPARATOR + RelTypeProtos.SubRelType.outcome + SEPARATOR + ResultProjectProtos.ResultProject.Outcome.RelName.isProducedBy);
        cfs.add(RelTypeProtos.RelType.resultProject + SEPARATOR + RelTypeProtos.SubRelType.outcome + SEPARATOR + ResultProjectProtos.ResultProject.Outcome.RelName.produces);
        cfs.add(RelTypeProtos.RelType.resultResult + SEPARATOR + RelTypeProtos.SubRelType.similarity + SEPARATOR + ResultResultProtos.ResultResult.Similarity.RelName.hasAmongTopNSimilarDocuments);
        cfs.add(RelTypeProtos.RelType.resultResult + SEPARATOR + RelTypeProtos.SubRelType.similarity + SEPARATOR + ResultResultProtos.ResultResult.Similarity.RelName.isAmongTopNSimilarDocuments);
        cfs.add(RelTypeProtos.RelType.resultResult + SEPARATOR + RelTypeProtos.SubRelType.supplement + SEPARATOR + ResultResultProtos.ResultResult.Supplement.RelName.isSupplementedBy);
        cfs.add(RelTypeProtos.RelType.resultResult + SEPARATOR + RelTypeProtos.SubRelType.supplement + SEPARATOR + ResultResultProtos.ResultResult.Supplement.RelName.isSupplementTo);
        cfs.add(RelTypeProtos.RelType.resultResult + SEPARATOR + RelTypeProtos.SubRelType.part + SEPARATOR + ResultResultProtos.ResultResult.Part.RelName.isPartOf);
        cfs.add(RelTypeProtos.RelType.resultResult + SEPARATOR + RelTypeProtos.SubRelType.part + SEPARATOR + ResultResultProtos.ResultResult.Part.RelName.hasPart);
        cfs.add(RelTypeProtos.RelType.resultResult + SEPARATOR + RelTypeProtos.SubRelType.publicationDataset + SEPARATOR + ResultResultProtos.ResultResult.PublicationDataset.RelName.isRelatedTo);
        cfs.add(RelTypeProtos.RelType.resultOrganization + SEPARATOR + RelTypeProtos.SubRelType.affiliation + SEPARATOR + ResultOrganizationProtos.ResultOrganization.Affiliation.RelName.isAuthorInstitutionOf);
        cfs.add(RelTypeProtos.RelType.resultOrganization + SEPARATOR + RelTypeProtos.SubRelType.affiliation + SEPARATOR + ResultOrganizationProtos.ResultOrganization.Affiliation.RelName.hasAuthorInstitution);
        cfs.add(RelTypeProtos.RelType.resultResult + SEPARATOR + RelTypeProtos.SubRelType.version + SEPARATOR + ResultResultProtos.ResultResult.SoftwareSoftware.RelName.isVersionOf);
        cfs.add(RelTypeProtos.RelType.resultResult + SEPARATOR + RelTypeProtos.SubRelType.relationship + SEPARATOR + ResultResultProtos.ResultResult.Relationship.RelName.isRelatedTo);
        return cfs;
    }
}

