<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:oaf="http://namespace.openaire.eu/oaf"
                xmlns:dnet="eu.dnetlib.data.transform.xml.OdfToHbaseXsltFunctions"
                xmlns:dri="http://www.driver-repository.eu/namespace/dri"
                xmlns:dr="http://www.driver-repository.eu/namespace/dr" xmlns:exslt="http://exslt.org/common"
                version="1.0" extension-element-prefixes="exslt"
                exclude-result-prefixes="xsl oaf dr dri dnet exslt">

	<xsl:output omit-xml-declaration="yes" indent="yes"/>

	<xsl:param name="invisible" select="false()"/>
	<xsl:param name="trust" select="string('0.9')"/>
	<xsl:param name="provenance" select="string('sysimport:crosswalk:datasetarchive')"/>
	<xsl:template match="/*">
		<xsl:variable name="about" select="/*[local-name() = 'record']/*[local-name() = 'about']"/>
		<xsl:variable name="dateOfCollection" select="concat('', //dri:dateOfCollection)"/>
		<xsl:variable name="dateoftransformation" select="concat('', //dr:dateOfTransformation)"/>
		<xsl:variable name="metadata" select="exslt:node-set(//*[local-name()='metadata']/*)"/>
		<xsl:variable name="namespaceprefix">
			<xsl:choose>
				<!-- TODO check namespaceprefix length is 12 -->
				<xsl:when test="string-length(//oaf:datasourceprefix) &gt; 0">
					<xsl:value-of select="//oaf:datasourceprefix"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="unknown_____"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:choose>
			<xsl:when
					test="count($metadata) = 0 or normalize-space(//oaf:skipRecord)= 'true'">
				<ROWS/>
			</xsl:when>
			<xsl:otherwise>

				<xsl:variable name="resultId"
				              select="dnet:oafSimpleId('result', //dri:objIdentifier)"/>

				<xsl:if test="string-length($resultId) &gt; 0">
					<xsl:variable name="originalids"
					              select="//*[local-name() = 'resource']/*[local-name()='identifier'] | //*[local-name() = 'resource']//*[local-name()='alternateIdentifier']"/>
					<xsl:variable name="creators" select="//*[local-name() = 'creators']/*[local-name() = 'creator']"/>
					<xsl:variable name="titles" select="//*[local-name() = 'title']"/>
					<xsl:variable name="subjects" select="//*[local-name() = 'subject']"/>
					<xsl:variable name="publisher" select="//*[local-name() = 'publisher']"/>
					<xsl:variable name="descriptions" select="//*[local-name() = 'description']"/>
					<xsl:variable name="dates" select="//*[local-name() = 'date']"/>
					<xsl:variable name="dateaccepted" select="//oaf:dateAccepted"/>
					<xsl:variable name="resourceType" select="//*[local-name() = 'resourceType']"/>
					<xsl:variable name="formats" select="//*[local-name() = 'format']"/>
					<xsl:variable name="sizes" select="//*[local-name() = 'size']"/>
					<xsl:variable name="rights" select="//oaf:accessrights"/>
					<xsl:variable name="license" select="//oaf:license"/>
					<xsl:variable name="version" select="//*[local-name() = 'version']"/>
					<xsl:variable name="language" select="//oaf:language"/>
					<xsl:variable name="cobjcategory" select="//dr:CobjCategory"/>
					<xsl:variable name="contributor" select="//*[local-name() = 'contributor']"/>
					<xsl:variable name="distributionlocation" select="//*[local-name() = 'alternateIdentifier' and @alternateIdentifierType='DistributionLocation']"/>
					<xsl:variable name="documentationUrl" select="//*[local-name() = 'relatedIdentifier' and @relatedIdentifierType='URL' and @relationType='IsDocumentedBy']"/>
					<xsl:variable name="landingPage" select="//*[local-name() = 'alternateIdentifier' and @alternateIdentifierType='LandingPage']/text()"/>

					<xsl:variable name="instanceURI">
						<xsl:choose>
							<xsl:when
									test="string-length( //*[local-name() = 'resource']/*[local-name()='identifier' and ./@identifierType='DOI']) &gt; 0">
								<xsl:value-of
										select="concat('http://dx.doi.org','/', //*[local-name() = 'resource']/*[local-name()='identifier' and ./@identifierType='DOI']/text())"/>
							</xsl:when>
							<xsl:when test="string-length( //*[local-name() = 'resource']/*[local-name()='identifier' and ./@identifierType='URL']) &gt; 0">
								<xsl:value-of select="concat('', //*[local-name() = 'resource']/*[local-name()='identifier' and ./@identifierType='URL'])"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="concat('', //*[local-name() = 'resource']//*[local-name()='alternateIdentifier' and ./@alternateIdentifierType='URL'])"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>

					<xsl:variable name="hostedby" select="//oaf:hostedBy"/>
					<xsl:variable name="collectedfrom" select="//oaf:collectedFrom"/>

					<xsl:variable name="pids"
					              select="//*[local-name() = 'resource']//*[local-name()='identifier'or local-name()='alternateIdentifier']"/>

					<xsl:variable name="result"
					              select="dnet:odfResult($resultId, $invisible, $about, $metadata, $titles, $creators, $subjects, $publisher, $descriptions,
		                        $dates, $dateaccepted, $resourceType, $formats, $sizes, $language, $cobjcategory, $contributor, $rights, $license,
		                        $version, $pids, $provenance, $trust, $hostedby, $collectedfrom, $originalids, $instanceURI, $landingPage, $distributionlocation,
		                        $documentationUrl, $dateOfCollection, $dateoftransformation)"/>

					<ROWS>
						<ROW key="{$resultId}" columnFamily="result">
							<QUALIFIER name="body" type="base64">
								<xsl:value-of select="$result"/>
							</QUALIFIER>
						</ROW>

						<xsl:for-each select="//*[local-name()='projectid']">

							<xsl:variable name="projectId"
							              select="dnet:oafSplitId('project', normalize-space(.))"/>

							<xsl:variable name="resultproject"
							              select="dnet:rel($resultId, $projectId, 'resultProject', 'outcome', 'isProducedBy',
		                              $collectedfrom, $provenance, $trust, $about)"/>
							<xsl:variable name="projectresult"
							              select="dnet:rel($projectId, $resultId, 'resultProject', 'outcome', 'produces',
		                              $collectedfrom, $provenance, $trust, $about)"/>

							<xsl:if test="string-length($projectId) &gt; 0">
								<ROW key="{$resultId}" columnFamily="resultProject_outcome_isProducedBy">
									<QUALIFIER name="{$projectId}" type="base64">
										<xsl:value-of select="$resultproject"/>
									</QUALIFIER>
								</ROW>
								<ROW key="{$projectId}" columnFamily="resultProject_outcome_produces">
									<QUALIFIER name="{$resultId}" type="base64">
										<xsl:value-of select="$projectresult"/>
									</QUALIFIER>
								</ROW>
							</xsl:if>
						</xsl:for-each>

						<xsl:for-each
								select="//*[local-name()='relatedIdentifier' and ./@relatedIdentifierType='OPENAIRE' and ./@relationType='IsSupplementTo']">

							<!-- relatedDataset ids must be in the openaire format  -->
							<xsl:variable name="targetId" select="dnet:oafSimpleId('result', normalize-space(.))"/>

							<xsl:if test="string-length($targetId) &gt; 0">

								<xsl:variable name="resultDataset"
								              select="dnet:rel($resultId, $targetId, 'resultResult', 'supplement', 'isSupplementTo',
			                              $collectedfrom, $provenance, $trust, $about)"/>
								<xsl:variable name="datasetResult"
								              select="dnet:rel($targetId, $resultId, 'resultResult', 'supplement', 'isSupplementedBy',
			                              $collectedfrom, $provenance, $trust, $about)"/>

								<ROW key="{$resultId}" columnFamily="resultResult_supplement_isSupplementTo">
									<QUALIFIER name="{$targetId}" type="base64">
										<xsl:value-of select="$resultDataset"/>
									</QUALIFIER>
								</ROW>
								<ROW key="{$targetId}" columnFamily="resultResult_supplement_isSupplementedBy">
									<QUALIFIER name="{$resultId}" type="base64">
										<xsl:value-of select="$datasetResult"/>
									</QUALIFIER>
								</ROW>
							</xsl:if>
						</xsl:for-each>

						<xsl:for-each
								select="//*[local-name()='relatedIdentifier' and ./@relatedIdentifierType='OPENAIRE' and ./@relationType='IsPartOf']">

							<!-- relatedDataset ids must be in the openaire format  -->
							<xsl:variable name="datasetId" select="dnet:oafSimpleId('result', normalize-space(.))"/>

							<xsl:if test="string-length($datasetId) &gt; 0">

								<xsl:variable name="childParent"
								              select="dnet:rel($resultId, $datasetId, 'resultResult', 'part', 'isPartOf',
			                              $collectedfrom, $provenance, $trust, $about)"/>
								<xsl:variable name="parentChild"
								              select="dnet:rel($datasetId, $resultId, 'resultResult', 'part', 'hasPart',
			                              $collectedfrom, $provenance, $trust, $about)"/>

								<ROW key="{$resultId}" columnFamily="resultResult_part_isPartOf">
									<QUALIFIER name="{$datasetId}" type="base64">
										<xsl:value-of select="$childParent"/>
									</QUALIFIER>
								</ROW>
								<ROW key="{$datasetId}" columnFamily="resultResult_part_hasPart">
									<QUALIFIER name="{$resultId}" type="base64">
										<xsl:value-of select="$parentChild"/>
									</QUALIFIER>
								</ROW>
							</xsl:if>
						</xsl:for-each>

					</ROWS>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
