package eu.dnetlib.data.bulktag;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import eu.dnetlib.data.bulktag.selectioncriteria.VerbResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * Created by miriam on 02/08/2018.
 */
public class Constraints implements Serializable {
    private static final Log log = LogFactory.getLog(Constraints.class);
    private List<Constraint> sc;


    public Constraints() {
    }

    public List<Constraint> getSc() {
        return sc;
    }

    public void setSc(List<Constraint> sc) {
        this.sc = sc;
    }

    public void setSc(String json){
        Type collectionType = new TypeToken<Collection<Constraint>>(){}.getType();
        sc = new Gson().fromJson(json, collectionType);

    }

    void setSelection(VerbResolver resolver) {
        for(Constraint st: sc){

            try {
                st.setSelection(resolver);
            } catch (NoSuchMethodException e) {
                log.error(e.getMessage());
            } catch (IllegalAccessException e) {
                log.error(e.getMessage());
            } catch (InvocationTargetException e) {
                log.error(e.getMessage());
            } catch (InstantiationException e) {
                log.error(e.getMessage());
            }
        }

    }

//    //Constraint in and
//    public boolean verifyCriteria(Map<String,String> param){
//        for(Constraint sc: sc){
//            if(!sc.verifyCriteria(param.get(sc.getField())))
//                return false;
//        }
//        return true;
//    }

    //Constraint in and
    public boolean verifyCriteria(Map<String,List<String>> param){

        for(Constraint sc: sc){
            boolean verified = false;
            for(String value : param.get(sc.getField())){
                if (sc.verifyCriteria(value)){
                    verified = true;
                }
            }
            if(!verified)
                return verified;
        }
        return true;
    }
}