package eu.dnetlib.data.bulktag;

import eu.dnetlib.data.bulktag.selectioncriteria.Selection;
import eu.dnetlib.data.bulktag.selectioncriteria.VerbResolver;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;


public class Constraint implements Serializable {
    private String verb;
    private String field;
    private String value;
    private Selection selection;

//    @Autowired
//    private VerbResolver resolver;

    public Constraint() {
    }

    public String getVerb() {
        return verb;
    }

    public void setVerb(String verb) {
        this.verb = verb;
    }

    public String getField() {
        return field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }



    public void setSelection(Selection sel){
        selection = sel;
    }

    public void setSelection(VerbResolver resolver) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        selection = resolver.getSelectionCriteria(verb,value);
    }


    public boolean verifyCriteria(String metadata){
        return selection.apply(metadata);
    }

   /* public boolean verifyCriteria(String metadata) throws InvocationTargetException, IllegalAccessException {
        Method method;
        boolean ret = false;
        if(verb.contains("equal")){
            method = getStringMethod(metadata,verb);
        }else{
            method = getCharSequenceMethod(metadata,verb);
        }
        if (method == null)
            return false;
        ret = (boolean)method.invoke(metadata,value);
        if(verb.startsWith("not_"))
            return !ret;
        return ret;
    }

    private Method getCharSequenceMethod(String metadata, String verb) {
        try{
            if(verb.startsWith("not_")) {
                return metadata.getClass().getMethod(verb.substring(4), CharSequence.class);
            }
            else{
                return metadata.getClass().getMethod(verb, CharSequence.class);
            }

        }catch(NoSuchMethodException nsme){

        }

        return null;
    }

    private Method getStringMethod(String metadata, String verb) {
        try{
            if(verb.startsWith("not_")) {
                return metadata.getClass().getMethod(verb.substring(4), String.class);
            }
            else{
                return metadata.getClass().getMethod(verb, String.class);
            }

        }catch(NoSuchMethodException nsme){

        }
        return null;
    }*/

}