package eu.dnetlib.data.transform.xml2;

import java.io.StringReader;
import java.util.*;

import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class Dom4jUtilityParser {

	public static final String NS_SEPARATOR = ":";

	public static String xpath(final String ... p) {
		return Arrays.stream(p)
				.map(s -> String.format("/*[local-name()='%s']", s))
				.reduce((s1, s2) -> s1 + s2)
				.get();
	}

	public static Document parseXml(final String xml) throws DocumentException {
		return new SAXReader().read(new StringReader(xml));
	}

	public static int countNodes(final Document document, final String xpath) throws VtdException {
		if (StringUtils.isBlank(xpath)) {
			return 0;
		}
		List res = document.selectNodes(xpath);
		return res != null ? res.size() : 0;
	}

	public static Node getNode(final Document document, final String xpath) throws VtdException {
		if (StringUtils.isBlank(xpath)) {
			return new Node();
		}

		return asNode(document.selectSingleNode(xpath));
	}

	public static List<Node> getNodes(final Document document, final String xpath) throws VtdException {
		final List<Node> results = new ArrayList<>();
		if (StringUtils.isBlank(xpath)) {
			return results;
		}

		for(final Object o : document.selectNodes(xpath)) {
			results.add(asNode((org.dom4j.Node) o));
		}

		return results;
	}

	private static Node asNode(final org.dom4j.Node dNode) {
		final Node currentNode = new Node();
		if (dNode == null) return currentNode;
		final String name = dNode.getName();
		currentNode.setName(name.contains(NS_SEPARATOR) ? StringUtils.substringAfter(name, NS_SEPARATOR) : name);
		currentNode.setTextValue(dNode.getText());
		currentNode.setAttributes(getAttributes(dNode));

		return currentNode;
	}

	private static Map<String, String> getAttributes(final org.dom4j.Node dNode) {
		final Map<String, String> attributes = new HashMap<>();

		if (dNode instanceof Element) {
			Iterator<Attribute> it = ((Element) dNode).attributeIterator();
			while(it.hasNext()) {
				final Attribute a = it.next();
				attributes.put(a.getName(), a.getValue());
			}
		}
		return attributes;
	}

	public static String getFirstValue(final Document document, final String xpath) throws VtdException {
		if (StringUtils.isBlank(xpath)) {
			return null;
		}

		return document.valueOf(xpath);
	}

}
