package eu.dnetlib.data.bulktag;

import com.google.gson.Gson;
import eu.dnetlib.data.bulktag.selectioncriteria.VerbResolver;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class SelectionConstraints implements Serializable {
    private ConstraintsList cl;

   // private List<Constraints>cl;


    public SelectionConstraints() {
    }

    public ConstraintsList getCl() {
        return cl;
    }

    public void setCl(ConstraintsList cl) {
        this.cl = cl;
    }

    public void setSc(String json){

        cl = new Gson().fromJson(json, ConstraintsList.class);
    }


    public boolean verifyCriteria(Map<String,List<String>> param){
        for(Constraints selc: cl.getCriteria()){
            if(selc.verifyCriteria(param)){
                return true;
            }
        }
        return false;
    }
    public void setSelection(VerbResolver resolver) {

        for(Constraints cs : cl.getCriteria()){
            cs.setSelection(resolver);
        }
    }
}