/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform;

import com.google.common.collect.Lists;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.mapreduce.util.OafEntityDecoder;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.transform.Column;
import eu.dnetlib.data.transform.Row;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class OafToRowMapper
implements Function<OafProtos.Oaf, List<Row>> {
    public static final String BODY = "body";

    @Override
    public List<Row> apply(OafProtos.Oaf oaf) {
        ArrayList rows = Lists.newArrayList();
        OafDecoder d = OafDecoder.decode(oaf);
        OafEntityDecoder entity = d.decodeEntity();
        Row r = new Row(d.getCFQ(), entity.getId());
        switch (entity.getType()) {
            case project: {
                r.addColumn(new Column((Object)BODY, (Object)oaf.toByteArray()));
                break;
            }
            case result: {
                oaf.getEntity().getCachedOafRelList().stream().map(cachedRel -> {
                    OafProtos.Oaf.Builder oafRel = OafProtos.Oaf.newBuilder((OafProtos.Oaf)cachedRel);
                    oafRel.getRelBuilder().clearCachedOafTarget();
                    return oafRel.build();
                }).forEach(oafRel -> r.addColumn(new Column((Object)OafDecoder.decode(oafRel).getCFQ(), (Object)oafRel.toByteArray())));
                break;
            }
            case datasource: {
                break;
            }
        }
        return rows;
    }
}

