package eu.dnetlib.data.transform;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;

import eu.dnetlib.data.proto.OafProtos.Oaf;
import eu.dnetlib.data.proto.SpecialTrustProtos.SpecialTrust;
import org.apache.commons.lang3.StringUtils;

public class TrustOrdering extends Ordering<Oaf> {

	@Override
	public int compare(Oaf left, Oaf right) {
		String lTrust = left.getDataInfo().getTrust();
		String rTrust = right.getDataInfo().getTrust();

		if (lTrust.equals(rTrust)) return 0;

		if (lTrust.equals(SpecialTrust.INFINITE.toString())) return 1;
		if (rTrust.equals(SpecialTrust.INFINITE.toString())) return -1;

		if (lTrust.equals(SpecialTrust.NEUTRAL.toString())) return 1;
		if (rTrust.equals(SpecialTrust.NEUTRAL.toString())) return -1;

		return Float.compare(
				Float.parseFloat(StringUtils.isBlank(lTrust) ? "0.9" : lTrust),
				Float.parseFloat(StringUtils.isBlank(rTrust) ? "0.9" : rTrust));
	}

	public static ImmutableList<Oaf> sort(Iterable<Oaf> entities) {
		return new TrustOrdering().immutableSortedCopy(entities);
	}

}
