package eu.dnetlib.data.index;

import eu.dnetlib.functionality.index.utils.ZkServers;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.response.SolrPingResponse;

/**
 * Created by michele on 11/11/15.
 */
public class CloudIndexClientFactory {

	private static final Log log = LogFactory.getLog(CloudIndexClientFactory.class);

	public static CloudIndexClient newIndexClient(final String baseURL, final String collection, final boolean parallelUpdates)
			throws CloudIndexClientException {
		try {
			log.info(String.format("Initializing solr server (%s) ...", baseURL));

			final ZkServers zk = ZkServers.newInstance(baseURL);
			final CloudSolrClient client = new CloudSolrClient.Builder(zk.getHosts(), zk.getChroot())
					.withParallelUpdates(parallelUpdates)
					.build();

			client.connect();
			client.setDefaultCollection(collection);

			final SolrPingResponse rsp = client.ping();
			if (rsp.getStatus() != 0) {
				log.error("Invalid connection to solr Server (status = 0)");
				throw new CloudIndexClientException("Invalid connection to solr Server (status = 0)");
			}
			return new CloudIndexClient(client);
		} catch (Throwable e) {
			log.error("The initialization of indexClient is FAILED", e);
			throw new CloudIndexClientException("The initialization of indexClient is FAILED", e);
		}
	}

}
