/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform.xml2;

import com.google.common.collect.Streams;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.AbstractDNetXsltFunctions;
import eu.dnetlib.data.transform.xml2.Dom4jUtilityParser;
import eu.dnetlib.data.transform.xml2.Node;
import eu.dnetlib.data.transform.xml2.SpecificationDescriptor;
import eu.dnetlib.data.transform.xml2.SpecificationMap;
import eu.dnetlib.data.transform.xml2.Utils;
import eu.dnetlib.data.transform.xml2.VtdException;
import eu.dnetlib.miscutils.collections.Pair;
import eu.dnetlib.pace.model.Person;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;

public abstract class AbstractResultDom4jParser
implements Function<String, OafProtos.Oaf> {
    private static final Log log = LogFactory.getLog(AbstractResultDom4jParser.class);
    protected boolean invisible = false;
    protected String provenance = "";
    protected String trust = "0.9";
    protected SpecificationMap specs;

    public AbstractResultDom4jParser(Map<String, String> fields) {
        this.specs = this.buildSpecs(fields);
    }

    public AbstractResultDom4jParser(boolean invisible, String provenance, String trust, Map<String, String> fields) {
        this(fields);
        this.invisible = invisible;
        this.provenance = provenance;
        this.trust = trust;
    }

    protected abstract String getResulttype(String var1);

    @Override
    public OafProtos.Oaf apply(String xml) {
        try {
            Document document = Dom4jUtilityParser.parseXml(xml);
            boolean skiprecord = Boolean.valueOf(Dom4jUtilityParser.getFirstValue(document, Dom4jUtilityParser.xpath("record", "header", "skipRecord")));
            int metadata = Dom4jUtilityParser.countNodes(document, String.format("count(%s)", Dom4jUtilityParser.xpath("record", "metadata")));
            if (metadata == 0 || skiprecord) {
                return null;
            }
            String objIdentifier = AbstractDNetXsltFunctions.oafSimpleId(TypeProtos.Type.result.name(), Dom4jUtilityParser.getFirstValue(document, Dom4jUtilityParser.xpath("record", "header", "objIdentifier")));
            if (StringUtils.isBlank((CharSequence)objIdentifier)) {
                return null;
            }
            for (Map.Entry spec : this.specs.entrySet()) {
                Descriptors.Descriptor d = (Descriptors.Descriptor)spec.getKey();
                SpecificationDescriptor md = (SpecificationDescriptor)spec.getValue();
                for (Map.Entry<String, Pair<String, Function<List<Node>, Object>>> entry : md.getFields().entrySet()) {
                    String fieldName = entry.getKey();
                    Pair<String, Function<List<Node>, Object>> pair = entry.getValue();
                    String xpath = (String)pair.getKey();
                    Function function = (Function)pair.getValue();
                    try {
                        Utils.addField(md.getBuilder(), d.findFieldByName(fieldName), function.apply(Dom4jUtilityParser.getNodes(document, xpath)));
                    }
                    catch (Throwable e) {
                        throw new VtdException(String.format("Error mapping field '%s' from xpath '%s' for record '%s'", fieldName, xpath, objIdentifier), e);
                    }
                }
            }
            return OafProtos.Oaf.newBuilder().setKind(KindProtos.Kind.entity).setDataInfo(this.ensureDataInfo(document, FieldTypeProtos.DataInfo.newBuilder())).setEntity(((OafProtos.OafEntity.Builder)((SpecificationDescriptor)this.specs.get(OafProtos.OafEntity.getDescriptor())).getBuilder().setField(OafProtos.OafEntity.getDescriptor().findFieldByName(TypeProtos.Type.result.name()), (Object)((ResultProtos.Result.Builder)((SpecificationDescriptor)this.specs.get(ResultProtos.Result.getDescriptor())).getBuilder()).setMetadata((ResultProtos.Result.Metadata)((SpecificationDescriptor)this.specs.get(ResultProtos.Result.Metadata.getDescriptor())).getBuilder().build()).addInstance((ResultProtos.Result.Instance)((SpecificationDescriptor)this.specs.get(ResultProtos.Result.Instance.getDescriptor())).getBuilder().build()).build())).setId(objIdentifier).setOaiprovenance(this.getOaiProvenance(document)).build()).build();
        }
        catch (Throwable e) {
            log.error((Object)xml);
            log.error((Object)ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public SpecificationMap buildSpecs(Map<String, String> fields) {
        SpecificationMap specs = new SpecificationMap();
        specs.put(ResultProtos.Result.getDescriptor(), SpecificationDescriptor.newInstance()).setBuilder((Message.Builder)ResultProtos.Result.newBuilder()).put("externalReference", fields.get("externalReference"), nodes -> nodes.stream().map(node -> {
            String type;
            String query;
            String title;
            String identifier;
            Map<String, String> a;
            String source;
            ResultProtos.Result.ExternalReference.Builder extref = ResultProtos.Result.ExternalReference.newBuilder();
            if (StringUtils.isNotBlank((CharSequence)node.getTextValue())) {
                extref.setUrl(node.getTextValue());
            }
            if (StringUtils.isNotBlank((CharSequence)(source = (a = node.getAttributes()).get("source")))) {
                extref.setSitename(source);
            }
            if (StringUtils.isNotBlank((CharSequence)(identifier = a.get("identifier")))) {
                extref.setRefidentifier(identifier);
            }
            if (StringUtils.isNotBlank((CharSequence)(title = a.get("title")))) {
                extref.setLabel(title);
            }
            if (StringUtils.isNotBlank((CharSequence)(query = a.get("query")))) {
                extref.setQuery(query);
            }
            if (StringUtils.isNotBlank((CharSequence)(type = a.get("type")))) {
                extref.setQualifier(Utils.getSimpleQualifier(type, "dnet:externalReference_typologies"));
            }
            return extref.build();
        }));
        specs.put(ResultProtos.Result.Instance.getDescriptor(), SpecificationDescriptor.newInstance()).setBuilder((Message.Builder)ResultProtos.Result.Instance.newBuilder()).put("license", fields.get("license"), nodes -> nodes.stream().filter(node -> {
            Map<String, String> a = node.getAttributes();
            switch (node.getName()) {
                case "rights": {
                    return a.containsKey("rightsURI") && a.get("rightsURI").matches("^(http|https|ftp)\\://.*");
                }
                case "license": {
                    return true;
                }
            }
            return false;
        }).map(Node::getTextValue)).put("accessright", fields.get("accessright"), nodes -> nodes.stream().map(Node::getTextValue).map(rights -> Utils.mappingAccess.containsKey(rights) ? Utils.mappingAccess.get(rights) : "UNKNOWN").map(code -> Utils.getQualifier(code, Utils.getClassName(code), "dnet:access_modes", "dnet:access_modes"))).put("instancetype", fields.get("instancetype"), nodes -> nodes.stream().map(Node::getTextValue).map(code -> Utils.getQualifier(code, Utils.getClassName(code), "dnet:publication_resource", "dnet:publication_resource"))).put("hostedby", fields.get("hostedby"), nodes -> nodes.stream().map(node -> Utils.getKV(AbstractDNetXsltFunctions.oafSplitId("datasource", node.getAttributes().get("id")), node.getAttributes().get("name")))).put("url", fields.get("url"), nodes -> nodes.stream().map(Node::getTextValue).filter(s -> s.trim().matches("^(http|https|ftp)\\://.*"))).put("dateofacceptance", fields.get("dateofacceptance"), nodes -> nodes.stream().map(Node::getTextValue));
        specs.put(ResultProtos.Result.Metadata.getDescriptor(), SpecificationDescriptor.newInstance()).setBuilder((Message.Builder)ResultProtos.Result.Metadata.newBuilder()).put("title", fields.get("title"), nodes -> nodes.stream().map(node -> {
            FieldTypeProtos.Qualifier.Builder q = FieldTypeProtos.Qualifier.newBuilder().setSchemeid("dnet:dataCite_title").setSchemename("dnet:dataCite_title");
            switch (node.getAttributes().get("titleType") + "") {
                case "AlternativeTitle": {
                    q.setClassid("alternative title").setClassname("alternative title");
                    break;
                }
                case "Subtitle": {
                    q.setClassid("subtitle").setClassname("subtitle");
                    break;
                }
                case "TranslatedTitle": {
                    q.setClassid("translated title").setClassname("translated title");
                    break;
                }
                default: {
                    q.setClassid("main title").setClassname("main title");
                }
            }
            return FieldTypeProtos.StructuredProperty.newBuilder().setValue(node.getTextValue()).setQualifier(q).build();
        })).put("description", fields.get("description"), nodes -> nodes.stream().map(Node::getTextValue)).put("storagedate", fields.get("storagedate"), nodes -> nodes.stream().map(Node::getTextValue)).put("lastmetadataupdate", fields.get("lastmetadataupdate"), nodes -> nodes.stream().map(Node::getTextValue)).put("embargoenddate", fields.get("embargoenddate"), nodes -> nodes.stream().map(Node::getTextValue)).put("dateofacceptance", fields.get("dateofacceptance"), nodes -> nodes.stream().map(Node::getTextValue)).put("author", fields.get("author"), nodes -> Streams.mapWithIndex(nodes.stream().map(Node::getTextValue), (creator, i) -> new Pair((Object)i, creator)).map(pair -> {
            FieldTypeProtos.Author.Builder author = FieldTypeProtos.Author.newBuilder();
            author.setFullname((String)pair.getValue());
            author.setRank(((Long)pair.getKey()).intValue() + 1);
            Person p = new Person((String)pair.getValue(), false);
            if (p.isAccurate()) {
                author.setName(p.getNormalisedFirstName());
                author.setSurname(p.getNormalisedSurname());
            }
            return author.build();
        })).put("contributor", fields.get("contributor"), nodes -> nodes.stream().map(Node::getTextValue)).put("subject", fields.get("subject"), nodes -> nodes.stream().map(node -> {
            Map<String, String> a = node.getAttributes();
            String classId = StringUtils.isNotBlank((CharSequence)a.get("classid")) ? a.get("classid") : "keyword";
            String className = StringUtils.isNotBlank((CharSequence)a.get("classname")) ? a.get("classname") : "keyword";
            String schemeId = StringUtils.isNotBlank((CharSequence)a.get("schemeid")) ? a.get("schemeid") : "dnet:subject_classification_typologies";
            String schemeName = StringUtils.isNotBlank((CharSequence)a.get("schemename")) ? a.get("schemename") : "dnet:subject_classification_typologies";
            return Utils.getStructuredProperty(node.getTextValue(), classId, className, schemeId, schemeName);
        })).put("format", fields.get("format"), nodes -> nodes.stream().map(Node::getTextValue)).put("source", fields.get("source"), nodes -> nodes.stream().map(Node::getTextValue)).put("size", fields.get("size"), nodes -> nodes.stream().map(Node::getTextValue)).put("version", fields.get("version"), nodes -> nodes.stream().map(Node::getTextValue)).put("publisher", fields.get("publisher"), nodes -> nodes.stream().map(Node::getTextValue)).put("language", fields.get("language"), nodes -> nodes.stream().map(Node::getTextValue).map(code -> Utils.getQualifier(code, Utils.getClassName(code), "dnet:languages", "dnet:languages"))).put("resourcetype", fields.get("resourcetype"), nodes -> nodes.stream().map(node -> node.getAttributes().get("resourceTypeGeneral")).map(resourceType -> Utils.getSimpleQualifier(resourceType, "dnet:dataCite_resource"))).put("resulttype", fields.get("resulttype"), nodes -> nodes.stream().map(Node::getTextValue).map(cobjcategory -> Utils.getSimpleQualifier(this.getResulttype((String)cobjcategory), "dnet:result_typologies"))).put("concept", fields.get("concept"), nodes -> nodes.stream().filter(node -> node.getAttributes() != null && StringUtils.isNotBlank((CharSequence)node.getAttributes().get("id"))).map(node -> ResultProtos.Result.Context.newBuilder().setId(node.getAttributes().get("id")))).put("journal", fields.get("journal"), nodes -> nodes.stream().map(node -> {
            FieldTypeProtos.Journal.Builder journal = FieldTypeProtos.Journal.newBuilder();
            if (StringUtils.isNotBlank((CharSequence)node.getTextValue())) {
                journal.setName(node.getTextValue());
            }
            if (node.getAttributes() != null) {
                Map<String, String> a = node.getAttributes();
                if (StringUtils.isNotBlank((CharSequence)a.get("issn"))) {
                    journal.setIssnPrinted(a.get("issn"));
                }
                if (StringUtils.isNotBlank((CharSequence)a.get("eissn"))) {
                    journal.setIssnOnline(a.get("eissn"));
                }
                if (StringUtils.isNotBlank((CharSequence)a.get("lissn"))) {
                    journal.setIssnLinking(a.get("lissn"));
                }
                if (StringUtils.isNotBlank((CharSequence)a.get("sp"))) {
                    journal.setSp(a.get("sp"));
                }
                if (StringUtils.isNotBlank((CharSequence)a.get("ep"))) {
                    journal.setEp(a.get("ep"));
                }
                if (StringUtils.isNotBlank((CharSequence)a.get("iss"))) {
                    journal.setIss(a.get("iss"));
                }
                if (StringUtils.isNotBlank((CharSequence)a.get("vol"))) {
                    journal.setVol(a.get("vol"));
                }
            }
            return journal;
        }));
        specs.put(OafProtos.OafEntity.getDescriptor(), SpecificationDescriptor.newInstance()).setBuilder((Message.Builder)OafProtos.OafEntity.newBuilder().setType(TypeProtos.Type.result)).put("originalId", fields.get("originalId"), nodes -> nodes.stream().map(Node::getTextValue).map(s -> StringUtils.contains((CharSequence)s, (CharSequence)"::") ? StringUtils.substringAfter((String)s, (String)"::") : s).filter(s -> !s.trim().matches("^(http|https|ftp)\\://.*"))).put("collectedfrom", fields.get("collectedfrom"), nodes -> nodes.stream().map(node -> Utils.getKV(AbstractDNetXsltFunctions.oafSplitId(TypeProtos.Type.datasource.name(), node.getAttributes().get("id")), node.getAttributes().get("name")))).put("pid", fields.get("pid"), nodes -> nodes.stream().filter(pid -> {
            Map<String, String> a = pid.getAttributes();
            return a.containsKey("identifierType") || a.containsKey("alternateIdentifierType");
        }).filter(pid -> {
            Map<String, String> a = pid.getAttributes();
            return !"url".equalsIgnoreCase(a.get("identifierType")) && !"url".equalsIgnoreCase(a.get("alternateIdentifierType"));
        }).map(pid -> {
            Map<String, String> a = pid.getAttributes();
            String identifierType = a.get("identifierType");
            String altIdentifierType = a.get("alternateIdentifierType");
            return FieldTypeProtos.StructuredProperty.newBuilder().setValue(pid.getTextValue()).setQualifier(Utils.getSimpleQualifier(StringUtils.isNotBlank((CharSequence)identifierType) ? identifierType : altIdentifierType, "dnet:pid_types")).build();
        })).put("dateofcollection", fields.get("dateofcollection"), nodes -> nodes.stream().map(Node::getTextValue)).put("dateoftransformation", fields.get("dateoftransformation"), nodes -> nodes.stream().map(Node::getTextValue)).put("cachedRel", fields.get("cachedRel"), nodes -> nodes.stream().map(node -> AbstractResultDom4jParser.getOafRel(node, OafProtos.OafRel.newBuilder().setSource("").setChild(false))).filter(Objects::nonNull).map(oafRel -> oafRel.build()));
        return specs;
    }

    private static OafProtos.OafRel.Builder getOafRel(Node node, OafProtos.OafRel.Builder oafRel) {
        Map<String, String> a = node.getAttributes();
        switch (node.getName()) {
            case "projectid": {
                if (StringUtils.isBlank((CharSequence)node.getTextValue())) {
                    return null;
                }
                return oafRel.setTarget(AbstractDNetXsltFunctions.oafSplitId(TypeProtos.Type.project.name(), StringUtils.trim((String)node.getTextValue()))).setRelType(RelTypeProtos.RelType.resultProject).setSubRelType(RelTypeProtos.SubRelType.outcome).setRelClass("isProducedBy");
            }
            case "relatedPublication": 
            case "relatedDataSet": {
                if (StringUtils.isBlank((CharSequence)a.get("id"))) {
                    return null;
                }
                return oafRel.setTarget(AbstractDNetXsltFunctions.oafSimpleId(TypeProtos.Type.result.name(), StringUtils.trim((String)a.get("id")))).setRelType(RelTypeProtos.RelType.resultResult).setSubRelType(RelTypeProtos.SubRelType.publicationDataset).setRelClass("isRelatedTo");
            }
            case "relatedIdentifier": {
                if (StringUtils.isBlank((CharSequence)node.getTextValue())) {
                    return null;
                }
                return oafRel.setTarget(node.getTextValue()).setRelType(RelTypeProtos.RelType.resultResult).setSubRelType(RelTypeProtos.SubRelType.relationship).setRelClass(a.get("relationType")).setCachedTarget(OafProtos.OafEntity.newBuilder().setType(TypeProtos.Type.result).setId("").addPid(FieldTypeProtos.StructuredProperty.newBuilder().setValue(node.getTextValue()).setQualifier(Utils.getSimpleQualifier(a.get("relatedIdentifierType"), "dnet:pid_types")).build()));
            }
        }
        return null;
    }

    private FieldTypeProtos.OAIProvenance.OriginDescription getOriginDescription(Document document, String basePath) throws VtdException {
        FieldTypeProtos.OAIProvenance.OriginDescription originDescription;
        String metadataNamespace;
        String datestamp;
        String identifier;
        String altered;
        FieldTypeProtos.OAIProvenance.OriginDescription.Builder od = FieldTypeProtos.OAIProvenance.OriginDescription.newBuilder();
        if (Dom4jUtilityParser.getNodes(document, basePath).isEmpty()) {
            return od.build();
        }
        Map<String, String> odAttr = Dom4jUtilityParser.getNode(document, basePath).getAttributes();
        String harvestDate = odAttr.get("harvestDate");
        if (StringUtils.isNotBlank((CharSequence)harvestDate)) {
            od.setHarvestDate(harvestDate);
        }
        if (StringUtils.isNotBlank((CharSequence)(altered = odAttr.get("altered")))) {
            od.setAltered(Boolean.valueOf(altered).booleanValue());
        }
        String baseUrl = Dom4jUtilityParser.getFirstValue(document, basePath + Dom4jUtilityParser.xpath("baseURL"));
        if (StringUtils.isNotBlank((CharSequence)basePath)) {
            od.setBaseURL(baseUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)(identifier = Dom4jUtilityParser.getFirstValue(document, basePath + Dom4jUtilityParser.xpath("identifier"))))) {
            od.setIdentifier(identifier);
        }
        if (StringUtils.isNotBlank((CharSequence)(datestamp = Dom4jUtilityParser.getFirstValue(document, basePath + Dom4jUtilityParser.xpath("datestamp"))))) {
            od.setDatestamp(datestamp);
        }
        if (StringUtils.isNotBlank((CharSequence)(metadataNamespace = Dom4jUtilityParser.getFirstValue(document, basePath + Dom4jUtilityParser.xpath("metadataNamespace"))))) {
            od.setMetadataNamespace(metadataNamespace);
        }
        if ((originDescription = this.getOriginDescription(document, basePath + Dom4jUtilityParser.xpath("originDescription"))).hasHarvestDate()) {
            od.setOriginDescription(originDescription);
        }
        return od.build();
    }

    private FieldTypeProtos.OAIProvenance getOaiProvenance(Document document) throws VtdException {
        return FieldTypeProtos.OAIProvenance.newBuilder().setOriginDescription(this.getOriginDescription(document, Dom4jUtilityParser.xpath("record", "about", "provenance", "originDescription"))).build();
    }

    private FieldTypeProtos.DataInfo.Builder ensureDataInfo(Document document, FieldTypeProtos.DataInfo.Builder info) throws VtdException {
        if (info.isInitialized()) {
            return info;
        }
        return this.buildDataInfo(document, this.invisible, this.provenance, this.trust, false, false);
    }

    private FieldTypeProtos.DataInfo.Builder buildDataInfo(Document document, boolean invisible, String defaultProvenanceaction, String defaultTrust, boolean defaultDeletedbyinference, boolean defaultInferred) throws VtdException {
        FieldTypeProtos.DataInfo.Builder dataInfoBuilder = FieldTypeProtos.DataInfo.newBuilder().setInvisible(invisible).setInferred(defaultInferred).setDeletedbyinference(defaultDeletedbyinference).setTrust(defaultTrust).setProvenanceaction(Utils.getSimpleQualifier(defaultProvenanceaction, "dnet:provenanceActions"));
        String xpath = Dom4jUtilityParser.xpath("record", "about", "datainfo");
        if (Dom4jUtilityParser.getNodes(document, xpath).size() > 0) {
            Map<String, String> provAction = Dom4jUtilityParser.getNode(document, xpath + Dom4jUtilityParser.xpath("provenanceaction")).getAttributes();
            dataInfoBuilder.setInvisible(Boolean.valueOf(Utils.getValue(Dom4jUtilityParser.getNode(document, xpath + Dom4jUtilityParser.xpath("invisible")), String.valueOf(invisible))).booleanValue()).setInferred(Boolean.valueOf(Utils.getValue(Dom4jUtilityParser.getNode(document, xpath + Dom4jUtilityParser.xpath("inferred")), String.valueOf(defaultInferred))).booleanValue()).setDeletedbyinference(Boolean.valueOf(Utils.getValue(Dom4jUtilityParser.getNode(document, xpath + Dom4jUtilityParser.xpath("deletedbyinference")), String.valueOf(defaultDeletedbyinference))).booleanValue()).setTrust(Utils.getValue(Dom4jUtilityParser.getNode(document, xpath + Dom4jUtilityParser.xpath("trust")), defaultTrust)).setInferenceprovenance(Utils.getValue(Dom4jUtilityParser.getNode(document, xpath + Dom4jUtilityParser.xpath("inferenceprovenance")), "")).setProvenanceaction(Utils.getSimpleQualifier(Utils.getValue(provAction.get("classid"), defaultProvenanceaction), "dnet:provenanceActions"));
        }
        return dataInfoBuilder;
    }
}

