/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.pace.config.Type;
import eu.dnetlib.pace.model.FieldDef;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractProtoMapper {
    private static final String COND_WRAPPER = "\\{|\\}";
    private static final String COND_SEPARATOR = "#";
    private static final String PATH_SEPARATOR = "/";

    protected List<Object> processMultiPath(GeneratedMessage proto, FieldDef fieldDef, List<String> paths) {
        ArrayList response = Lists.newArrayList();
        for (String pathElements : paths) {
            response.addAll(this.processPath(proto, fieldDef, pathElements));
        }
        return response;
    }

    protected List<Object> processPath(GeneratedMessage proto, FieldDef fieldDef, String path) {
        return this.processPath(proto, fieldDef, Lists.newLinkedList((Iterable)Splitter.on((String)PATH_SEPARATOR).trimResults().split((CharSequence)path)));
    }

    protected List<Object> processPath(GeneratedMessage proto, FieldDef fieldDef, List<String> pathElements) {
        ArrayList response = Lists.newArrayList();
        if (pathElements.isEmpty()) {
            throw new RuntimeException("ProtoBuf navigation path is empty");
        }
        String fieldPathCond = pathElements.get(0);
        String fieldPath = StringUtils.substringBefore((String)fieldPathCond, (String)"[");
        String cond = this.getCondition(fieldPathCond);
        Descriptors.FieldDescriptor fd = proto.getDescriptorForType().findFieldByName(fieldPath);
        if (fd != null) {
            if (fd.isRepeated()) {
                int fieldCount = proto.getRepeatedFieldCount(fd);
                int count = fieldDef.getSize() < 0 ? fieldCount : (fieldDef.getSize() < fieldCount ? fieldDef.getSize() : fieldCount);
                for (int i = 0; i < count; ++i) {
                    Object field = proto.getRepeatedField(fd, i);
                    response.addAll(this.generateFields(fd, field, fieldDef, pathElements, cond));
                }
            } else {
                Object field = proto.getField(fd);
                response.addAll(this.generateFields(fd, field, fieldDef, pathElements, cond));
            }
        } else {
            throw new IllegalArgumentException("Invalid protobuf path (field not found): " + StringUtils.join(pathElements, (String)">") + "\nMessage:\n" + proto);
        }
        return response;
    }

    private List<Object> generateFields(Descriptors.FieldDescriptor fd, Object field, FieldDef fieldDef, List<String> list, String cond) {
        ArrayList res = Lists.newArrayList();
        if (field instanceof GeneratedMessage) {
            if (list.size() > 1) {
                String condVal;
                if (StringUtils.isBlank((String)cond)) {
                    return this.processPath((GeneratedMessage)field, fieldDef, list.subList(1, list.size()));
                }
                LinkedList condPath = Lists.newLinkedList((Iterable)Splitter.on((String)COND_SEPARATOR).trimResults().split((CharSequence)StringUtils.substringBefore((String)cond, (String)"=")));
                String val = (String)Iterables.getOnlyElement(this.processPath((GeneratedMessage)field, fieldDef, condPath));
                return val.equals(condVal = StringUtils.substringAfter((String)cond, (String)"=").replaceAll(COND_WRAPPER, "").trim()) ? this.processPath((GeneratedMessage)field, fieldDef, list.subList(1, list.size())) : res;
            }
            if (Type.JSON.equals((Object)fieldDef.getType())) {
                res.add(JsonFormat.printToString((Message)((Message)field)));
                return res;
            }
            throw new RuntimeException("No primitive type found");
        }
        if (list.size() == 1) {
            switch (fd.getType()) {
                case ENUM: {
                    res.add(((Descriptors.EnumValueDescriptor)field).getName());
                    break;
                }
                default: {
                    if (field instanceof String && fieldDef.getLength() > 0) {
                        res.add(StringUtils.substring((String)((String)field), (int)0, (int)fieldDef.getLength()));
                        break;
                    }
                    res.add(field);
                }
            }
            return res;
        }
        throw new RuntimeException("Found a primitive type before the path end");
    }

    private String getCondition(String fieldPathCond) {
        return fieldPathCond.contains("[") ? StringUtils.substringAfter((String)fieldPathCond, (String)"[").replace("]", "") : "";
    }
}

