/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform.xml;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.protobuf.Message;
import eu.dnetlib.data.mapreduce.util.OafRowKeyDecoder;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.CommonDNetXsltFunctions;
import eu.dnetlib.data.transform.xml.Element;
import eu.dnetlib.data.transform.xml.ValueMap;
import eu.dnetlib.pace.model.Person;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OdfToHbaseXsltFunctions
extends CommonDNetXsltFunctions {
    private static Map<String, String> mappingAccess = Maps.newHashMap();

    public static String odfResult(String resultId, boolean invisible, NodeList about, NodeList metadata, NodeList titles, NodeList creators, NodeList subjects, NodeList publisher, NodeList descriptions, NodeList dates, NodeList dateaccepted, NodeList resourceTypes, NodeList formats, NodeList sizes, NodeList languages, NodeList cobjcategory, NodeList contributors, NodeList rights, NodeList license, NodeList version, NodeList pidList, String provenance, String trust, NodeList hostedby, NodeList collectedfrom, NodeList originalIds, String instanceUri, String landingPage, NodeList distributionlocation, NodeList documentationUrl, String dateOfCollection, String dateOfTransformation) {
        try {
            Object attributes;
            NodeList childNodes;
            Node currentNode;
            int i;
            String entityId = OafRowKeyDecoder.decode(resultId).getKey();
            ResultProtos.Result.Builder result = ResultProtos.Result.newBuilder();
            ResultProtos.Result.Metadata.Builder metadataProto = ResultProtos.Result.Metadata.newBuilder();
            for (i = 0; i < subjects.getLength(); ++i) {
                currentNode = subjects.item(i);
                childNodes = currentNode.getChildNodes();
                if (childNodes.getLength() <= 0) continue;
                String subjectValue = childNodes.item(0).getNodeValue();
                String schemeName = "keyword";
                String schemeURI = "keyword";
                if (currentNode.hasAttributes()) {
                    attributes = currentNode.getAttributes();
                    Node schemeNameNode = attributes.getNamedItem("subjectScheme");
                    Node schemeURINode = attributes.getNamedItem("schemeURI");
                    if (schemeNameNode != null) {
                        schemeName = schemeNameNode.getTextContent();
                    }
                    if (schemeURINode != null) {
                        schemeURI = schemeURINode.getTextContent();
                    }
                    if (schemeNameNode != null && schemeURINode == null) {
                        schemeURI = schemeName;
                    }
                    if (schemeURINode != null && schemeNameNode == null) {
                        schemeName = schemeURI;
                    }
                }
                OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("subject"), OdfToHbaseXsltFunctions.getStructuredProperty(subjectValue, schemeURI, schemeName, "dnet:subject_classification_typologies", "dnet:subject_classification_typologies"));
            }
            for (i = 0; i < titles.getLength(); ++i) {
                currentNode = titles.item(i);
                childNodes = currentNode.getChildNodes();
                if (childNodes.getLength() <= 0) continue;
                String titleValue = childNodes.item(0).getNodeValue();
                String classname = "main title";
                String classid = "main title";
                if (currentNode.hasAttributes()) {
                    attributes = currentNode.getAttributes();
                    Node titleType = attributes.getNamedItem("titleType");
                    if (titleType != null && titleType.getNodeValue().equals("AlternativeTitle")) {
                        classname = "alternative title";
                        classid = "alternative title";
                    }
                    if (titleType != null && titleType.getNodeValue().equals("Subtitle")) {
                        classname = "subtitle";
                        classid = "subtitle";
                    }
                    if (titleType != null && titleType.getNodeValue().equals("TranslatedTitle")) {
                        classname = "translated title";
                        classid = "translated title";
                    }
                }
                OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("title"), OdfToHbaseXsltFunctions.getStructuredProperty(titleValue, classname, classid, "dnet:dataCite_title", "dnet:dataCite_title"));
            }
            for (i = 0; i < creators.getLength(); ++i) {
                org.w3c.dom.Element creator = (org.w3c.dom.Element)creators.item(i);
                if (creator == null || !creator.hasChildNodes()) continue;
                NodeList creatorNames = creator.getElementsByTagName("creatorName");
                if (creatorNames.getLength() > 0) {
                    OdfToHbaseXsltFunctions.createAuthor(metadataProto, i, creator, creatorNames);
                    continue;
                }
                NodeList creatorNamesNs = creator.getElementsByTagNameNS("http://datacite.org/schema/kernel-4", "creatorName");
                if (creatorNamesNs.getLength() <= 0) continue;
                OdfToHbaseXsltFunctions.createAuthor(metadataProto, i, creator, creatorNamesNs);
            }
            for (i = 0; i < descriptions.getLength(); ++i) {
                currentNode = (org.w3c.dom.Element)descriptions.item(i);
                if (currentNode == null || !currentNode.hasChildNodes()) continue;
                String descriptionValue = currentNode.getChildNodes().item(0).getNodeValue();
                String descriptionType = currentNode.getAttribute("descriptionType");
                if (StringUtils.isNotBlank((CharSequence)descriptionType)) {
                    switch (descriptionType) {
                        case "TechnicalInfo": {
                            OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("tool"), descriptionValue);
                            break;
                        }
                        case "Abstract": {
                            OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("description"), descriptionValue);
                            break;
                        }
                        case "DistributionForm": {
                            OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("format"), descriptionValue);
                        }
                    }
                    continue;
                }
                OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("description"), descriptionValue);
            }
            for (i = 0; i < contributors.getLength(); ++i) {
                org.w3c.dom.Element contributorName;
                NodeList contributorNames;
                org.w3c.dom.Element contributor = (org.w3c.dom.Element)contributors.item(i);
                if (contributor == null || !contributor.hasChildNodes() || (contributorNames = contributor.getElementsByTagName("contributorName")) == null || (contributorName = (org.w3c.dom.Element)contributorNames.item(0)) == null) continue;
                String contributorValue = contributorName.getTextContent();
                String contributorType = contributor.getAttribute("contributorType");
                if (StringUtils.isNotBlank((CharSequence)contributorType)) {
                    switch (contributorType) {
                        case "ContactPerson": {
                            OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("contactperson"), contributorValue);
                            break;
                        }
                        case "ContactGroup": {
                            OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("contactgroup"), contributorValue);
                        }
                    }
                    continue;
                }
                OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("contributor"), contributorValue);
            }
            OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("publisher"), OdfToHbaseXsltFunctions.getFirstItem(publisher));
            for (i = 0; i < dates.getLength(); ++i) {
                Node dateType;
                currentNode = dates.item(i);
                if (currentNode == null || !currentNode.hasAttributes() || !currentNode.hasChildNodes()) continue;
                Object attributes2 = currentNode.getAttributes();
                Node node = dateType = attributes2.getNamedItem("dateType") == null ? attributes2.getNamedItem("datetype") : null;
                if (dateType == null) continue;
                String dateAttribute = dateType.getNodeValue();
                String dateValue = currentNode.getChildNodes().item(0).getNodeValue();
                String protoAttribute = "relevantdate";
                if ("Accepted".equals(dateAttribute)) {
                    protoAttribute = "dateofacceptance";
                } else if ("Issued".equals(dateAttribute)) {
                    protoAttribute = "storagedate";
                } else if ("Updated".equals(dateAttribute)) {
                    protoAttribute = "lastmetadataupdate";
                } else if ("Available".equals(dateAttribute)) {
                    protoAttribute = "embargoenddate";
                }
                if (!protoAttribute.equals("relevantdate")) {
                    OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName(protoAttribute), dateValue);
                    continue;
                }
                OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName(protoAttribute), OdfToHbaseXsltFunctions.getStructuredProperty(dateValue, "UNKNOWN", "UNKNOWN", "dnet:dataCite_date", "dnet:dataCite_date"));
            }
            OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("license"), OdfToHbaseXsltFunctions.getFirstItem(license));
            OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("dateofacceptance"), OdfToHbaseXsltFunctions.getFirstItem(dateaccepted));
            OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("size"), OdfToHbaseXsltFunctions.getFirstItem(sizes));
            OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("version"), OdfToHbaseXsltFunctions.getFirstItem(version));
            OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("language"), OdfToHbaseXsltFunctions.setQualifier(OdfToHbaseXsltFunctions.getDefaultQualifier("dnet:languages"), Lists.newArrayList((Object[])new String[]{OdfToHbaseXsltFunctions.getFirstItem(languages)})));
            OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("resourcetype"), OdfToHbaseXsltFunctions.setQualifier(OdfToHbaseXsltFunctions.getDefaultQualifier("dnet:dataCite_resource"), Lists.newArrayList((Object[])new String[]{OdfToHbaseXsltFunctions.getFirstItem(resourceTypes)})));
            String cobjcategoryCode = OdfToHbaseXsltFunctions.getFirstItem(cobjcategory);
            String resulttype = OdfToHbaseXsltFunctions.getResultType(cobjcategory);
            OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("resulttype"), OdfToHbaseXsltFunctions.getSimpleQualifier(resulttype, "dnet:result_typologies"));
            switch (resulttype) {
                case "software": {
                    OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("programmingLanguage"), OdfToHbaseXsltFunctions.getSimpleQualifier(OdfToHbaseXsltFunctions.getFirstItem(formats), "dnet:programming_languages"));
                    break;
                }
                case "dataset": {
                    for (int i2 = 0; i2 < formats.getLength(); ++i2) {
                        Node currentNode2 = formats.item(i2);
                        NodeList childNodes2 = currentNode2.getChildNodes();
                        if (childNodes2.getLength() <= 0) continue;
                        String formatValue = childNodes2.item(0).getNodeValue();
                        OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("format"), formatValue);
                    }
                    break;
                }
            }
            for (int i3 = 0; i3 < documentationUrl.getLength(); ++i3) {
                String value;
                org.w3c.dom.Element docUrl = (org.w3c.dom.Element)documentationUrl.item(i3);
                if (docUrl == null || !docUrl.hasChildNodes() || !StringUtils.isNotBlank((CharSequence)(value = docUrl.getTextContent()))) continue;
                OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("documentationUrl"), value);
            }
            ValueMap values = ValueMap.parseNodeList(metadata);
            if (values.get("concept") != null) {
                for (Element e : values.get("concept")) {
                    String id = e.getAttributes().get("id");
                    if (StringUtils.isBlank((CharSequence)id)) {
                        throw new IllegalArgumentException("Context id cannot be blank");
                    }
                    metadataProto.addContext(ResultProtos.Result.Context.newBuilder().setId(id));
                }
            }
            if (values.containsKey("journal")) {
                for (Element journal : values.get("journal")) {
                    OdfToHbaseXsltFunctions.addJournal(metadataProto, journal);
                }
            }
            List<FieldTypeProtos.KeyValue> hostedBys = OdfToHbaseXsltFunctions.getKeyValues(ValueMap.parseNodeList(hostedby), "hostedby", TypeProtos.Type.datasource);
            List<FieldTypeProtos.KeyValue> collectedFroms = OdfToHbaseXsltFunctions.getKeyValues(ValueMap.parseNodeList(collectedfrom), "collectedfrom", TypeProtos.Type.datasource);
            ResultProtos.Result.Instance.Builder instance = ResultProtos.Result.Instance.newBuilder();
            String tmpRigths = "UNKNOWN";
            String firstRight = OdfToHbaseXsltFunctions.getFirstItem(rights);
            if (mappingAccess.containsKey(firstRight)) {
                tmpRigths = mappingAccess.get(firstRight);
            }
            OdfToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("license"), OdfToHbaseXsltFunctions.getFirstItem(license));
            OdfToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("hostedby"), hostedBys);
            OdfToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("accessright"), OdfToHbaseXsltFunctions.setQualifier(OdfToHbaseXsltFunctions.getDefaultQualifier("dnet:access_modes"), Lists.newArrayList((Object[])new String[]{tmpRigths})));
            OdfToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("instancetype"), OdfToHbaseXsltFunctions.setQualifier(OdfToHbaseXsltFunctions.getDefaultQualifier("dnet:dataCite_resource"), Lists.newArrayList((Object[])new String[]{cobjcategoryCode})));
            if (StringUtils.isNotBlank((CharSequence)landingPage)) {
                OdfToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("url"), landingPage);
            }
            if (StringUtils.isNotBlank((CharSequence)instanceUri)) {
                OdfToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("url"), instanceUri);
            }
            OdfToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("distributionlocation"), OdfToHbaseXsltFunctions.getFirstItem(distributionlocation));
            OdfToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("collectedfrom"), collectedFroms);
            OdfToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("dateofacceptance"), OdfToHbaseXsltFunctions.getFirstItem(dateaccepted));
            if (values.get("refereed") != null) {
                OdfToHbaseXsltFunctions.addField((Message.Builder)instance, ResultProtos.Result.Instance.getDescriptor().findFieldByName("refereed"), values.get("refereed").listValues());
            }
            result.addInstance(instance);
            List<FieldTypeProtos.StructuredProperty> pids = OdfToHbaseXsltFunctions.parsePids(pidList);
            HashSet originalIdList = Sets.newHashSet();
            for (int i4 = 0; i4 < originalIds.getLength(); ++i4) {
                Node currentNode3 = originalIds.item(i4);
                if (currentNode3 == null || !currentNode3.hasChildNodes()) continue;
                originalIdList.add(currentNode3.getChildNodes().item(0).getNodeValue());
            }
            OafProtos.OafEntity.Builder entity = OdfToHbaseXsltFunctions.getEntity(TypeProtos.Type.result, entityId, collectedFroms, originalIdList, dateOfCollection, dateOfTransformation, pids).setResult(result.setMetadata(metadataProto));
            entity.setOaiprovenance(OdfToHbaseXsltFunctions.getOAIProvenance(about));
            OafProtos.Oaf oaf = OdfToHbaseXsltFunctions.getOaf(entity, OdfToHbaseXsltFunctions.getDataInfo(invisible, about, provenance, trust, false, false));
            return OdfToHbaseXsltFunctions.base64(oaf.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
    }

    private static void createAuthor(ResultProtos.Result.Metadata.Builder metadataProto, int i, org.w3c.dom.Element creator, NodeList creatorNames) {
        NodeList nameIdentifiers;
        org.w3c.dom.Element creatorName = (org.w3c.dom.Element)creatorNames.item(0);
        FieldTypeProtos.Author.Builder author = FieldTypeProtos.Author.newBuilder();
        author.setRank(i + 1);
        String fullname = StringUtils.trim((String)creatorName.getTextContent());
        author.setFullname(fullname);
        Person p = new Person(fullname, false);
        if (p.isAccurate()) {
            author.setName(p.getNormalisedFirstName());
            author.setSurname(p.getNormalisedSurname());
        }
        if ((nameIdentifiers = creator.getElementsByTagName("nameIdentifier")).getLength() > 0) {
            org.w3c.dom.Element nameIdentifier = (org.w3c.dom.Element)nameIdentifiers.item(0);
            String nameIdentifierScheme = nameIdentifier.getAttribute("nameIdentifierScheme");
            String id = StringUtils.trim((String)nameIdentifier.getTextContent());
            if (StringUtils.isNotBlank((CharSequence)id) && StringUtils.isNotBlank((CharSequence)nameIdentifierScheme)) {
                author.addPid(OdfToHbaseXsltFunctions.getKV(nameIdentifierScheme, id));
            }
        }
        OdfToHbaseXsltFunctions.addField((Message.Builder)metadataProto, ResultProtos.Result.Metadata.getDescriptor().findFieldByName("author"), author);
    }

    private static String getResultType(NodeList cobjcategoryNode) {
        ValueMap values = ValueMap.parseNodeList(cobjcategoryNode);
        Element cobjcategory = values.get("cobjcategory").stream().map(e -> StringUtils.isNotBlank((CharSequence)e.getText()) ? e : new Element("0000", e.getAttributes())).findFirst().orElse(new Element("0000", new HashMap<String, String>()));
        String resulttype = cobjcategory.getAttributeValue("type");
        if (StringUtils.isNotBlank((CharSequence)resulttype)) {
            return resulttype;
        }
        return OdfToHbaseXsltFunctions.getDefaultResulttype(cobjcategory);
    }

    public static String getFirstItem(NodeList list) {
        String out = "";
        if (list != null && list.getLength() > 0 && list.item(0).getChildNodes() != null && list.item(0).getChildNodes().getLength() > 0) {
            out = list.item(0).getChildNodes().item(0).getNodeValue();
        }
        return out;
    }

    static {
        mappingAccess.put("info:eu-repo/semantics/openAccess", "OPEN");
        mappingAccess.put("info:eu-repo/semantics/closedAccess", "CLOSED");
        mappingAccess.put("info:eu-repo/semantics/restrictedAccess", "RESTRICTED");
        mappingAccess.put("info:eu-repo/semantics/embargoedAccess", "EMBARGO");
        mappingAccess.put("OPEN", "OPEN");
        mappingAccess.put("CLOSED", "CLOSED");
        mappingAccess.put("RESTRICTED", "RESTRICTED");
        mappingAccess.put("EMBARGO", "EMBARGO");
        mappingAccess.put("OPEN SOURCE", "OPEN SOURCE");
    }
}

