package eu.dnetlib.data.transform.xml;

import java.lang.reflect.Type;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import org.apache.commons.lang.StringUtils;


/**
 * * <xsl:stylesheet ... xmlns:openTrials="eu.dnetlib.miscutils.functional.xml.OpenTrialsFunctions"> ... </xsl:stylesheet>
 * Created by alessia on 13/05/16.
 */
public class OpenTrialsXsltFunctions {

	/**
	 * Parses a json to get the first url item.
	 *
	 * @param jsonProvList A json string in the following format: [{"url" : "theUrl", "sourceID" : "theSourceId", "sourceName" : "theSourceName"}]
	 * @return the url value in the first object in the list
	 */
	@Deprecated
	public static String getMainIdentifierURL(String jsonProvList) {
		List<JsonProv> provs = getProvs(jsonProvList);
		for (JsonProv prov : provs) {
			if (StringUtils.isNotBlank(prov.getUrl())) return prov.getUrl();
		}
		return "";
	}

	/**
	 * Parses a Json to get the url item associated to the primary record if any
	 * @param jsonRecordsList A json string in the format [{"source_id","theSourceId","source_url","theUrlOfTheTrialForThisSource", "is_primary","typeOfTheTrial")}]
	 * @return the url value of the primary record
	 */
	public static String getPrimaryRecordUrl(String jsonRecordsList){
		List<JsonRecord> records = getRecords(jsonRecordsList);
		for (JsonRecord record : records) {
			if(record.isIs_primary() && StringUtils.isNotBlank(record.getSource_url()))
				return record.getSource_url();
		}
		if (!records.isEmpty() && StringUtils.isNotBlank(records.get(0).getSource_url())){
			return records.get(0).getSource_url();
		}
		return "";
	}

	/**
	 * Parses a Json to get the id of the source associated to the primary record if any
	 * @param jsonRecordsList A json string in the format [{"source_id","theSourceId","source_url","theUrlOfTheTrialForThisSource", "is_primary","typeOfTheTrial")}]
	 * @return the id of the source of the primary record
	 */
	public static String getPrimaryRecordIdentifier(String jsonRecordsList){
		List<JsonRecord> records = getRecords(jsonRecordsList);
		for (JsonRecord record : records) {
			if(record.isIs_primary() && StringUtils.isNotBlank(record.getSource_id()))
				return record.getSource_id();
		}
		if (!records.isEmpty() && StringUtils.isNotBlank(records.get(0).getSource_url())){
			return records.get(0).getSource_id();
		}
		return "";
	}

	/**
	 * Parses a Json to get the list of the not primary url associated to the trial if any
	 * @param jsonRecordsList A json string in the format [{"source_id","theSourceId","source_url","theUrlOfTheTrialForThisSource", "is_primary","typeOfTheTrial")}]
	 * @return a string containing the not primary source urls divided by "@@"
	 */
	public static String getNotPrimaryRecordUrl(String jsonRecordsList){
		boolean found = false;
		String ret = "";
		List<JsonRecord> records = getRecords(jsonRecordsList);
		for (JsonRecord record : records) {
			if(record.isIs_primary())
				found = true;
			else
			if(StringUtils.isNotBlank(record.getSource_url()))
				ret += record.getSource_url() + "@@";
		}
		if (!found && ret.length() > 0){
			ret = ret.substring(ret.indexOf("@@")+2);
		}
		if(ret.endsWith("@@"))
			ret = ret.substring(0,ret.length()-2);

		return ret;
	}

	/**
	 * Parses a Json to get the names of the principal investigators of the trial if any
	 * @param jsonPeopleList A json string in the format [{"person_name", "thePersonName", "person_id","thePersonId", "person_role",thePersonRole)}]
	 * @return a string containing the names of the principal investigators divided by @@
	 */
	public static String getPrincipalInvestigators(String jsonPeopleList){
		List<JsonPeople> people = getPeople(jsonPeopleList);
		String ret ="";
		for (JsonPeople person : people) {
			if(StringUtils.isNotBlank(person.getPerson_role()) && (person.getPerson_role().equals("principal_investigator"))){
				ret += conformToGuidelines(person.getPerson_name()) + "@@";
			}

		}
		if(ret.endsWith("@@")){
			ret=ret.substring(0,ret.length()-2);
		}
		return ret;
	}

	private static String conformToGuidelines(String person_name) {

		if (person_name.indexOf(",") > -1)
			person_name = person_name.substring(0,person_name.indexOf(","));
		String[] name = person_name.split(" ");
		person_name = name[name.length-1] + ",";
		for(int i=0;i<name.length-1; i++)
			person_name += " " + name[i];

		return person_name;
	}

	/**
	 * Parses a Json to get the names of the organizations supporting the trial if any
	 * @param jsonOrganizationList A json string in the format [{"organization_name", "theOrganizationName", "organization_id","theOrganizationId", "organization_role",theOrganizationRole)}]
	 * @return a string containing the names and roles of the organizations
	 */
	public static String getTrialOrganizations(String jsonOrganizationList){
		List<JsonOrganization> organizations = getOrganizations(jsonOrganizationList);
		String ret ="";
		for (JsonOrganization o : organizations) {
			if (StringUtils.isNotBlank(o.getOrganization_id())) {
				ret += o.getOrganization_name() + "@";
				if (o.getOrganization_role().equalsIgnoreCase("primary_sponsor"))
					ret += "sponsor@@";
				else
					ret += o.getOrganization_role() + "@@";
			}
		}
		if(ret.endsWith("@@")){
			ret=ret.substring(0,ret.length()-2);
		}
		return ret;
	}

	/**
	 * Parses a Json to get the names of the locations where the trial take place if any
	 * @param jsonLocationsList A json string in the format [{"location_name","theLocationName"}]
	 * @return a string containing the locations associated to the trial divided by "@@"
	 */
	public static String getTrialLocations(String jsonLocationsList){
		List<JsonLocation> locations = getLocations(jsonLocationsList);
		String ret ="";
		for (JsonLocation l : locations) {
			if (StringUtils.isNotBlank(l.getLocation_name()))
				ret += l.getLocation_name() + "@@";

		}
		if(ret.endsWith("@@")){
			ret=ret.substring(0,ret.length()-2);
		}
		return ret;
	}

	@Deprecated
	public static List<JsonProv> getProvs(String jsonProvList) {
		Gson gson = new Gson();
		Type type = new TypeToken<List<JsonProv>>() {
		}.getType();
		return gson.fromJson(jsonProvList, type);
	}

	public static List<JsonRecord> getRecords(String jsonRecordsList) {
		Gson gson = new Gson();
		Type type = new TypeToken<List<JsonRecord>>() {
		}.getType();
		return gson.fromJson(jsonRecordsList, type);
	}


	public static List<JsonPeople> getPeople(String jsonPeopleList) {
		Gson gson = new Gson();
		Type type = new TypeToken<List<JsonPeople>>() {
		}.getType();
		return gson.fromJson(jsonPeopleList, type);
	}

	public static List<JsonOrganization> getOrganizations(String jsonOrganizationsList) {
		Gson gson = new Gson();
		Type type = new TypeToken<List<JsonOrganization>>() {
		}.getType();
		return gson.fromJson(jsonOrganizationsList, type);
	}

	public static List<JsonLocation> getLocations(String jsonLocationsList) {
		Gson gson = new Gson();
		Type type = new TypeToken<List<JsonLocation>>() {
		}.getType();
		return gson.fromJson(jsonLocationsList, type);
	}

	@Deprecated
	static class JsonProv {

		String url, sourceId, sourceName;

		public String getUrl() {
			return url;
		}

		public void setUrl(final String url) {
			this.url = url;
		}

		public String getSourceId() {
			return sourceId;
		}

		public void setSourceId(final String sourceId) {
			this.sourceId = sourceId;
		}

		public String getSourceName() {
			return sourceName;
		}

		public void setSourceName(final String sourceName) {
			this.sourceName = sourceName;
		}
	}

	static class JsonRecord{
		String source_id, source_url;
		boolean is_primary;

		public String getSource_id() {
			return source_id;
		}

		public String getSource_url() {
			return source_url;
		}

		public void setSource_id(String source_id) {
			this.source_id = source_id;
		}

		public void setSource_url(String source_url) {
			this.source_url = source_url;
		}

		public boolean isIs_primary() {
			return is_primary;
		}

		public void setIs_primary(final boolean is_primary) {
			this.is_primary = is_primary;
		}
	}

	static class JsonPeople{
		String person_name, person_id, person_role;

		public String getPerson_name() {
			return person_name;
		}

		public void setPerson_name(String person_name) {
			this.person_name = person_name;
		}

		public String getPerson_id() {
			return person_id;
		}

		public void setPerson_id(String person_id) {
			this.person_id = person_id;
		}

		public String getPerson_role() {
			return person_role;
		}

		public void setPerson_role(String person_role) {
			this.person_role = person_role;
		}
	}

	static class JsonOrganization{
		String organization_name, organization_id, organization_role;

		public String getOrganization_name() {
			return organization_name;
		}

		public void setOrganization_name(String organization_name) {
			this.organization_name = organization_name;
		}

		public String getOrganization_id() {
			return organization_id;
		}

		public void setOrganization_id(String organization_id) {
			this.organization_id = organization_id;
		}

		public String getOrganization_role() {
			return organization_role;
		}

		public void setOrganization_role(String organization_role) {
			this.organization_role = organization_role;
		}
	}

	static class JsonLocation{
		String location_name;

		public String getLocation_name() {
			return location_name;
		}

		public void setLocation_name(String location_name) {
			this.location_name = location_name;
		}
	}
}
