/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform.xml2;

import com.ximpleware.AutoPilot;
import com.ximpleware.NavException;
import com.ximpleware.ParseException;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import com.ximpleware.XPathParseException;
import eu.dnetlib.data.transform.xml2.Node;
import eu.dnetlib.data.transform.xml2.VtdException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class VtdUtilityParser {
    public static final String NS_SEPARATOR = ":";

    public static String xpath(String ... p) {
        return Arrays.stream(p).map(s -> String.format("/*[local-name()='%s']", s)).reduce((s1, s2) -> s1 + s2).get();
    }

    public static VTDGen parseXml(String xml) throws VtdException {
        VTDGen vg = new VTDGen();
        vg.setDoc(xml.getBytes());
        try {
            vg.parse(true);
        }
        catch (ParseException e) {
            throw new VtdException((Exception)((Object)e));
        }
        return vg;
    }

    public static int countNodes(AutoPilot ap, VTDNav vn, String xpath) throws VtdException {
        if (StringUtils.isBlank((CharSequence)xpath)) {
            return 0;
        }
        try {
            ap.selectXPath(xpath);
            ap.bind(vn);
            Double i = ap.evalXPathToNumber();
            return i.intValue();
        }
        catch (XPathParseException e) {
            throw new VtdException((Exception)((Object)e));
        }
    }

    public static Node getNode(AutoPilot ap, VTDNav vn, String xpath) throws VtdException {
        if (StringUtils.isBlank((CharSequence)xpath)) {
            return new Node();
        }
        try {
            ap.selectXPath(xpath);
            if (ap.evalXPath() != -1) {
                return VtdUtilityParser.asNode(vn);
            }
            return null;
        }
        catch (Exception e) {
            throw new VtdException(e);
        }
    }

    public static List<Node> getNodes(AutoPilot ap, VTDNav vn, String xpath) throws VtdException {
        ArrayList<Node> results = new ArrayList<Node>();
        if (StringUtils.isBlank((CharSequence)xpath)) {
            return results;
        }
        try {
            ap.selectXPath(xpath);
            while (ap.evalXPath() != -1) {
                results.add(VtdUtilityParser.asNode(vn));
            }
            return results;
        }
        catch (Exception e) {
            throw new VtdException(e);
        }
    }

    private static Node asNode(VTDNav vn) throws NavException {
        Node currentNode = new Node();
        String name = vn.toRawString(vn.getCurrentIndex());
        currentNode.setName(name.contains(NS_SEPARATOR) ? StringUtils.substringAfter((String)name, (String)NS_SEPARATOR) : name);
        int t = vn.getText();
        if (t >= 0) {
            currentNode.setTextValue(vn.toNormalizedString(t));
        }
        currentNode.setAttributes(VtdUtilityParser.getAttributes(vn));
        return currentNode;
    }

    private static Map<String, String> getAttributes(VTDNav vn) throws NavException {
        int i;
        AutoPilot ap = new AutoPilot(vn);
        ap.selectAttr("*");
        HashMap<String, String> attributes = new HashMap<String, String>();
        while ((i = ap.iterateAttr()) != -1) {
            attributes.put(vn.toNormalizedString(i), vn.toNormalizedString(i + 1));
        }
        return attributes;
    }

    public static String getFirstValue(AutoPilot ap, VTDNav nav, String xpath) throws VtdException {
        if (StringUtils.isBlank((CharSequence)xpath)) {
            return null;
        }
        try {
            ap.selectXPath(xpath);
            while (ap.evalXPath() != -1) {
                int it = nav.getText();
                if (it <= -1) continue;
                return nav.toNormalizedString(it);
            }
            return null;
        }
        catch (Exception e) {
            throw new VtdException(e);
        }
    }
}

