/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.exporter.model;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class Project {
    public static final String INFO_EU_REPO_GRANT_AGREEMENT = "info:eu-repo/grantAgreement/";
    private String code;
    private String acronym;
    private String title;
    private String call_identifier;
    private String startdate;
    private String enddate;
    private boolean ec_sc39;
    private boolean oa_mandate_for_publications;
    private boolean ec_article29_3;
    private String fundingpathid;
    private String description;
    private String jurisdiction;
    private String legalname;
    private String funder;
    private String countryclass;
    private String role;
    private String firstname;
    private String secondnames;
    private String email;

    public String getIdnamespace() {
        String res = INFO_EU_REPO_GRANT_AGREEMENT + this.getFunder() + "/";
        String fundingProgram = this.asFundingProgram(this.getFundingpathid());
        if (StringUtils.isNotBlank((String)fundingProgram)) {
            res = res + fundingProgram;
        }
        res = res + "/" + this.escapeCode(this.getCode());
        if (StringUtils.isNotBlank((String)this.getJurisdiction())) {
            res = res + "/" + this.getJurisdiction();
        }
        return res;
    }

    public String getListLabel() {
        return String.format("for:value:component:_%s_project_id", this.asFunder(this.getFunder()));
    }

    private String asFunder(String legalshortname) {
        switch (legalshortname.toLowerCase()) {
            case "ec": {
                return this.asFundingProgram(this.getFundingpathid()).toLowerCase();
            }
        }
        return legalshortname.toLowerCase();
    }

    public List<String> asList() {
        return Lists.newArrayList((Object[])new String[]{this.clean(this.getCode()), this.clean(this.getAcronym()), this.clean(this.getTitle()), this.clean(this.getCall_identifier()), this.clean(this.getStartdate()), this.clean(this.getEnddate()), String.valueOf(this.isEc_article29_3()), String.valueOf(this.isOa_mandate_for_publications()), String.valueOf(this.isEc_article29_3()), this.clean(this.getDescription()), this.clean(this.getLegalname()), this.clean(this.getCountryclass()), this.clean(this.getRole()), this.clean(this.getFirstname()), this.clean(this.getSecondnames()), this.clean(this.getEmail())});
    }

    private String clean(String s) {
        return StringUtils.isNotBlank((String)s) ? "\"" + s.replaceAll("\\n|\\t|\\s+", " ").replace("\"", "\"\"").trim() + "\"" : "";
    }

    private String escapeCode(String code) {
        return this.replaceSlash(code);
    }

    private String asFundingProgram(String fundingpathid) {
        ArrayList strings = Lists.newArrayList((Iterable)Splitter.on((String)"::").split((CharSequence)fundingpathid));
        if (strings.size() <= 1) {
            throw new IllegalStateException("Unexpected funding id: " + fundingpathid);
        }
        if (strings.size() == 2) {
            return "";
        }
        return this.replaceSlash((String)strings.get(2));
    }

    private String replaceSlash(String s) {
        return s.replaceAll("/", "%2F");
    }

    public String getCode() {
        return this.code;
    }

    public Project setCode(String code) {
        this.code = code;
        return this;
    }

    public String getAcronym() {
        return this.acronym;
    }

    public Project setAcronym(String acronym) {
        this.acronym = acronym;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public Project setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getCall_identifier() {
        return this.call_identifier;
    }

    public Project setCall_identifier(String call_identifier) {
        this.call_identifier = call_identifier;
        return this;
    }

    public String getStartdate() {
        return this.startdate;
    }

    public Project setStartdate(String startdate) {
        this.startdate = startdate;
        return this;
    }

    public String getEnddate() {
        return this.enddate;
    }

    public Project setEnddate(String enddate) {
        this.enddate = enddate;
        return this;
    }

    public boolean isEc_sc39() {
        return this.ec_sc39;
    }

    public Project setEc_sc39(boolean ec_sc39) {
        this.ec_sc39 = ec_sc39;
        return this;
    }

    public boolean isOa_mandate_for_publications() {
        return this.oa_mandate_for_publications;
    }

    public Project setOa_mandate_for_publications(boolean oa_mandate_for_publications) {
        this.oa_mandate_for_publications = oa_mandate_for_publications;
        return this;
    }

    public boolean isEc_article29_3() {
        return this.ec_article29_3;
    }

    public Project setEc_article29_3(boolean ec_article29_3) {
        this.ec_article29_3 = ec_article29_3;
        return this;
    }

    public String getFundingpathid() {
        return this.fundingpathid;
    }

    public Project setFundingpathid(String fundingpathid) {
        this.fundingpathid = fundingpathid;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Project setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getJurisdiction() {
        return this.jurisdiction;
    }

    public Project setJurisdiction(String jurisdiction) {
        this.jurisdiction = jurisdiction;
        return this;
    }

    public String getLegalname() {
        return this.legalname;
    }

    public Project setLegalname(String legalname) {
        this.legalname = legalname;
        return this;
    }

    public String getCountryclass() {
        return this.countryclass;
    }

    public Project setCountryclass(String countryclass) {
        this.countryclass = countryclass;
        return this;
    }

    public String getRole() {
        return this.role;
    }

    public Project setRole(String role) {
        this.role = role;
        return this;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public Project setFirstname(String firstname) {
        this.firstname = firstname;
        return this;
    }

    public String getSecondnames() {
        return this.secondnames;
    }

    public Project setSecondnames(String secondnames) {
        this.secondnames = secondnames;
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public Project setEmail(String email) {
        this.email = email;
        return this;
    }

    public String getFunder() {
        return this.funder;
    }

    public Project setFunder(String funder) {
        this.funder = funder;
        return this;
    }
}

