package eu.dnetlib.data.transform.xml;

import java.util.HashMap;
import java.util.Map;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.google.common.collect.Maps;

@SuppressWarnings("serial")
public class ValueMap extends HashMap<String, ElementList> {

	public static String IDX_ATTRIBUTE = "idx";

	public static ValueMap parseNodeList(final NodeList nodeList) {
		final ValueMap values = new ValueMap();

		for (int i = 0; i < nodeList.getLength(); i++) {
			getNodeValue(nodeList.item(i), values);
		}
		return values;
	}

	protected static void getNodeValue(final Node node, final ValueMap values) {

		final String nodeName = node.getLocalName().toLowerCase();

		final Node nodeText = node.getFirstChild();
		final Element element = nodeText != null ? new Element(nodeText.getNodeValue()) : new Element();
		final Map<String, String> attrs = Maps.newHashMap();

		final NamedNodeMap attributeList = node.getAttributes();
		for (int j = 0; j < attributeList.getLength(); j++) {
			Node attr = attributeList.item(j);
			if ((attr.getNodeValue() != null) && !attr.getNodeValue().isEmpty()) {
				attrs.put(attr.getLocalName(), attr.getNodeValue());
				if (values.containsKey(nodeName)) {
					attrs.put(IDX_ATTRIBUTE, String.valueOf(values.get(nodeName).size() + 1));
				} else {
					attrs.put(IDX_ATTRIBUTE, "1");
				}
			}
		}
		element.setAttributes(attrs);

		if (!element.isEmpty()) {
			if (!values.containsKey(nodeName)) {
				values.put(nodeName, new ElementList());
			}

			values.get(nodeName).add(element);
		}
	}

	@Override
	public ElementList get(final Object key) {
		ElementList e = super.get(key);
		return e != null ? e : new ElementList();
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("{");
		for (String k : this.keySet()) {
			sb.append(k).append("=").append(this.get(k)).append("\n");
		}
		sb.append("}");
		return sb.toString();
	}
}
