/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform;

import eu.dnetlib.data.proto.FieldTypeProtos;
import java.time.Year;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class DatePicker {
    private static final String DATE_PATTERN = "\\d{4}-\\d{2}-\\d{2}";
    private static final String DATE_DEFAULT_SUFFIX = "01-01";
    private static final int YEAR_LB = 1300;
    private static final int YEAR_UB = Year.now().getValue() + 5;

    public static FieldTypeProtos.StringField pick(Collection<String> dateofacceptance) {
        Map frequencies = dateofacceptance.parallelStream().filter(StringUtils::isNotBlank).collect(Collectors.toConcurrentMap(w -> w, w -> 1, Integer::sum));
        if (frequencies.isEmpty()) {
            return FieldTypeProtos.StringField.newBuilder().setValue("").build();
        }
        FieldTypeProtos.StringField.Builder date = FieldTypeProtos.StringField.newBuilder().setValue((String)frequencies.keySet().iterator().next());
        Map sorted = frequencies.entrySet().stream().filter(d -> StringUtils.isNotBlank((String)((String)d.getKey()))).filter(d -> ((String)d.getKey()).matches(DATE_PATTERN)).filter(d -> DatePicker.inRange((String)d.getKey())).sorted(Collections.reverseOrder(Map.Entry.comparingByValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e2, LinkedHashMap::new));
        if (sorted.size() == 0) {
            return date.build();
        }
        if (sorted.size() >= 3) {
            int acceptThreshold = sorted.size() / 3 + 1;
            List accepted = sorted.entrySet().stream().filter(e -> (Integer)e.getValue() >= acceptThreshold).map(e -> (String)e.getKey()).collect(Collectors.toList());
            if (accepted.isEmpty()) {
                int max = (Integer)sorted.values().iterator().next();
                Optional<String> first = sorted.entrySet().stream().filter(e -> (Integer)e.getValue() == max && !StringUtils.endsWith((String)((String)e.getKey()), (String)DATE_DEFAULT_SUFFIX)).map(Map.Entry::getKey).findFirst();
                if (first.isPresent()) {
                    return date.setValue(first.get()).build();
                }
                return date.setValue((String)sorted.keySet().iterator().next()).build();
            }
            if (accepted.size() == 1) {
                return date.setValue((String)accepted.get(0)).build();
            }
            Optional<String> first = accepted.stream().filter(d -> !StringUtils.endsWith((String)d, (String)DATE_DEFAULT_SUFFIX)).findFirst();
            if (first.isPresent()) {
                return date.setValue(first.get()).build();
            }
            return date.build();
        }
        if (sorted.size() == 2) {
            for (Map.Entry e3 : sorted.entrySet()) {
                if (StringUtils.endsWith((String)((String)e3.getKey()), (String)DATE_DEFAULT_SUFFIX)) continue;
                return date.setValue((String)e3.getKey()).build();
            }
        }
        return date.setValue((String)sorted.keySet().iterator().next()).build();
    }

    private static boolean inRange(String date) {
        int year = Integer.parseInt(StringUtils.substringBefore((String)date, (String)"-"));
        return year >= 1300 && year <= YEAR_UB;
    }
}

