<RESOURCE_PROFILE>
	<HEADER>
		<RESOURCE_IDENTIFIER value="db0179df-bd16-4264-84d5-46c77795516e_VHJhbnNmb3JtYXRpb25SdWxlRFNSZXNvdXJjZXMvVHJhbnNmb3JtYXRpb25SdWxlRFNSZXNvdXJjZVR5cGU="/>
		<RESOURCE_TYPE value="TransformationRuleDSResourceType"/>
		<RESOURCE_KIND value="TransformationRuleDSResources"/>
		<RESOURCE_URI value=""/>
		<DATE_OF_CREATION value="2015-02-27T17:15:30+00:00"/>
	</HEADER>
	<BODY>
		<CONFIGURATION>
			<SOURCE_METADATA_FORMAT name="dbmf" layout="store" interpretation="cleaned"/>
			<SINK_METADATA_FORMAT name="oaf_hbase"/>
			<IMPORTED/>
			<SCRIPT>
				<TITLE>xslt_mapping_resultOrganization2hbase</TITLE>
				<CODE>
					<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
					                xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:dr="http://www.driver-repository.eu/namespace/dr"
					                xmlns:dri="http://www.driver-repository.eu/namespace/dri" xmlns:oaa="http://namespace.openaire.eu/oaa"
					                xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:dnet="eu.dnetlib.data.transform.xml.DbmfToHbaseXsltFunctions"
					                version="1.0">

						<xsl:output omit-xml-declaration="yes" indent="yes"/>

						<xsl:template match="/">

							<xsl:variable name="resultId" select="//FIELD[@name = 'result']"/>
							<xsl:variable name="organizationId" select="dnet:oafSplitId('organization', //FIELD[@name = 'organization'])"/>

							<ROWS>
								<xsl:if test="string-length($resultId) &gt; 0 and string-length($organizationId) &gt; 0">

									<xsl:variable name="resultorganization"
									              select="dnet:oafRel('resultOrganization', $resultId, $organizationId, //FIELD[not(@isNull)], 'hasAuthorInstitution', 'dnet:result_organization_relations')"/>
									<xsl:variable name="organizationresult"
									              select="dnet:oafRel('resultOrganization', $organizationId, $resultId, //FIELD[not(@isNull)], 'isAuthorInstitutionOf', 'dnet:result_organization_relations')"/>

									<ROW key="{$resultId}" columnFamily="resultOrganization_affiliation_hasAuthorInstitution">
										<QUALIFIER name="{$organizationId}" type="base64">
											<xsl:value-of select="$resultorganization"/>
										</QUALIFIER>
									</ROW>
									<ROW key="{$organizationId}" columnFamily="resultOrganization_affiliation_isAuthorInstitutionOf">
										<QUALIFIER name="{$resultId}" type="base64">
											<xsl:value-of select="$organizationresult"/>
										</QUALIFIER>
									</ROW>
								</xsl:if>
							</ROWS>

						</xsl:template>

					</xsl:stylesheet>
				</CODE>
			</SCRIPT>
		</CONFIGURATION>
		<STATUS/>
		<SECURITY_PARAMETERS>SECURITY_PARAMETERS</SECURITY_PARAMETERS>
	</BODY>
</RESOURCE_PROFILE>
