<RESOURCE_PROFILE>
	<HEADER>
		<RESOURCE_IDENTIFIER value="2bc17dbe-93a9-4a4d-bd61-9831f1efdd0c_VHJhbnNmb3JtYXRpb25SdWxlRFNSZXNvdXJjZXMvVHJhbnNmb3JtYXRpb25SdWxlRFNSZXNvdXJjZVR5cGU="/>
		<RESOURCE_TYPE value="TransformationRuleDSResourceType"/>
		<RESOURCE_KIND value="TransformationRuleDSResources"/>
		<RESOURCE_URI value=""/>
		<DATE_OF_CREATION value="2016-11-21T11:15:30+00:00"/>
	</HEADER>
	<BODY>
		<CONFIGURATION>
			<IMPORTED/>
			<SCRIPT>
				<TITLE>crossref2oaf</TITLE>
				<CODE>
					<![CDATA[
   <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:dc="http://purl.org/dc/elements/1.1/"
    xmlns:dr="http://www.driver-repository.eu/namespace/dr"
    xmlns:dri="http://www.driver-repository.eu/namespace/dri"
    xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:date="http://exslt.org/dates-and-times"
    extension-element-prefixes="date" exclude-result-prefixes="xs" version="2.0">

    <xsl:output omit-xml-declaration="yes" indent="yes"/>
    <xsl:param name="varOfficialName"/>
    <xsl:param name="varDataSourceId"/>

    <xsl:template match="issn">
        <xsl:if test="not(name(parent::node()) = 'journal_metadata')">
        <xsl:choose>
            <xsl:when test=".[@media_type = 'electronic']">
                <dc:source>
                    <xsl:value-of
                        select="concat(string('eissn: '), normalize-space(.))"
                    />
                </dc:source>
            </xsl:when>
            <xsl:when test=".[@media_type = 'print' or not(@media_type)]">
                <dc:source>
                    <xsl:value-of
                        select="concat(string('issn: '), normalize-space(.))"
                    />
                </dc:source>
            </xsl:when>
        </xsl:choose>
        </xsl:if>
    </xsl:template>

    <xsl:template match="isbn">
        <xsl:if test="not(name(parent::node()) = 'journal_metadata')">
        <xsl:choose>
            <xsl:when test=".[@media_type = 'electronic']">    <dc:source>
                <xsl:value-of
                    select="concat(string('eisbn: '), normalize-space(.))"
                />
            </dc:source></xsl:when>
            <xsl:when test=".[@media_type = 'print' or not(@media_type)]">
                <dc:source>
                    <xsl:value-of
                        select="concat(string('isbn: '), normalize-space(.))"
                    />
                </dc:source>
            </xsl:when>
        </xsl:choose>
        </xsl:if>
    </xsl:template>

    <xsl:template match="publisher">
        <dc:publisher>
            <xsl:value-of select="./publisher_name"/>
        </dc:publisher>
    </xsl:template>

    <xsl:template match="/">
        <xsl:if test="not(.//error)">
            <record>
                <header>
                    <xsl:copy-of select="//*[local-name() = 'header']/*" copy-namespaces="no"/>
                    <dr:dateOfTransformation>
                        <xsl:value-of select="date:date-time()"/>
                    </dr:dateOfTransformation>
                </header>
                <metadata>
                    <dc:language>eng</dc:language>
                    <oaf:accessrights>UNKNOWN</oaf:accessrights>
                    <oaf:hostedBy id="openaire____::1256f046-bf1f-4afc-8b47-d0b147148b18"
                        name="Unknown Repository"/>
                    <oaf:collectedFrom>
                        <xsl:attribute name="name">
                            <xsl:value-of select="$varOfficialName"/>
                        </xsl:attribute>
                        <xsl:attribute name="id">
                            <xsl:value-of select="$varDataSourceId"/>
                        </xsl:attribute>
                    </oaf:collectedFrom>

                    <xsl:apply-templates select=".//*"/>
                </metadata>
                <xsl:copy-of select="//*[local-name() = 'about']/*" copy-namespaces="no"/>
            </record>
        </xsl:if>

    </xsl:template>

    <xsl:template match="dc:relation">
        <xsl:variable name="projectId"
            select="substring-after(., 'info:eu-repo/grantAgreement/EC/H2020/')"/>
        <oaf:projectid>
            <xsl:value-of select="concat('corda__h2020::', $projectId)"/>
        </oaf:projectid>
    </xsl:template>

    <xsl:template match="
            journal_article/titles/title |
            conference_paper/titles/title |
            book/content_item/titles/title |
            posted_content/titles/title">
        <dc:title>
            <xsl:value-of select="normalize-space(.)"/>
        </dc:title>
        <!-- TODO: handle subtititles if needed -->
    </xsl:template>

    <xsl:template match="book/book_metadata | book/book_series_metadata">

        <xsl:if test="not(../content_item)">
            <dc:title>
                <xsl:value-of select="normalize-space(./titles/title)"/>
            </dc:title>
         <!--   <dc:date>
                <xsl:variable name="d">
                    <xsl:value-of
                        select="string-join((./publication_date/year, ./publication_date/month, ./publication_date/day), '-')"
                    />
                </xsl:variable>
                <xsl:value-of select="$d"/>
            </dc:date> -->
            <dc:type>
                <xsl:value-of select="string('info:eu-repo/semantics/book')"/>
            </dc:type>
            <xsl:if test="./series_metadata">
                <dc:source>
                    <xsl:value-of select="./series_metadata/*/title"/>
                </dc:source>
            </xsl:if>
            <dr:CobjCategory>0002</dr:CobjCategory>
        </xsl:if>

</xsl:template>

    <xsl:template match="person_name[./@contributor_role = 'author']">
        <dc:creator>
            <xsl:if test="string-length(./ORCID)">
                <xsl:attribute name="nameIdentifierScheme">ORCID</xsl:attribute>
                <xsl:attribute name="schemeURI">http://orcid.org/</xsl:attribute>
                <xsl:attribute name="nameIdentifier">
                    <xsl:value-of select="substring-after(./ORCID, 'http://orcid.org/')"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:value-of select="concat(./surname, ', ', ./given_name)"/>
        </dc:creator>
    </xsl:template>

    <xsl:template match="publication_date | posted_date | acceptance_date">
        <xsl:variable name="d">
            <xsl:value-of select="string-join((./year, ./month, ./day), '-')"/>
        </xsl:variable>
        <xsl:if test="name(parent::node()) = 'journal_article' or
            name(parent::node()) = 'conference_paper' or
            name(parent::node()) = 'book_metadata' or
            name(parent::node()) = 'book_series_metadata' or
            name(parent::node()) = 'posted_content'">


            <dc:date>
                <xsl:value-of select="$d"/>
            </dc:date>
        </xsl:if>

    </xsl:template>

    <xsl:template match="dri:recordIdentifier">
        <dc:identifier>
            <xsl:value-of select="concat('http://dx.doi.org/', .)"/>
        </dc:identifier>
        <oaf:identifier identifierType="doi">
            <xsl:value-of select="."/>
        </oaf:identifier>
    </xsl:template>

    <xsl:template match="conference_paper">
        <dc:type>
            <xsl:value-of select="string('info:eu-repo/semantics/conferenceObject')"/>
        </dc:type>
        <dc:type>
            <xsl:value-of select="string('conference paper')"/>
        </dc:type>
        <!-- conference_paper: only source -->
        <dc:source>
            <xsl:value-of select="normalize-space(../proceedings_metadata/proceedings_title)"/>
        </dc:source>

        <dr:CobjCategory>0004</dr:CobjCategory>


    </xsl:template>

    <xsl:template match="journal_article">
        <dc:type>
            <xsl:value-of select="string('info:eu-repo/semantics/article')"/>
        </dc:type>
        <dc:type>
            <xsl:value-of select="string('journal article')"/>
        </dc:type>

        <dr:CobjCategory>0001</dr:CobjCategory>
        <oaf:journal eissn="{../journal_metadata/issn[@media_type='electronic']}"
            issn="{../journal_metadata/issn[@media_type='print' or not(@media_type)]}"
            iss="{../journal_issue/issue}" vol="{../journal_issue/journal_volume/volume}"
            sp="{./pages/first_page}" ep="{./pages/last_page}">
            <xsl:value-of select="normalize-space(../journal_metadata/full_title)"/>
        </oaf:journal>
    </xsl:template>

    <xsl:template match="content_item">
        <dc:type>
            <xsl:value-of select="string('info:eu-repo/semantics/bookPart')"/>
        </dc:type>
        <dc:type>
            <xsl:value-of select="./@component_type"/>
        </dc:type>
        <xsl:choose>
            <xsl:when test="../book_series_metadata">
                <dc:source>
                    <xsl:value-of select="concat(normalize-space(../book_series_metadata/series_metadata/*/title), ' - ', normalize-space(../book_series_metadata/titles/title))"/>
                </dc:source>
            </xsl:when>
            <xsl:when test="../book_metadata">
                <dc:source>
                    <xsl:value-of select="normalize-space(../book_metadata/*/title)"/>
                </dc:source>
            </xsl:when>
            </xsl:choose>
        <dr:CobjCategory>0013</dr:CobjCategory>

    </xsl:template>

    <xsl:template match="posted_content">
        <xsl:variable name="type">
            <xsl:value-of select="./@type"/>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="normalize-space($type) = 'preprint'">
                <dc:type>
                    <xsl:value-of select="string('info:eu-repo/semantics/preprint')"/>
                </dc:type>
                <dr:CobjCategory>0016</dr:CobjCategory>
            </xsl:when>
            <xsl:when test="normalize-space($type) = 'working_paper'">
                <dc:type>
                    <xsl:value-of select="string('info:eu-repo/semantics/workingPaper')"/>
                </dc:type>
            </xsl:when>
            <xsl:when test="normalize-space($type) = 'report'">
                <dc:type>
                    <xsl:value-of select="string('info:eu-repo/semantics/report')"/>
                </dc:type>
            </xsl:when>
            <xsl:otherwise>
                <dc:type>
                    <xsl:value-of select="string('info:eu-repo/semantics/other')"/>
                </dc:type>

            </xsl:otherwise>

        </xsl:choose>
        <dc:source>
            <xsl:value-of
                select="concat(normalize-space(.//institution_name), ' - ', normalize-space(./item_number))"
            />
        </dc:source>
        <xsl:if test="not(normalize-space($type) = 'preprint')">
            <dr:CobjCategory>0020</dr:CobjCategory>
        </xsl:if>

    </xsl:template>

    <!-- Extend with new templates for additional types of publication     -->

    <xsl:template match="* | @*"/>

</xsl:stylesheet>

]]>
				</CODE>
			</SCRIPT>
		</CONFIGURATION>
		<STATUS/>
		<SECURITY_PARAMETERS>SECURITY_PARAMETERS</SECURITY_PARAMETERS>
	</BODY>
</RESOURCE_PROFILE>
