<RESOURCE_PROFILE>
	<HEADER>
		<RESOURCE_IDENTIFIER value="2bc17dbe-93a9-4a4d-bd61-9831f1efdd0c_VHJhbnNmb3JtYXRpb25SdWxlRFNSZXNvdXJjZXMvVHJhbnNmb3JtYXRpb25SdWxlRFNSZXNvdXJjZVR5cGU="/>
		<RESOURCE_TYPE value="TransformationRuleDSResourceType"/>
		<RESOURCE_KIND value="TransformationRuleDSResources"/>
		<RESOURCE_URI value=""/>
		<DATE_OF_CREATION value="2016-11-21T11:15:30+00:00"/>
	</HEADER>
	<BODY>
		<CONFIGURATION>
			<IMPORTED/>
			<SCRIPT>
				<TITLE>crossref2oaf</TITLE>
				<CODE>
					<![CDATA[

   <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:dc="http://purl.org/dc/elements/1.1/"
    xmlns:dr="http://www.driver-repository.eu/namespace/dr"
    xmlns:dri="http://www.driver-repository.eu/namespace/dri"
    xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:date="http://exslt.org/dates-and-times"
xmlns:TransformationFunction="eu.dnetlib.data.collective.transformation.core.xsl.ext.TransformationFunctionProxy"
    extension-element-prefixes="date TransformationFunction"
    exclude-result-prefixes="xs TransformationFunction" version="2.0" >


    <xsl:output omit-xml-declaration="yes" indent="yes"/>
    <xsl:param name="varOfficialName"/>
    <xsl:param name="varDataSourceId"/>
    <xsl:variable name="tf" select="TransformationFunction:getInstance()"/>

<xsl:variable name="fundCodes">
       <codes>
              <code key="DFG"   nspPre="dfgf________"    names="(Deutsche Forschungsgemeinschaft|DFG)" dois="(10.13039/501100001659)" prjs=""/>
              <code key="FP7"    nspPre="corda_______"  names="(Seventh Framework Program|FP7)" dois="(10.13039/100011102)" prjs="\d{6}"/>
       </codes>
</xsl:variable>

<xsl:key name="fundCodesByNames" match="code" use="string(@names)"/>
<xsl:key name="fundCodesByDois" match="code" use="string(@dois)"/>

<!-- review status indicated not via resource type by via assertions or relations -->
<xsl:variable name="varRefereedAssRel" select="(//crossmark/custom_metadata/assertion/@name[. = 'peerreview_statement']/'0001',
                                                   //program/related_item/intra_work_relation/@relationship-type[. = 'isPreprintOf']/'0002')"/>


    <xsl:template name="terminate">
        <xsl:message terminate="yes">
            record is not compliant, transformation is interrupted.
        </xsl:message>
    </xsl:template>

    <xsl:template match="issn">
        <xsl:if test="not(name(parent::node()) = 'journal_metadata')">
        <xsl:choose>
            <xsl:when test=".[@media_type = 'electronic']">
                <dc:source>
                    <xsl:value-of
                        select="concat(string('eissn: '), normalize-space(.))"
                    />
                </dc:source>
            </xsl:when>
            <xsl:when test=".[@media_type = 'print' or not(@media_type)]">
                <dc:source>
                    <xsl:value-of
                        select="concat(string('issn: '), normalize-space(.))"
                    />
                </dc:source>
            </xsl:when>
        </xsl:choose>
        </xsl:if>
    </xsl:template>

    <xsl:template match="isbn">
        <xsl:if test="not(name(parent::node()) = 'journal_metadata')">
        <xsl:choose>
            <xsl:when test=".[@media_type = 'electronic']">    <dc:source>
                <xsl:value-of
                    select="concat(string('eisbn: '), normalize-space(.))"
                />
            </dc:source></xsl:when>
            <xsl:when test=".[@media_type = 'print' or not(@media_type)]">
                <dc:source>
                    <xsl:value-of
                        select="concat(string('isbn: '), normalize-space(.))"
                    />
                </dc:source>
            </xsl:when>
        </xsl:choose>
        </xsl:if>
    </xsl:template>

    <xsl:template match="publisher">
        <dc:publisher>
            <xsl:value-of select="./publisher_name"/>
        </dc:publisher>
    </xsl:template>

    <xsl:template match="/">
        <xsl:if test="not(.//error)">
            <record>
                <header>
                    <xsl:copy-of select="//*[local-name() = 'header']/*" copy-namespaces="no"/>
                    <dr:dateOfTransformation>
                        <xsl:value-of select="date:date-time()"/>
                    </dr:dateOfTransformation>
                </header>
                <metadata>

<xsl:if test="not(//(journal_article, conference_paper, book/content_item, book[not(./content_item)]/book_series_metadata/series_metadata, book[not(./content_item)]/book_metadata, posted_content, report-paper/report-paper_metadata, dissertation, database/dataset, sa_component/component_list/component)/titles/title[string-length(normalize-space(.))> 0]) and not(//*[local-name()='conference_paper']/*[local-name()='titles']/*[local-name()='title'][string-length(normalize-space(.))> 0])">
                                                         <xsl:call-template name="terminate"/>
</xsl:if>

                    <dc:language>eng</dc:language>
                    <xsl:call-template name="accessrights"/>
                    <oaf:hostedBy id="openaire____::1256f046-bf1f-4afc-8b47-d0b147148b18"
                        name="Unknown Repository"/>
                    <oaf:collectedFrom>
                        <xsl:attribute name="name">
                            <xsl:value-of select="$varOfficialName"/>
                        </xsl:attribute>
                        <xsl:attribute name="id">
                            <xsl:value-of select="$varDataSourceId"/>
                        </xsl:attribute>
                    </oaf:collectedFrom>

<xsl:if test="not(//posted_content)">
<xsl:choose>
     <xsl:when test="count($varRefereedAssRel[. = '0001']) > 0">
          <oaf:refereed>
               <xsl:value-of select="'0001'"/>
          </oaf:refereed>
     </xsl:when>
     <xsl:when test="count($varRefereedAssRel[. = '0002']) > 0">
               <oaf:refereed>
                    <xsl:value-of select="'0002'"/>
               </oaf:refereed>
     </xsl:when>
</xsl:choose>
</xsl:if>

                    <xsl:apply-templates select=".//*"/>

<!--
<xsl:call-template name="CatType"/>
-->

                </metadata>
                <xsl:copy-of select="//*[local-name() = 'about']/*" copy-namespaces="no"/>
            </record>
        </xsl:if>

    </xsl:template>

<!-- funding -->
<xsl:template match="*[local-name()='relation'][starts-with(., 'info:eu-repo/grantAgreement/')] | assertion[./@name='fundgroup']">

<xsl:variable name="varFP7" select="'corda_______::'"/>
<xsl:variable name="varH2020" select="'corda__h2020::'"/>
<xsl:variable name="varAKA" select="'aka_________::'"/>
<!-- <xsl:variable name="varAFF" select="'aff_________::'"/>  old namespace prefix for Academy of Finland. The new nsp is aka_________ -->
<xsl:variable name="varARC" select="'arc_________::'"/>
<xsl:variable name="varCONICYT" select="'conicytf____::'"/>
<xsl:variable name="varDFG" select="'dfgf________::'"/>
<xsl:variable name="varFCT" select="'fct_________::'"/>
<xsl:variable name="varFWF" select="'fwf_________::'"/>
<xsl:variable name="varHRZZ" select="'irb_hr______::'"/>
<xsl:variable name="varMESTD" select="'mestd_______::'"/>
<xsl:variable name="varMIUR" select="'miur________::'"/>     <!-- tbd, no statements yet -->
<xsl:variable name="varMZOS" select="'irb_hr______::'"/>
<xsl:variable name="varNHMRC" select="'nhmrc_______::'"/>
<xsl:variable name="varNIH" select="'nih_________::'"/>
<xsl:variable name="varNSF" select="'nsf_________::'"/>
<xsl:variable name="varNWO" select="'nwo_________::'"/>
<xsl:variable name="varUKRI" select="'ukri________::'"/>
<xsl:variable name="varSFI" select="'sfi_________::'"/>
<xsl:variable name="varSGOV" select="'sgov________::'"/>
<xsl:variable name="varSNSF" select="'snsf________::'"/>
<xsl:variable name="varTARA" select="'taraexp_____::'"/>
<xsl:variable name="varTUBITAK" select="'tubitakf____::'"/>
<xsl:variable name="varWT" select="'wt__________::'"/>

<xsl:for-each select=".[local-name()='relation'][starts-with(., 'info:eu-repo/grantAgreement/EC/H2020')]">
        <xsl:variable name="projectId"       select="substring-after(., 'info:eu-repo/grantAgreement/EC/H2020/')"/>
        <oaf:projectid>     <xsl:value-of select="concat($varH2020, $projectId)"/>       </oaf:projectid>
</xsl:for-each>

<!-- EU FP7 -->
<xsl:for-each select=".[local-name()='assertion' and ./@name='fundgroup'][.//assertion[./@name='funder_identifier' and ends-with(., '10.13039/100011102')] or ./assertion[./@name='funder_name' and (contains(., 'Seventh Framework Program') or contains(., 'FP7'))]]/assertion[./@name='award_number']">
        <xsl:variable name="projectId"       select="."/>
        <oaf:projectid>     <xsl:value-of select="concat($varFP7, $projectId)"/>       </oaf:projectid>
</xsl:for-each>

<!-- Changed the NSP it is AKA and not AFF -->
<!-- AKA -->
<xsl:for-each select=".[local-name()='assertion' and ./@name='fundgroup'][.//assertion[./@name='funder_identifier' and ends-with(., '10.13039/501100002341')] or ./assertion[./@name='funder_name' and (contains(., 'Suomen Akatemia') or contains(., 'Academy of Finland'))]]/assertion[./@name='award_number']">
        <xsl:variable name="projectId"       select="."/>
        <oaf:projectid>     <xsl:value-of select="concat($varAKA, $projectId)"/>       </oaf:projectid>
</xsl:for-each>

<!-- ARC -->
<xsl:for-each select=".[local-name()='assertion' and ./@name='fundgroup'][.//assertion[./@name='funder_identifier' and ends-with(., '10.13039/501100000923')] or ./assertion[./@name='funder_name' and contains(., 'Australian Research Council')]]/assertion[./@name='award_number']">
        <xsl:variable name="projectId"       select="."/>
        <oaf:projectid>     <xsl:value-of select="concat($varARC, $projectId)"/>       </oaf:projectid>
</xsl:for-each>

<!-- CONICYT -->
<xsl:for-each select=".[local-name()='assertion' and ./@name='fundgroup'][.//assertion[./@name='funder_identifier' and ends-with(., '10.13039/501100002848')] or ./assertion[./@name='funder_name' and (contains(., 'Comisión Nacional de Investigación Científica y Tecnológica') or contains(., 'CONICYT'))]]/assertion[./@name='award_number']">
        <xsl:variable name="projectId"       select="."/>
        <oaf:projectid>     <xsl:value-of select="concat($varCONICYT, $projectId)"/>       </oaf:projectid>
</xsl:for-each>

<!-- DFG -->
<xsl:for-each select=".[local-name()='assertion' and ./@name='fundgroup'][.//assertion[./@name='funder_identifier' and ends-with(., '10.13039/501100001659')] or ./assertion[./@name='funder_name' and (contains(., 'Deutsche Forschungsgemeinschaft') or contains(., 'DFG'))]]/assertion[./@name='award_number']">
        <xsl:variable name="projectId"       select="."/>
        <oaf:projectid>     <xsl:value-of select="concat($varDFG, $projectId)"/>       </oaf:projectid>
</xsl:for-each>

<!-- UKRI -->
<xsl:for-each select=".[local-name()='assertion' and ./@name='fundgroup'][.//assertion[./@name='funder_identifier' and ends-with(., '10.13039/501100000690')] or ./assertion[./@name='funder_name' and (contains(., 'Research Councils UK') or contains(., 'RCUK'))]]/assertion[./@name='award_number']  or substring-after(normalize-space(./*[local-name()='funderIdentifier']), 'doi.org/') = ('10.13039/100014013') or contains(./*[local-name()='funderName'], 'UKRI'), contains(./*[local-name()='funderName'], 'UK Research and Innovation')">
        <xsl:variable name="projectId"       select="."/>
        <oaf:projectid>     <xsl:value-of select="concat($varUKRI, $projectId)"/>       </oaf:projectid>
</xsl:for-each>

<!-- SGOV -->
<xsl:for-each select=".[local-name()='assertion' and ./@name='fundgroup'][./assertion[./@name='funder_name' and (contains(., 'Gobierno de Espana') or contains(., 'Ministry of Economy and Competitiveness') or contains(., 'Ministerio de Economía y Competitividad'))]]/assertion[./@name='award_number']">
        <xsl:variable name="projectId"       select="."/>
        <oaf:projectid>     <xsl:value-of select="concat($varSGOV, $projectId)"/>       </oaf:projectid>
</xsl:for-each>

<!-- SNSF -->
<xsl:for-each select=".[local-name()='assertion' and ./@name='fundgroup'][.//assertion[./@name='funder_identifier' and ends-with(., '10.13039/501100001711')] or ./assertion[./@name='funder_name' and (contains(., 'Swiss National Science Foundation') or contains(., 'Schweizerischer Nationalfonds zur Förderung der Wissenschaftlichen Forschung'))]]/assertion[./@name='award_number']">
        <xsl:variable name="projectId"       select="."/>
        <oaf:projectid>     <xsl:value-of select="concat($varSNSF, $projectId)"/>       </oaf:projectid>
</xsl:for-each>

<!-- TUBITAK -->
<xsl:for-each select=".[local-name()='assertion' and ./@name='fundgroup'][.//assertion[./@name='funder_identifier' and ends-with(., '10.13039/501100004410')] or ./assertion[./@name='funder_name' and (contains(., 'Turkish National Science and Research Council') or (contains(., 'Türkiye Bilimsel ve Teknolojik Ara') and contains(., 'rma Kurumu')))]]/assertion[./@name='award_number']">
        <xsl:variable name="projectId"       select="."/>
        <oaf:projectid>     <xsl:value-of select="concat($varTUBITAK, $projectId)"/>       </oaf:projectid>
</xsl:for-each>


    </xsl:template>

    <xsl:template match="
            journal_article/titles/title |
            conference_paper/titles/title |
            book/content_item/titles/title |
            posted_content/titles/title |
            report-paper/report-paper_metadata/titles/title |
            dissertation/titles/title |
            database/dataset/titles/title |
            sa_component/component_list/component/titles/title">
        <dc:title>
            <xsl:value-of select="normalize-space(.)"/>
        </dc:title>
<!-- MODIFIED TO MAKE IT WORK WHEN MORE THAN ONE SUBTITLE ELEMENT EXIST -->
<xsl:for-each select="../subtitle">
        <dc:title>
            <xsl:value-of select="normalize-space(.)"/>
        </dc:title>
       </xsl:for-each>
<!-- OLD CODE
       <xsl:if test="../subtitle[string-length(.) > 0]">
        <dc:title>
            <xsl:value-of select="normalize-space(../subtitle)"/>
        </dc:title>
       </xsl:if>
--><!-- END MODIFICATION -->
        <!-- TODO: handle subtitles if needed -->
    </xsl:template>

<!-- Modified the template match. There was a clash with another template done specifically for book_series_metadata
    <xsl:template match="book/book_metadata | book/book_series_metadata">-->
<xsl:template match="book/book_metadata">
        <xsl:if test="not(../content_item)">
            <dc:title>
                <xsl:value-of select="normalize-space(./titles/title)"/>
            </dc:title>
<!-- START SAME MOD DONE BEFORE
       <xsl:if test="./titles/subtitle[string-length(.) > 0]">
        <dc:title>
            <xsl:value-of select="normalize-space(./titles/subtitle[string-length(.) > 0])"/>
        </dc:title>
       </xsl:if> -->

<xsl:for-each select="../subtitle">
        <dc:title>
            <xsl:value-of select="normalize-space(.)"/>
        </dc:title>
       </xsl:for-each>

<!-- END -->
         <!--   <dc:date>
                <xsl:variable name="d">
                    <xsl:value-of
                        select="string-join((./publication_date/year, ./publication_date/month, ./publication_date/day), '-')"
                    />
                </xsl:variable>
                <xsl:value-of select="$d"/>
            </dc:date> -->
            <xsl:variable name="varType" select="string('info:eu-repo/semantics/book')"/>
            <dc:type>
                <xsl:value-of select="$varType"/>
            </dc:type>
<!-- The following part is copied where the series metadata template is -->
            <xsl:if test="./series_metadata">
                <dc:source>
                    <xsl:value-of select="./series_metadata/*/title"/>
                </dc:source>
            </xsl:if>
<xsl:variable name='varCobjCategory' select="TransformationFunction:convertString($tf, $varType, 'TextTypologies')" />
<xsl:variable name='varSuperType' select="TransformationFunction:convertString($tf, $varCobjCategory, 'SuperTypes')" />
<dr:CobjCategory>
          <xsl:attribute name="type" select="$varSuperType"/>
          <xsl:value-of select="$varCobjCategory" />
</dr:CobjCategory>
        </xsl:if>

</xsl:template>

    <xsl:template match="person_name[./@contributor_role = 'author']">
        <dc:creator>
            <xsl:if test="string-length(./ORCID)">
                <xsl:attribute name="nameIdentifierScheme">ORCID</xsl:attribute>
                <xsl:attribute name="schemeURI">http://orcid.org/</xsl:attribute>
                <xsl:attribute name="nameIdentifier">
                    <xsl:value-of select="substring-after(./ORCID, 'http://orcid.org/')"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:value-of select="concat(./surname, ', ', ./given_name)"/>
        </dc:creator>
    </xsl:template>

    <xsl:template match="publication_date | posted_date | acceptance_date | approval_date">
        <xsl:variable name="d">
            <xsl:value-of select="string-join((./year, ./month, ./day), '-')"/>
        </xsl:variable>
        <xsl:if test="name(parent::node()) = 'journal_article' or
            name(parent::node()) = 'conference_paper' or
            name(parent::node()) = 'book_metadata' or
            name(parent::node()) = 'book_series_metadata' or
            name(parent::node()) = 'posted_content' or
            name(parent::node()) = 'dissertation' or
            name(parent::node()) = 'report-paper_metadata'">
            <dc:date>
                <xsl:value-of select="$d"/>
            </dc:date>
        </xsl:if>

    </xsl:template>

    <xsl:template match="dri:recordIdentifier">
        <dc:identifier>
            <xsl:value-of select="concat('http://dx.doi.org/', .)"/>
        </dc:identifier>
        <oaf:identifier identifierType="doi">
            <xsl:value-of select="."/>
        </oaf:identifier>
    </xsl:template>

    <xsl:template match="conference_paper">
            <xsl:variable name="varType" select="string('info:eu-repo/semantics/conferenceObject')"/>
        <dc:type>
            <xsl:value-of select="$varType"/>
        </dc:type>
        <dc:type>
            <xsl:value-of select="string('conference paper')"/>
        </dc:type>
        <!-- conference_paper: only source -->
        <dc:source>
            <xsl:value-of select="normalize-space(../proceedings_metadata/proceedings_title)"/>
        </dc:source>
<xsl:variable name='varCobjCategory' select="TransformationFunction:convertString($tf, $varType, 'TextTypologies')" />
<xsl:variable name='varSuperType' select="TransformationFunction:convertString($tf, $varCobjCategory, 'SuperTypes')" />
<dr:CobjCategory>
          <xsl:attribute name="type" select="$varSuperType"/>
          <xsl:value-of select="$varCobjCategory" />
</dr:CobjCategory>
    </xsl:template>

    <xsl:template match="journal_article">
            <xsl:variable name="varType" select="string('info:eu-repo/semantics/article')"/>
        <dc:type>
            <xsl:value-of select="$varType"/>
        </dc:type>
        <dc:type>
            <xsl:value-of select="string('journal article')"/>
        </dc:type>
<xsl:variable name='varCobjCategory' select="TransformationFunction:convertString($tf, $varType, 'TextTypologies')" />
<xsl:variable name='varSuperType' select="TransformationFunction:convertString($tf, $varCobjCategory, 'SuperTypes')" />
<dr:CobjCategory>
          <xsl:attribute name="type" select="$varSuperType"/>
          <xsl:value-of select="$varCobjCategory" />
</dr:CobjCategory>

        <oaf:journal eissn="{../journal_metadata/issn[@media_type='electronic']}"
            issn="{../journal_metadata/issn[@media_type='print' or not(@media_type)]}"
            iss="{../journal_issue/issue}" vol="{../journal_issue/journal_volume/volume}"
            sp="{./pages/first_page}" ep="{./pages/last_page}">
            <xsl:value-of select="normalize-space(../journal_metadata/full_title[1])"/>
        </oaf:journal>
    </xsl:template>

    <xsl:template match="content_item">
            <xsl:variable name="varType" select="./@component_type"/>
        <dc:type>
            <xsl:value-of select="string('info:eu-repo/semantics/bookPart')"/>
        </dc:type>
        <dc:type>
            <xsl:value-of select="$varType"/>
        </dc:type>
        <xsl:choose>
            <xsl:when test="../book_series_metadata">
                <dc:source>
                    <xsl:value-of select="concat(normalize-space(../book_series_metadata/series_metadata/*/title), ' - ', normalize-space(../book_series_metadata/titles/title))"/>
                </dc:source>
            </xsl:when>
            <xsl:when test="../book_metadata">
                <dc:source>
                    <xsl:value-of select="normalize-space(../book_metadata/*/title)"/>
                </dc:source>
            </xsl:when>
            </xsl:choose>
<xsl:variable name='varCobjCategory' select="TransformationFunction:convertString($tf, $varType, 'TextTypologies')" />
<xsl:variable name='varSuperType' select="TransformationFunction:convertString($tf, $varCobjCategory, 'SuperTypes')" />
<dr:CobjCategory>
          <xsl:attribute name="type" select="$varSuperType"/>
          <xsl:value-of select="$varCobjCategory" />
</dr:CobjCategory>
    </xsl:template>

    <xsl:template match="book/book_series_metadata">
        <xsl:if test="not(../content_item)">
            <dc:title>
                <xsl:value-of select="concat(normalize-space(./series_metadata/*/title),' ' , normalize-space(./titles/title))"/>
            </dc:title>
       <xsl:if test="./titles/subtitle[string-length(.) > 0]">
        <dc:title>
            <xsl:value-of select="normalize-space(./titles/subtitle[string-length(.) > 0])"/>
        </dc:title>
       </xsl:if>
            <xsl:variable name="varType" select="string('info:eu-repo/semantics/book')"/>
            <dc:type>
                <xsl:value-of select="$varType"/>
            </dc:type>
<xsl:variable name='varCobjCategory' select="TransformationFunction:convertString($tf, $varType, 'TextTypologies')" />
<xsl:variable name='varSuperType' select="TransformationFunction:convertString($tf, $varCobjCategory, 'SuperTypes')" />
<dr:CobjCategory>
          <xsl:attribute name="type" select="$varSuperType"/>
          <xsl:value-of select="$varCobjCategory" />
</dr:CobjCategory>
            <dc:date>
                <xsl:variable name="d">
                    <xsl:value-of select="string-join((./publication_date/year, ./publication_date/month, ./publication_date/day), '-')"/>
                </xsl:variable>
                <xsl:value-of select="$d"/>
            </dc:date>
        </xsl:if>
        <xsl:if test=".//publisher">
            <dc:publisher>
                <xsl:value-of select="./publisher/publisher_name"/>
            </dc:publisher>
        </xsl:if>
<xsl:if test="./series_metadata">
                <dc:source>
                    <xsl:value-of select="./series_metadata/*/title"/>
                </dc:source>
            </xsl:if>
    </xsl:template>


    <xsl:template match="posted_content">
 <!--
        <xsl:variable name="type">
            <xsl:value-of select="./@type"/>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="normalize-space($type) = 'preprint'">
            <xsl:variable name="varType" select="string('info:eu-repo/semantics/preprint')"/>
                <dc:type>
                    <xsl:value-of select="$varType"/>
                </dc:type>
            </xsl:when>
            <xsl:when test="normalize-space($type) = 'working_paper'">
            <xsl:variable name="varType" select="string('info:eu-repo/semantics/workingPaper')"/>
                <dc:type>
                    <xsl:value-of select="$varType"/>
                </dc:type>
            </xsl:when>
            <xsl:when test="normalize-space($type) = 'report'">
            <xsl:variable name="varType" select="string('info:eu-repo/semantics/report')"/>
                <dc:type>
                    <xsl:value-of select="$varType"/>
                </dc:type>
            </xsl:when>
            <xsl:otherwise>
            <xsl:variable name="varType" select="string('info:eu-repo/semantics/other')"/>
                <dc:type>
                    <xsl:value-of select="$varType"/>
                </dc:type>
            </xsl:otherwise>
        </xsl:choose>
-->

            <xsl:variable name="varType" select="./@type[.='preprint']/'info:eu-repo/semantics/preprint',
                                                                                     ./@type[.='working_paper']/'info:eu-repo/semantics/workingPaper',
                                                                                     ./@type[.='report']/'info:eu-repo/semantics/report',
                                                                                     ./@type[not(.=('preprint', 'working_paper', 'report'))]/'info:eu-repo/semantics/other'"/>
                <dc:type>
                    <xsl:value-of select="$varType"/>
                </dc:type>
        <dc:source>
            <xsl:value-of
                select="concat(normalize-space(.//institution_name), ' - ', normalize-space(./item_number))"
            />
        </dc:source>


<xsl:variable name="varCobjCategory" select="TransformationFunction:convertString($tf, $varType, 'TextTypologies')" />
<xsl:variable name="varSuperType" select="TransformationFunction:convertString($tf, $varCobjCategory, 'SuperTypes')" />
<dr:CobjCategory>
          <xsl:attribute name="type" select="$varSuperType"/>
          <xsl:value-of select="$varCobjCategory" />
</dr:CobjCategory>

 <!--
        <xsl:if test="not(normalize-space($type) = 'preprint')">
        </xsl:if>
-->

<!-- review status -->
<xsl:variable name="varRefereedTyp" select="for $i in ($varType) return TransformationFunction:convertString($tf, normalize-space($i), 'ReviewLevels')"/>
<xsl:variable name="varRefereed" select="($varRefereedAssRel, $varRefereedTyp)"/>
<xsl:choose>
     <xsl:when test="count($varRefereed[. = '0001']) > 0">
          <oaf:refereed>
               <xsl:value-of select="'0001'"/>
          </oaf:refereed>
     </xsl:when>
     <xsl:when test="count($varRefereed[. = '0002']) > 0 or ./program/related_item/intra_work_relation/@relationship-type = 'isPreprintOf'">
               <oaf:refereed>
                    <xsl:value-of select="'0002'"/>
               </oaf:refereed>
     </xsl:when>
</xsl:choose>


    </xsl:template>

 <!-- sa_components seem to be supplements, but unfortunately don't state, what pertain to (no second PID)  -->
    <xsl:template match="sa_component">
            <xsl:variable name="varType" select="string('text')"/>
        <dc:type>
            <xsl:value-of select="$varType"/>
        </dc:type>
<xsl:variable name="varCobjCategory" select="TransformationFunction:convertString($tf, $varType, 'TextTypologies')" />
<xsl:variable name='varSuperType' select="TransformationFunction:convertString($tf, $varCobjCategory, 'SuperTypes')" />
<dr:CobjCategory>
          <xsl:attribute name="type" select="$varSuperType"/>
          <xsl:value-of select="$varCobjCategory" />
</dr:CobjCategory>
    </xsl:template>

    <xsl:template match="report-paper">
            <xsl:variable name="varType" select="string('info:eu-repo/semantics/report')"/>
        <dc:type>
            <xsl:value-of select="$varType"/>
        </dc:type>
<xsl:variable name="varCobjCategory" select="TransformationFunction:convertString($tf, $varType, 'TextTypologies')" />
<xsl:variable name='varSuperType' select="TransformationFunction:convertString($tf, $varCobjCategory, 'SuperTypes')" />
<dr:CobjCategory>
          <xsl:attribute name="type" select="$varSuperType"/>
          <xsl:value-of select="$varCobjCategory" />
</dr:CobjCategory>
    </xsl:template>

    <xsl:template match="dissertation">
            <xsl:variable name="varType" select="string('info:eu-repo/semantics/doctoralThesis')"/>
        <dc:type>
            <xsl:value-of select="$varType"/>
        </dc:type>
<xsl:variable name="varCobjCategory" select="TransformationFunction:convertString($tf, $varType, 'TextTypologies')" />
<xsl:variable name='varSuperType' select="TransformationFunction:convertString($tf, $varCobjCategory, 'SuperTypes')" />
<dr:CobjCategory>
          <xsl:attribute name="type" select="$varSuperType"/>
          <xsl:value-of select="$varCobjCategory" />
</dr:CobjCategory>
    </xsl:template>

 <!-- databases seem to be bibliographies  -->
    <xsl:template match="database">
            <xsl:variable name="varType" select="string('bibliography')"/>
        <dc:type>
            <xsl:value-of select="$varType"/>
        </dc:type>
<xsl:variable name="varCobjCategory" select="TransformationFunction:convertString($tf, $varType, 'TextTypologies')" />
<xsl:variable name='varSuperType' select="TransformationFunction:convertString($tf, $varCobjCategory, 'SuperTypes')" />
<dr:CobjCategory>
          <xsl:attribute name="type" select="$varSuperType"/>
          <xsl:value-of select="$varCobjCategory" />
</dr:CobjCategory>
        <dc:source>
            <xsl:value-of select="normalize-space(./database_metadata/titles/title)"/>
        </dc:source>
    </xsl:template>

    <!-- Extend with new templates for additional types of publication     -->


<!-- oaf:accessrights -->
<xsl:template name="accessrights">

       <xsl:choose>
              <xsl:when test="//program[./@name = 'AccessIndicators']/(license_ref[./@applies_to='vor' or not(./@applies_to)][contains(., '://creativecommons.org/licenses/by')], free_to_read)">
                     <xsl:variable name="varEmbargoEnd">
                            <xsl:value-of select="max(//program[./@name = 'AccessIndicators']/(license_ref[./@applies_to='vor' or not(./@applies_to)][contains(., '://creativecommons.org/licenses/by')], free_to_read)/@start_date/string(.))"/>
                     </xsl:variable>
                     <xsl:if test="xs:date( max(( string($varEmbargoEnd), '0001-01-01' ) ) ) gt current-date()">
                            <oaf:accessrights>
                                   <xsl:value-of select="'EMBARGO'" />
                            </oaf:accessrights>
                     </xsl:if>
                     <xsl:if test="$varEmbargoEnd and not((xs:date( max( (string($varEmbargoEnd), '0001-01-01') ) ) gt current-date()))">
                            <oaf:accessrights>
                                   <xsl:value-of select="'OPEN'" />
                            </oaf:accessrights>
                     </xsl:if>
              </xsl:when>
              <xsl:otherwise>
                     <oaf:accessrights>
                            <xsl:value-of select="'UNKNOWN'"/>
                     </oaf:accessrights>
              </xsl:otherwise>
       </xsl:choose>

       <xsl:for-each select="//program[./@name = 'AccessIndicators']/(license_ref[not(./@applies_to = 'am') or not(./@applies_to)], free_to_read)">
              <xsl:if test="string-length(.)">
                     <oaf:license>
                            <xsl:value-of select="." />
                     </oaf:license>
              </xsl:if>
              <xsl:if test="./@start_date">
                     <dc:date>
                            <xsl:value-of select="concat('info:eu-repo/date/embargoEnd/', ./@start_date)"/>
                     </dc:date>
              </xsl:if>
       </xsl:for-each>

</xsl:template>

<xsl:template name="CatType">
<!--
<xsl:template match="journal_article | conference_paper | book/content_item | posted_content/type | report-paper | dissertation | database | sa_component">
          <xsl:variable name="varCobjCatTmp" select="TransformationFunction:convertString($tf, local-name(.), 'TextTypologies')" />
-->
          <xsl:variable name="varCobjCatTmp" select="TransformationFunction:convertString($tf, (//journal_article/local-name(), //conference_paper/local-name(), //book/content_item/'0013', //posted_content/@type), 'TextTypologies')" />
          <xsl:variable name="varCobjCategory" select="$varCobjCatTmp[string-length($varCobjCatTmp) > 0], '0020'[string-length($varCobjCatTmp) = 0]" />
          <xsl:variable name="varSuperType" select="TransformationFunction:convertString($tf, $varCobjCategory, 'SuperTypes')" />
          <dr:CobjCategory>
                    <xsl:attribute name="type" select="$varSuperType"/>
                    <xsl:value-of select="$varCobjCategory" />
          </dr:CobjCategory>
</xsl:template>

    <xsl:template match="* | @*"/>

</xsl:stylesheet>


]]>
				</CODE>
			</SCRIPT>
		</CONFIGURATION>
		<STATUS/>
		<SECURITY_PARAMETERS>SECURITY_PARAMETERS</SECURITY_PARAMETERS>
	</BODY>
</RESOURCE_PROFILE>
