package eu.dnetlib.msro.openaireplus.workflows.nodes.claims;

import java.util.List;

import eu.dnetlib.enabling.database.DataSourceFactory;
import eu.dnetlib.enabling.database.utils.JdbcTemplateFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * Created by Alessia Bardi on 23/06/2017.
 *
 * @author Alessia Bardi
 */
@Component
public class ClaimDatabaseUtils {

	@Autowired
	private JdbcTemplateFactory claimsJdbcTemplateFactory;
	@Autowired
	private DataSourceFactory claimsDataSourceFactory;

	@Value("${dnet.openaire.claims.db.name}")
	private String dbName;

	public List<Claim> query(final String sqlQuery) {
		this.claimsJdbcTemplateFactory.setDataSourceFactory(claimsDataSourceFactory);
		return this.claimsJdbcTemplateFactory.createJdbcTemplate(dbName).query(sqlQuery,
				(rs, rowNum) -> new Claim().setSemantics(rs.getString("semantics"))
						.setSource(rs.getString("source_id")).setSourceType(rs.getString("source_type"))
						.setTarget(rs.getString("target_id")).setTargetType(rs.getString("target_type")));
	}

	public int count(final String sqlCountQuery) {
		this.claimsJdbcTemplateFactory.setDataSourceFactory(claimsDataSourceFactory);
		return this.claimsJdbcTemplateFactory.createJdbcTemplate(dbName).queryForObject(sqlCountQuery, Integer.class);
	}

}
