<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:fwf="eu.dnetlib.data.transform.xml.FWFXsltFunctions" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

	<xsl:param name="parentDatasourceId"/>
	<xsl:param name="namespacePrefix"/>

	<xsl:variable name="funderID" select="concat($namespacePrefix, '::FWF')"/>

	<xsl:variable name="fundingCode" select="normalize-space(substring-before(.//column[@name='project number'],' â€“'))"/>
	<xsl:variable name="projectNumber" select="normalize-space(substring-after(.//column[@name='project number'],' â€“ '))"/>
	<xsl:variable name="fundingID">
		<xsl:choose>
			<xsl:when test="string-length($fundingCode) &gt; 0">
				<xsl:value-of select="concat($funderID, '::', $fundingCode)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$funderID"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>


	<xsl:variable name="projectID" select="concat($namespacePrefix, '::', concat($fundingCode,'_',$projectNumber))"/>
	<xsl:variable name="projectCode" select="concat($fundingCode,' ',$projectNumber)"/>

	<xsl:variable name="projectTitle" select=".//column[@name='project title']"/>

	<xsl:variable name="startDate" select=".//column[@name='from']"/>
	<xsl:variable name="endDate" select=".//column[@name='till']"/>
	<xsl:variable name="personId" select="concat($namespacePrefix,translate(normalize-space(.//column[@name='project lead']),' ','_'))"/>
	<xsl:variable name="dateFormat" select="string('yyyy-MM-dd')"/>
	<xsl:variable name="organizationId" select="concat($namespacePrefix,fwf:getMd5(.//column[@name='research place and institute']))"/>
	<xsl:template match="/">
		<xsl:if test="string-length($projectTitle) &gt; 0 and
                      string-length($projectID) &gt; 0">
			<record>

				<xsl:copy-of select=".//*[local-name()='header']"/>

				<metadata>

					<ROWS>

						<ROW table="projects">
							<FIELD name="_dnet_resource_identifier_">
								<xsl:value-of select="$projectID"/>
							</FIELD>
							<FIELD name="id">
								<xsl:value-of select="$projectID"/>
							</FIELD>
							<FIELD name="code">
								<xsl:value-of select="$projectCode"/>
							</FIELD>
							<FIELD name="startdate" type="date" format="{$dateFormat}">
								<xsl:value-of select="$startDate"/>
							</FIELD>
							<FIELD name="enddate" type="date" format="{$dateFormat}">
								<xsl:value-of select="$endDate"/>
							</FIELD>
							<FIELD name="title">
								<xsl:value-of select="$projectTitle"/>
							</FIELD>
							<FIELD name="keywords">
								<xsl:value-of select=".//column[@name='keywords']"/>
							</FIELD>
							<FIELD name="optional1">
								<xsl:variable name="grantAmount" select=".//column[@name='grants awarded']"/>
								<xsl:variable name="tmp" select="substring(normalize-space($grantAmount),1,1)"/>
								<xsl:value-of select="concat($tmp,' ',substring-after($grantAmount,$tmp))"/>
							</FIELD>

							<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
							<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
							<FIELD name="collectedfrom">
								<xsl:value-of select="$parentDatasourceId"/>
							</FIELD>
						</ROW>
						<ROW table="project_fundingpath">
							<FIELD name="_dnet_resource_identifier_">

								<xsl:value-of select="concat($fundingID,'@@', $projectID)"/>
							</FIELD>
							<FIELD name="funding">
								<xsl:value-of select="$fundingID"/>
							</FIELD>
							<FIELD name="project">
								<xsl:value-of select="$projectID"/>
							</FIELD>
							<FIELD name="startdate" type="date" format="{$dateFormat}">
								<xsl:value-of select="$startDate"/>
							</FIELD>
							<FIELD name="enddate" type="date" format="{$dateFormat}">
								<xsl:value-of select="$endDate"/>
							</FIELD>
						</ROW>
						<xsl:if test="string-length($organizationId) &gt; 0">
							<ROW table="organizations">

								<FIELD name="_dnet_resource_identifier_">
									<xsl:value-of select="$organizationId"/>
								</FIELD>
								<FIELD name="id">
									<xsl:value-of select="$organizationId"/>
								</FIELD>
								<FIELD name="legalname">
									<xsl:variable name="orgName" select="normalize-space(.//column[@name='research place and institute'])"/>
									<xsl:choose>
										<xsl:when test="string-length( $orgName) &gt; 255">
											<xsl:value-of select="substring($orgName,0,254)"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="normalize-space($orgName)"/>
										</xsl:otherwise>
									</xsl:choose>


								</FIELD>
								<FIELD name="collectedfrom">
									<xsl:value-of select="$parentDatasourceId"/>
								</FIELD>
								<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
								<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
							</ROW>
						</xsl:if>
						<xsl:if test="string-length($personId) &gt; 0">
							<ROW table="persons">
								<FIELD name="_dnet_resource_identifier_">
									<xsl:value-of select="$personId"/>
								</FIELD>
								<FIELD name="id">
									<xsl:value-of select="$personId"/>
								</FIELD>
								<FIELD name="firstname">
									<xsl:value-of select="fwf:getName(.//column[@name='project lead'],true())"/>
								</FIELD>
								<FIELD name="secondnames">
									<xsl:value-of select="fwf:getName(.//column[@name='project lead'],false())"/>
								</FIELD>
								<FIELD name="collectedfrom">
									<xsl:value-of select="$parentDatasourceId"/>
								</FIELD>
								<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
								<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
							</ROW>
						</xsl:if>

						<xsl:if test="string-length($organizationId) &gt; 0">
							<ROW table="project_organization">
								<FIELD name="_dnet_resource_identifier_">
									<xsl:value-of select='concat($projectID, "@@", $organizationId)'/>
								</FIELD>
								<FIELD name="project">
									<xsl:value-of select="$projectID"/>
								</FIELD>
								<FIELD name="resporganization">
									<xsl:value-of select="$organizationId"/>
								</FIELD>
								<FIELD name="contactperson">
									<xsl:value-of select="$personId"/>
								</FIELD>
								<FIELD name="semanticclass">participant</FIELD>
								<FIELD name="semanticscheme">dnet:project_organization_relations</FIELD>
							</ROW>
						</xsl:if>

					</ROWS>
				</metadata>
			</record>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
