<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:xs="http://www.w3.org/2001/XMLSchema"
				exclude-result-prefixes="xs" version="2.0">

	<xsl:param name="parentDatasourceId"/>
	<xsl:variable name="namespacePrefix" select="xs:string('tubitakf____')"/>
	<xsl:param name="quote">"</xsl:param>

	<xsl:variable name="funderID" select="concat('tubitakf_____', '::tubitak')"/>


	<xsl:variable name="stream" select="normalize-space(.//column[@name='FUNDING STREAM(S)'])"/>
	<xsl:variable name="fundingID">
		<xsl:choose>
			<xsl:when test="string-length($stream) &gt; 0">
				<xsl:value-of select="concat($funderID, '::', $stream)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$funderID"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name="projectId" select="concat($namespacePrefix, '::',  normalize-space(.//column[@name='PROJECT IDENTIFIER']))"/>


	<xsl:variable name="startDate" select="translate(.//column[@name='START DATE'],'/\','--')"/>
	<xsl:variable name="endDate" select="translate(.//column[@name='END DATE'],'/\','--')"/>

	<xsl:variable name="dateFormat" select="string('dd-MM-yyyy')"/>
	<xsl:variable name="projectTitle" select="normalize-space(.//column[@name='PROJECT TITLE or ACRONYM'])"/>

	<xsl:template match="/">
		<record>

			<xsl:copy-of select=".//*[local-name()='header']"/>
			<metadata>
				<ROWS>
					<xsl:if test="string-length($projectTitle) &gt; 0 and string-length($projectId) &gt; 0">
						<ROW table="projects">
							<FIELD name="_dnet_resource_identifier_">
								<xsl:value-of select="$projectId"/>
							</FIELD>
							<FIELD name="id">
								<xsl:value-of select="$projectId"/>
							</FIELD>
							<FIELD name="code">
								<xsl:value-of select="normalize-space(.//column[@name='PROJECT IDENTIFIER'])"/>
							</FIELD>
							<FIELD name="startdate" type="date" format="{$dateFormat}">
								<xsl:value-of select="$startDate"/>
							</FIELD>
							<FIELD name="enddate" type="date" format="{$dateFormat}">
								<xsl:value-of select="$endDate"/>
							</FIELD>
							<FIELD name="title">
								<xsl:value-of select="$projectTitle"/>
							</FIELD>


							<FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
							<FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
							<FIELD name="collectedfrom">
								<xsl:value-of select="$parentDatasourceId"/>
							</FIELD>

							<FIELD name="oa_mandate_for_publications" type="boolean">false</FIELD>

						</ROW>
					</xsl:if>
					<ROW table="project_fundingpath">
						<FIELD name="_dnet_resource_identifier_">
							<xsl:value-of select="concat($fundingID,'@@', $projectId)"/>
						</FIELD>
						<FIELD name="funding">
							<xsl:value-of select="$fundingID"/>
						</FIELD>
						<FIELD name="project">
							<xsl:value-of select="$projectId"/>
						</FIELD>
						<FIELD name="startdate" type="date" format="{$dateFormat}">
							<xsl:value-of select="$startDate"/>
						</FIELD>
						<FIELD name="enddate" type="date" format="{$dateFormat}">
							<xsl:value-of select="$endDate"/>
						</FIELD>
					</ROW>


				</ROWS>
			</metadata>
		</record>
	</xsl:template>
</xsl:stylesheet>