package eu.dnetlib.msro.openaireplus.workflows.nodes.claims;

import java.util.List;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.hadoop.rmi.HadoopService;
import eu.dnetlib.data.proto.KindProtos.Kind;
import eu.dnetlib.data.proto.OafProtos.Oaf;
import eu.dnetlib.data.proto.OafProtos.OafEntity;
import eu.dnetlib.data.proto.ResultProtos.Result;
import eu.dnetlib.data.proto.ResultProtos.Result.Context;
import eu.dnetlib.data.proto.TypeProtos.Type;
import eu.dnetlib.msro.rmi.MSROException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.StringUtils;

/**
 * Created by alessia on 23/10/15.
 */
public class ApplyClaimUpdatesJobNode extends AbstractClaimsToHBASE {

	private static final Log log = LogFactory.getLog(ApplyClaimUpdatesJobNode.class);

	@Override
	protected String execute(NodeToken token) throws Exception {
		//TODO: use claim.claim_date from the claim db
		long timestamp = System.currentTimeMillis();

		List<Claim> claimUpdates = this.getClaimDatabaseUtils().query(getSql());
		int totalClaims = 0;
		int totalWrites = 0;
		int discardedClaims = 0;

		HadoopService hadoopService = getServiceLocator().getService(HadoopService.class);

		for (Claim claim : claimUpdates) {
			try{
			log.debug(claim);
			totalClaims++;
			String contextId = claim.getSource();
			String rowKey = getFullId(getOpenAIREType(claim.getTargetType()), claim.getTarget());

			String value = getValue(contextId, rowKey, claim.getSemantics(), timestamp);
			hadoopService.addHBaseColumn(getClusterName(), getTableName(), rowKey, "result", "update_" + System.nanoTime(), value);
			totalWrites++;
			incrementProcessed();
			} catch (IllegalArgumentException e) {
				log.error("Discarding claim " + claim + ". Cause: " + e.getMessage());
				discardedClaims++;
			}
		}

		log.info("Total Claim Updates: " + totalClaims);
		token.getEnv().setAttribute("claimUpdatesSize", totalClaims);
		log.info("Claim updates writeOps: " + totalWrites);
		token.getEnv().setAttribute("claimUpdatesWriteOps", totalWrites);
		log.info("Discarded Claim Updates: " + discardedClaims);
		token.getEnv().setAttribute("discardedClaimUpdates", discardedClaims);

		return Arc.DEFAULT_ARC;
	}

	protected String getValue(final String sourceId, final String semantics, final String targetId, final long timestamp) throws MSROException {
		log.debug(StringUtils.format("%s -- %s -- %s", sourceId, semantics, targetId));

		Result.Builder resultBuilder = Result.newBuilder().setMetadata(Result.Metadata.newBuilder().addContext(getContext(sourceId)));
		OafEntity.Builder entityBuilder = OafEntity.newBuilder().setId(targetId).setType(Type.result).setResult(resultBuilder);
		Oaf.Builder builder = Oaf.newBuilder().setKind(Kind.entity).setLastupdatetimestamp(timestamp).setEntity(entityBuilder);

		return Base64.encodeBase64String(builder.build().toByteArray());
	}

	private Context getContext(final String sourceId) {
		return Context.newBuilder().setDataInfo(getDataInfo()).setId(sourceId).build();
	}
}
