/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.openaireplus.workflows.nodes.claims;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.hadoop.rmi.HadoopService;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.msro.openaireplus.workflows.nodes.claims.AbstractClaimsToHBASE;
import eu.dnetlib.msro.openaireplus.workflows.nodes.claims.Claim;
import eu.dnetlib.msro.rmi.MSROException;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.StringUtils;

public class ApplyClaimUpdatesJobNode
extends AbstractClaimsToHBASE {
    private static final Log log = LogFactory.getLog(ApplyClaimUpdatesJobNode.class);

    protected String execute(NodeToken token) throws Exception {
        long timestamp = System.currentTimeMillis();
        List<Claim> claimUpdates = this.getClaimDatabaseUtils().query(this.getSql());
        int totalClaims = 0;
        int totalWrites = 0;
        int discardedClaims = 0;
        HadoopService hadoopService = (HadoopService)this.getServiceLocator().getService(HadoopService.class);
        for (Claim claim : claimUpdates) {
            try {
                log.debug((Object)claim);
                ++totalClaims;
                String contextId = claim.getSource();
                String rowKey = this.getFullId(this.getOpenAIREType(claim.getTargetType()), claim.getTarget());
                String value = this.getValue(contextId, rowKey, claim.getSemantics(), timestamp);
                hadoopService.addHBaseColumn(this.getClusterName(), this.getTableName(), rowKey, "result", "update_" + System.nanoTime(), value);
                ++totalWrites;
                this.incrementProcessed();
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("Discarding claim " + claim + ". Cause: " + e.getMessage()));
                ++discardedClaims;
            }
        }
        log.info((Object)("Total Claim Updates: " + totalClaims));
        token.getEnv().setAttribute("claimUpdatesSize", (Object)totalClaims);
        log.info((Object)("Claim updates writeOps: " + totalWrites));
        token.getEnv().setAttribute("claimUpdatesWriteOps", (Object)totalWrites);
        log.info((Object)("Discarded Claim Updates: " + discardedClaims));
        token.getEnv().setAttribute("discardedClaimUpdates", (Object)discardedClaims);
        return Arc.DEFAULT_ARC;
    }

    protected String getValue(String sourceId, String semantics, String targetId, long timestamp) throws MSROException {
        log.debug((Object)StringUtils.format((String)"%s -- %s -- %s", (Object[])new Object[]{sourceId, semantics, targetId}));
        ResultProtos.Result.Builder resultBuilder = ResultProtos.Result.newBuilder().setMetadata(ResultProtos.Result.Metadata.newBuilder().addContext(this.getContext(sourceId)));
        OafProtos.OafEntity.Builder entityBuilder = OafProtos.OafEntity.newBuilder().setId(targetId).setType(TypeProtos.Type.result).setResult(resultBuilder);
        OafProtos.Oaf.Builder builder = OafProtos.Oaf.newBuilder().setKind(KindProtos.Kind.entity).setLastupdatetimestamp(timestamp).setEntity(entityBuilder);
        return Base64.encodeBase64String((byte[])builder.build().toByteArray());
    }

    private ResultProtos.Result.Context getContext(String sourceId) {
        return ResultProtos.Result.Context.newBuilder().setDataInfo(ApplyClaimUpdatesJobNode.getDataInfo()).setId(sourceId).build();
    }
}

