<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:clean="eu.dnetlib.msro.openaireplus.utils.CleaningXsltFunctions"
				version="1.0">

	<xsl:template match="/">
		<ROWS>
			<xsl:variable name="id" select="//FIELD[@name='id']" />
			<xsl:variable name="name" select="//FIELD[@name='name']" />
			<xsl:variable name="class" select="//FIELD[@name='class']" />
			<xsl:variable name="cleanedName">
				<xsl:choose>
					<xsl:when test="string-length(clean:clean($name)) &gt;0 ">
						<xsl:value-of select="clean:clean($name)"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="clean:clean(//FIELD[@name='englishname'])"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>

			<xsl:if test="string-length($cleanedName) &gt; 0">
				<ROW table="datacite_temp_datarepos">
					<FIELD name="_dnet_resource_identifier_">
						<xsl:value-of select="$id"/>
					</FIELD>
					<FIELD name="id">
						<xsl:value-of select="$id"/>
					</FIELD>
					<FIELD name="name">
						<xsl:value-of select="$name"/>
					</FIELD>
					<FIELD name="name_cleaned">
						<xsl:value-of select="$cleanedName"/>
					</FIELD>
					<FIELD name="class">
						<xsl:value-of select="$class"/>
					</FIELD>
				</ROW>
			</xsl:if>

		</ROWS>
	</xsl:template>
</xsl:stylesheet>
